/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.listDlg;

import com.modeliosoft.modelio.api.mdac.ModuleState;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.listDlg.ModulesActivationDlg;
import com.modeliosoft.modelio.app.modules.ui.Messages;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ModulesActivationCellModifier
implements ICellModifier {
    private String[] items = null;
    private ModulesActivationDlg dialog = null;

    public ModulesActivationCellModifier(String[] items, ModulesActivationDlg dialog) {
        this.items = items;
        this.dialog = dialog;
    }

    public boolean canModify(Object element, String property) {
        ModuleAdapter adapter = (ModuleAdapter)element;
        return property.equals("State") && adapter.stateCanBeModify();
    }

    public Object getValue(Object element, String property) {
        ModuleAdapter adapter = (ModuleAdapter)element;
        if (property.equals("State")) {
            String stringValue = "";
            if (adapter.getModuleState() == ModuleState.Activated) {
                stringValue = Messages.getString((String)"ListMdacsDlg.State.Active");
            } else if (adapter.getModuleState() == ModuleState.Desactivated) {
                stringValue = Messages.getString((String)"ListMdacsDlg.State.Inactive");
            } else {
                assert (false) : "Inconsistent module state. Should never happen.";
                stringValue = Messages.getString((String)"ListMdacsDlg.State.Hidden");
            }
            int i = this.items.length - 1;
            while (!stringValue.equals(this.items[i]) && i > 0) {
                --i;
            }
            return new Integer(i);
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (element instanceof TableItem) {
            TableItem tableItem = (TableItem)element;
            ModuleAdapter adapter = (ModuleAdapter)tableItem.getData();
            String state = this.items[(Integer)value];
            if (property.equals("State")) {
                if (state.equals(Messages.getString((String)"ListMdacsDlg.State.Active"))) {
                    adapter.setModuleState(ModuleState.Activated);
                    Set impactedAdapters = this.getImpactedAdapters(adapter);
                    for (ModuleAdapter impactedAdapter : impactedAdapters) {
                        impactedAdapter.setStateCanBeModified(true);
                    }
                } else if (state.equals(Messages.getString((String)"ListMdacsDlg.State.Inactive"))) {
                    adapter.setModuleState(ModuleState.Desactivated);
                    Set impactedAdapters = this.getAllImpactedAdapters(adapter);
                    for (ModuleAdapter impactedAdapter : impactedAdapters) {
                        if (impactedAdapter.getModuleState() == ModuleState.Activated) {
                            impactedAdapter.setModuleState(ModuleState.Desactivated);
                        }
                        impactedAdapter.setStateCanBeModified(false);
                    }
                } else {
                    assert (false) : "This should never happen, what am I doing here?";
                    adapter.setModuleState(ModuleState.Installed);
                    Set impactedAdapters = this.getAllImpactedAdapters(adapter);
                    for (ModuleAdapter impactedAdapter : impactedAdapters) {
                        impactedAdapter.setModuleState(ModuleState.Installed);
                        impactedAdapter.setStateCanBeModified(false);
                    }
                }
            }
        }
        this.dialog.refresh();
    }

    private Set<ModuleAdapter> getImpactedAdapters(ModuleAdapter adapter) {
        HashSet<ModuleAdapter> impactedAdapters = new HashSet<ModuleAdapter>();
        ObList impactedMdacs = adapter.getModule().getImpacted();
        ModuleAdapter impactedAdapter = null;
        for (IModule impactedMdac : impactedMdacs) {
            impactedAdapter = this.dialog.getModuleAdapter(impactedMdac);
            if (impactedAdapter == null) continue;
            impactedAdapters.add(impactedAdapter);
        }
        return impactedAdapters;
    }

    private Set<ModuleAdapter> getAllImpactedAdapters(ModuleAdapter adapter) {
        HashSet<ModuleAdapter> impactedAdapters = new HashSet<ModuleAdapter>();
        HashSet impactedModules = new HashSet();
        this.getAllImpactedMdacs(adapter.getModule(), impactedModules);
        ModuleAdapter impactedAdapter = null;
        for (IModule impactedModule : impactedModules) {
            impactedAdapter = this.dialog.getModuleAdapter(impactedModule);
            if (impactedAdapter == null) continue;
            impactedAdapters.add(impactedAdapter);
        }
        return impactedAdapters;
    }

    private void getAllImpactedMdacs(IModule mdac, Set<IModule> mdacs) {
        ObList impactedMdacs = mdac.getImpacted();
        for (IModule impactedMdac : impactedMdacs) {
            mdacs.add(impactedMdac);
            this.getAllImpactedMdacs(impactedMdac, mdacs);
        }
    }
}

