/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.listDlg;

import com.modeliosoft.modelio.api.mdac.ModuleState;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.listDlg.ModulesActivationDlg;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;

public class ModulesActivationCheckboxListener
implements ICheckStateListener {
    private ModulesActivationDlg dialog = null;

    public ModulesActivationCheckboxListener(ModulesActivationDlg dialog) {
        this.dialog = dialog;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        ModuleAdapter adapter = (ModuleAdapter)event.getElement();
        boolean checked = event.getChecked();
        if (adapter.stateCanBeModify()) {
            if (!checked) {
                adapter.setModuleState(ModuleState.Activated);
                Set impactedAdapters = this.getImpactedAdapters(adapter);
                for (ModuleAdapter impactedAdapter : impactedAdapters) {
                    impactedAdapter.setStateCanBeModified(true);
                }
            } else {
                if (adapter.getInitialState() == ModuleState.Activated) {
                    adapter.setModuleState(ModuleState.Desactivated);
                } else {
                    adapter.setModuleState(adapter.getInitialState());
                }
                Set impactedAdapters = this.getAllImpactedAdapters(adapter);
                for (ModuleAdapter impactedAdapter : impactedAdapters) {
                    impactedAdapter.setModuleState(ModuleState.Desactivated);
                    impactedAdapter.setStateCanBeModified(false);
                }
            }
        }
        this.dialog.refresh();
    }

    private Set<ModuleAdapter> getAllImpactedAdapters(ModuleAdapter adapter) {
        HashSet<ModuleAdapter> impactedAdapters = new HashSet<ModuleAdapter>();
        HashSet impactedModules = new HashSet();
        this.getAllImpactedMdacs(adapter.getModule(), impactedModules);
        ModuleAdapter impactedAdapter = null;
        for (IModule impactedModule : impactedModules) {
            impactedAdapter = this.dialog.getModuleAdapter(impactedModule);
            if (impactedAdapter == null) continue;
            impactedAdapters.add(impactedAdapter);
        }
        return impactedAdapters;
    }

    private void getAllImpactedMdacs(IModule mdac, Set<IModule> mdacs) {
        ObList impactedMdacs = mdac.getImpacted();
        for (IModule impactedMdac : impactedMdacs) {
            mdacs.add(impactedMdac);
            this.getAllImpactedMdacs(impactedMdac, mdacs);
        }
    }

    private Set<ModuleAdapter> getImpactedAdapters(ModuleAdapter adapter) {
        HashSet<ModuleAdapter> impactedAdapters = new HashSet<ModuleAdapter>();
        ObList impactedMdacs = adapter.getModule().getImpacted();
        ModuleAdapter impactedAdapter = null;
        for (IModule impactedMdac : impactedMdacs) {
            impactedAdapter = this.dialog.getModuleAdapter(impactedMdac);
            if (impactedAdapter == null) continue;
            impactedAdapters.add(impactedAdapter);
        }
        return impactedAdapters;
    }
}

