/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.listDlg;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.mdac.ModuleState;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.app.modules.listDlg.MdacListDataProvider;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleSelectionListener;
import com.modeliosoft.modelio.app.modules.listDlg.ModulesActivationCheckboxListener;
import com.modeliosoft.modelio.app.modules.ui.Messages;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class ModulesActivationDlg
extends ModelioDialog {
    protected IModelingSession modelingSession = null;
    List<ModuleAdapter> moduleAdapters = null;
    private ModulesActivationCheckboxListener checkStateListener = null;
    protected Composite composite = null;
    protected CheckboxTableViewer viewer = null;
    Label moduleDescriptionText = null;
    protected Button activeButton = null;
    protected Button inactiveButton = null;
    protected Button hiddenButton = null;

    public Control createContentArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)data);
        FormLayout compositeLayout = new FormLayout();
        this.composite.setLayout((Layout)compositeLayout);
        this.moduleDescriptionText = new Label(this.composite, 576);
        this.moduleDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        FormData fd_moduleDescription = new FormData();
        fd_moduleDescription.left = new FormAttachment(0, 5);
        fd_moduleDescription.right = new FormAttachment(100, -5);
        fd_moduleDescription.top = new FormAttachment(100, -80);
        fd_moduleDescription.bottom = new FormAttachment(100, 0);
        this.moduleDescriptionText.setLayoutData((Object)fd_moduleDescription);
        Group tableGroup = new Group(this.composite, 0);
        tableGroup.setText(Messages.getString((String)"ListMdacsDlg.ModuleStateLabel"));
        tableGroup.setForeground(tableGroup.getDisplay().getSystemColor(3));
        GridLayout gl_tableGroup = new GridLayout(3, false);
        tableGroup.setLayout((Layout)gl_tableGroup);
        this.initTableViewer(tableGroup);
        FormData fd_tableGroup = new FormData();
        fd_tableGroup.left = new FormAttachment(0, 0);
        fd_tableGroup.right = new FormAttachment(100, 0);
        fd_tableGroup.top = new FormAttachment(0, 0);
        fd_tableGroup.bottom = new FormAttachment((Control)this.moduleDescriptionText, -5, 128);
        tableGroup.setLayoutData((Object)fd_tableGroup);
        this.refresh();
        return this.composite;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"ListMdacsDlg.Title"));
        this.setTitle(Messages.getString((String)"ListMdacsDlg.Title"));
        this.setMessage(Messages.getString((String)"ListMdacsDlg.Description"));
        this.getShell().setMinimumSize(600, 400);
    }

    public ModulesActivationDlg(Shell parentShell, IModelingSession sess) {
        super(parentShell);
        this.modelingSession = sess;
        ObList mdacs = this.modelingSession.getModel().getProject().getInstalled();
        this.moduleAdapters = new ArrayList();
        MdacManager mdacManager = new MdacManager(this.modelingSession);
        for (IModule module : mdacs) {
            String javaClassName = module.getjavaClassName();
            IMdac mdac = this.loadModule(module);
            if (javaClassName.equals("<FAKE>") || mdac == null) continue;
            this.moduleAdapters.add(new ModuleAdapter(module, mdac, mdacManager));
        }
    }

    void refresh() {
        for (ModuleAdapter moduleAdapter : this.moduleAdapters) {
            if (moduleAdapter.getModuleState() == ModuleState.Activated) {
                this.viewer.setChecked((Object)moduleAdapter, true);
                continue;
            }
            this.viewer.setChecked((Object)moduleAdapter, false);
        }
        this.viewer.refresh();
    }

    void setModuleDescription(String description) {
        this.moduleDescriptionText.setText(description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        MdacManager mdacManager = new MdacManager(this.modelingSession);
        ITransactionManager transactionManager = this.modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Manage module activation");
        try {
            try {
                for (ModuleAdapter adapter : this.moduleAdapters) {
                    IMdac mdac;
                    ModuleState currentState = mdacManager.isActivated(adapter.getModule()) ? ModuleState.Activated : ModuleState.Desactivated;
                    ModuleState requiredState = adapter.getModuleState();
                    IModule mdacModel = adapter.getModule();
                    IMdacRegistry mdacRegistry = this.modelingSession.getMdacRegistry();
                    boolean restartWeakDependencies = false;
                    if (requiredState == ModuleState.Activated) {
                        if (currentState == ModuleState.Desactivated) {
                            mdacManager.activate(mdacModel);
                        }
                        if ((mdac = mdacRegistry.getLoadedMdac(mdacModel)) != null) {
                            mdacManager.startMdac(mdac);
                            restartWeakDependencies = true;
                        }
                    } else if (requiredState == ModuleState.Desactivated && currentState == ModuleState.Activated) {
                        if (adapter.getMdacState() == IMdac.MdacState.Started && (mdac = mdacRegistry.getStartedMdac(adapter.getModule())) != null) {
                            mdacManager.stopMdac(mdac);
                        }
                        mdacManager.deactivate(mdacModel);
                        restartWeakDependencies = true;
                    }
                    if (!restartWeakDependencies) continue;
                    List weakImpactedModules = mdacManager.getWeakImpactedModules(adapter.getModule());
                    for (IModule weakImpactedModule : weakImpactedModules) {
                        IMdac weakImpactedMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(weakImpactedModule);
                        if (weakImpactedMdac == null || !mdacManager.isActivated(weakImpactedModule) || this.getModuleAdapter(weakImpactedModule).getModuleState() != ModuleState.Activated) continue;
                        mdacManager.restartModule(weakImpactedMdac);
                    }
                }
                transactionManager.commit(transaction);
                transaction = null;
                super.okPressed();
                return;
            }
            catch (MdacException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"Error"), (String)e.getLocalizedMessage());
                this.refresh();
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                e.printStackTrace();
                this.refresh();
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    ModuleAdapter getModuleAdapter(IModule mdac) {
        for (ModuleAdapter adapter : this.moduleAdapters) {
            if (!adapter.getModule().equals((Object)mdac)) continue;
            return adapter;
        }
        return null;
    }

    private void initTableViewer(Group tableGroup) {
        String[] columnNames = new String[]{"Name", "Version", "State"};
        this.viewer = CheckboxTableViewer.newCheckList((Composite)tableGroup, (int)67620);
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn column0 = new TableColumn(this.viewer.getTable(), 16384, 0);
        column0.setWidth(200);
        column0.setText(Messages.getString((String)"ListMdacsDlg.Name"));
        TableColumn column1 = new TableColumn(this.viewer.getTable(), 16384, 1);
        column1.setWidth(100);
        column1.setText(Messages.getString((String)"ListMdacsDlg.Version"));
        TableColumn column2 = new TableColumn(this.viewer.getTable(), 16384, 2);
        column2.setWidth(150);
        column2.setText(Messages.getString((String)"ListMdacsDlg.ModuleState.Title"));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ModuleSelectionListener(this, this.modelingSession));
        this.viewer.setColumnProperties(columnNames);
        this.checkStateListener = new ModulesActivationCheckboxListener(this);
        this.viewer.addCheckStateListener((ICheckStateListener)this.checkStateListener);
        GridData gd_tableData = new GridData();
        gd_tableData.horizontalAlignment = 4;
        gd_tableData.verticalAlignment = 4;
        gd_tableData.grabExcessHorizontalSpace = true;
        gd_tableData.grabExcessVerticalSpace = true;
        gd_tableData.horizontalSpan = 3;
        gd_tableData.verticalSpan = 1;
        this.viewer.getTable().setLayoutData((Object)gd_tableData);
        MdacListDataProvider dataProvider = new MdacListDataProvider(this.modelingSession);
        this.viewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        this.viewer.setContentProvider((IContentProvider)dataProvider);
        this.viewer.setInput((Object)this.moduleAdapters);
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Modeler-_modeler_managing_projects_working_with_modules.html";
    }

    private IMdac loadModule(IModule mdacModel) {
        IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(mdacModel);
        if (mdac == null) {
            try {
                MdacManager mdacManager = new MdacManager(this.modelingSession);
                mdac = mdacManager.loadMdac(mdacModel);
            }
            catch (MdacException mdacException) {
                // empty catch block
            }
        }
        return mdac;
    }
}

