/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.removeDlg;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.app.modules.removeDlg.MdacListDataProvider;
import com.modeliosoft.modelio.app.modules.removeDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.removeDlg.ModuleRemovalDlg;
import com.modeliosoft.modelio.app.modules.removeDlg.ModuleSelectionListener;
import com.modeliosoft.modelio.app.modules.ui.Messages;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mdainfra.mdacs.core.FakeModule;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModuleRemovalDlg
extends ModelioDialog {
    protected IModelingSession modelingSession = null;
    List<ModuleAdapter> moduleAdapters = null;
    protected Composite composite = null;
    protected TableViewer viewer = null;
    Label moduleDescriptionText = null;
    protected Button deleteButton = null;
    private Image deleteImage;
    private ModuleAdapter lastSelection = null;

    public Control createContentArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)data);
        FormLayout compositeFormLayout = new FormLayout();
        this.composite.setLayout((Layout)compositeFormLayout);
        this.moduleDescriptionText = new Label(this.composite, 576);
        this.moduleDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        FormData fd_moduleDescription = new FormData();
        fd_moduleDescription.left = new FormAttachment(0, 5);
        fd_moduleDescription.right = new FormAttachment(100, -5);
        fd_moduleDescription.top = new FormAttachment(100, -80);
        fd_moduleDescription.bottom = new FormAttachment(100, 0);
        this.moduleDescriptionText.setLayoutData((Object)fd_moduleDescription);
        Composite buttonContainer = new Composite(this.composite, 0);
        FormData fd_button = new FormData();
        fd_button.right = new FormAttachment(100, 0);
        fd_button.top = new FormAttachment(0, 0);
        fd_button.bottom = new FormAttachment((Control)this.moduleDescriptionText, -5, 128);
        buttonContainer.setLayoutData((Object)fd_button);
        buttonContainer.setLayout((Layout)new GridLayout(1, true));
        this.deleteButton = new Button(buttonContainer, 8);
        GridData gd_button = new GridData(0x1000000, 0x1000000, true, true);
        this.deleteButton.setLayoutData((Object)gd_button);
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.modules", (String)"icons/remove_module_16.png");
        this.deleteImage = desc.createImage();
        this.deleteButton.setImage(this.deleteImage);
        this.deleteButton.setText(Messages.getString((String)"RemoveMdacsDlg.DeleteButtonText"));
        this.deleteButton.addSelectionListener((SelectionListener)new ButtonHandler(this, this.modelingSession));
        Group tableGroup = new Group(this.composite, 0);
        tableGroup.setText(Messages.getString((String)"RemoveMdacsDlg.GroupLabel"));
        tableGroup.setForeground(tableGroup.getDisplay().getSystemColor(3));
        GridLayout gl_tableGroup = new GridLayout(2, false);
        tableGroup.setLayout((Layout)gl_tableGroup);
        this.initTableViewer(tableGroup);
        FormData fd_tableGroup = new FormData();
        fd_tableGroup.left = new FormAttachment(0, 0);
        fd_tableGroup.right = new FormAttachment((Control)buttonContainer, -5, 16384);
        fd_tableGroup.top = new FormAttachment(0, 0);
        fd_tableGroup.bottom = new FormAttachment((Control)this.moduleDescriptionText, -5, 128);
        tableGroup.setLayoutData((Object)fd_tableGroup);
        this.refresh(null);
        return this.composite;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"RemoveMdacsDlg.Title"));
        this.setTitle(Messages.getString((String)"RemoveMdacsDlg.Title"));
        this.setMessage(Messages.getString((String)"RemoveMdacsDlg.Description"));
        this.getShell().setMinimumSize(600, 400);
    }

    public ModuleRemovalDlg(Shell parentShell, IModelingSession sess) {
        super(parentShell);
        this.modelingSession = sess;
        this.refreshModuleList();
    }

    void refresh(ModuleAdapter adapter) {
        if (adapter != null) {
            this.deleteButton.setEnabled(true);
            IMdac mdac = adapter.getMdac();
            if (mdac != null) {
                this.moduleDescriptionText.setText(mdac.getDescription());
            } else {
                this.moduleDescriptionText.setText("");
            }
        } else {
            this.deleteButton.setEnabled(false);
            this.moduleDescriptionText.setText("");
        }
        this.viewer.refresh();
        this.setLastSelection(adapter);
    }

    ModuleAdapter getModuleAdapter(IModule mdac) {
        for (ModuleAdapter adapter : this.moduleAdapters) {
            if (!adapter.getModule().equals((Object)mdac)) continue;
            return adapter;
        }
        return null;
    }

    private void initTableViewer(Group tableGroup) {
        String[] columnNames = new String[]{"Name", "Version"};
        this.viewer = new TableViewer((Composite)tableGroup, 67588);
        this.viewer.getTable().setHeaderVisible(true);
        TableColumn column0 = new TableColumn(this.viewer.getTable(), 16384, 0);
        column0.setWidth(200);
        column0.setText(Messages.getString((String)"Name"));
        TableColumn column1 = new TableColumn(this.viewer.getTable(), 16384, 1);
        column1.setWidth(100);
        column1.setText(Messages.getString((String)"Version"));
        this.viewer.setColumnProperties(columnNames);
        GridData gd_tableData = new GridData();
        gd_tableData.horizontalAlignment = 4;
        gd_tableData.verticalAlignment = 4;
        gd_tableData.grabExcessHorizontalSpace = true;
        gd_tableData.grabExcessVerticalSpace = true;
        gd_tableData.horizontalSpan = 2;
        gd_tableData.verticalSpan = 1;
        this.viewer.getTable().setLayoutData((Object)gd_tableData);
        MdacListDataProvider dataProvider = new MdacListDataProvider(this.modelingSession);
        this.viewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        this.viewer.setContentProvider((IContentProvider)dataProvider);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ModuleSelectionListener(this));
        this.viewer.setInput((Object)this.moduleAdapters);
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Modeler-_modeler_managing_projects_working_with_modules.html";
    }

    private IMdac getLoadedModule(IModule mdacModel) {
        IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(mdacModel);
        if (mdac == null) {
            try {
                MdacManager mdacManager = new MdacManager(this.modelingSession);
                mdac = mdacManager.loadMdac(mdacModel);
            }
            catch (MdacException mdacException) {
                // empty catch block
            }
        }
        return mdac;
    }

    void refreshModuleList() {
        ObList mdacs = this.modelingSession.getModel().getProject().getInstalled();
        this.moduleAdapters = new ArrayList();
        for (IModule module : mdacs) {
            IMdac mdac = this.getLoadedModule(module);
            if (mdac == null || mdac instanceof FakeModule || "ModelerModule".equals(mdac.getName())) continue;
            this.moduleAdapters.add(new ModuleAdapter(module, mdac));
        }
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.moduleAdapters);
        }
    }

    public boolean close() {
        if (this.deleteImage != null) {
            this.deleteImage.dispose();
            this.deleteImage = null;
        }
        return super.close();
    }

    ModuleAdapter getLastSelection() {
        return this.lastSelection;
    }

    void setLastSelection(ModuleAdapter lastSelection) {
        this.lastSelection = lastSelection;
    }
}

