/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.microsoft.editor;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocFileUtil;
import com.modeliosoft.modelio.edition.extern.microsoft.editor.EWdSaveFormat;
import com.modeliosoft.modelio.edition.extern.microsoft.plugin.MicrosoftEditors;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class MicrosoftDocumentViewer {
    private boolean allowWrite = true;
    private OleClientSite oleSite;
    private OleFrame oleFrame;

    MicrosoftDocumentViewer() {
    }

    public void close() {
        if (this.oleSite != null) {
            this.oleSite.dispose();
        }
    }

    public void createDocument(IExternDocument doc) throws IOException {
        DocumentFormat docFormat;
        String programId;
        File file = ExternDocFileUtil.getFile((IExternDocument)doc);
        File parentDir = file.getParentFile();
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
            if (!parentDir.isDirectory()) {
                throw new IOException("Failed create needed '" + file.getParent() + "' directory.");
            }
        }
        if (this.oleSite != null) {
            this.oleSite.dispose();
        }
        if ((programId = (docFormat = O.getDefault().getDocumentFormatsRegistry().getFormat(doc)).getData()) == null) {
            this.oleSite = new OleClientSite((Composite)this.oleFrame, 0, "Word.Document");
            EWdSaveFormat fileFormat = this.getFileFormat(file);
            this.createAsFormat(this.oleSite, file.getPath(), fileFormat);
            this.oleSite.dispose();
        } else {
            this.oleSite = new OleClientSite((Composite)this.oleFrame, 0, programId);
            boolean saveOk = this.oleSite.save(file, true);
            this.oleSite.dispose();
            if (!saveOk) {
                throw new IOException("Save of '" + file.getPath() + "' failed.");
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.oleFrame = new OleFrame(parent, 4096);
        this.oleFrame.setBackground(JFaceColors.getBannerBackground((Display)this.oleFrame.getDisplay()));
    }

    public void focusGot() {
        this.updateOleGui();
    }

    public void focusLost() {
        this.oleSite.deactivateInPlaceClient();
    }

    public boolean isDirty() {
        if (this.oleSite == null) {
            return false;
        }
        return this.oleSite.isDirty() && this.allowWrite;
    }

    public boolean isDisposed() {
        return this.oleSite == null || this.oleSite.isDisposed();
    }

    public void openDocument(File file, String oleProgId) throws IOException {
        if (this.oleSite != null) {
            this.oleSite.dispose();
        }
        try {
            this.oleSite = oleProgId == null || oleProgId.isEmpty() ? new OleClientSite((Composite)this.oleFrame, 0, "Word.Document", file) : new OleClientSite((Composite)this.oleFrame, 0, oleProgId, file);
            this.oleSite.setBackground(JFaceColors.getBannerBackground((Display)this.oleSite.getDisplay()));
            this.focusGot();
        }
        catch (SWTException e) {
            throw new IOException(e);
        }
    }

    public void saveDocument(File file) throws IOException {
        EWdSaveFormat fileFormat;
        EWdSaveFormat eWdSaveFormat = fileFormat = OLE.isOleFile((File)file) ? EWdSaveFormat.FormatOle : this.getFileFormat(file);
        if (fileFormat == EWdSaveFormat.FormatOle) {
            if (!this.oleSite.save(file, true)) {
                throw new IOException("Save of '" + file.getPath() + "'failed.");
            }
        } else {
            this.saveFormat(this.oleSite, file);
        }
    }

    public void saveDocumentAs() throws IOException {
        int options = 0;
        Variant in = null;
        Variant out = null;
        this.oleSite.exec(4, options, in, out);
    }

    public void setWriteable(boolean writeable) {
        if (this.allowWrite != writeable) {
            this.allowWrite = writeable;
            this.updateOleGui();
        }
    }

    private void updateOleGui() {
        this.oleSite.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    void doUpdateOleGui() {
        if (this.oleSite.isDisposed() || !this.oleSite.isVisible()) {
            return;
        }
        this.oleSite.doVerb(-5);
    }

    private void saveAsFormat(OleClientSite clientSite, String fileName) throws IOException {
        OleAutomation activeDoc = new OleAutomation(clientSite);
        try {
            int[] rgdispid = activeDoc.getIDsOfNames(new String[]{"SaveAs", "FileName", "FileFormat"});
            Variant[] rgvarg = new Variant[]{new Variant(fileName)};
            int[] idNamedArgs = new int[]{rgdispid[1]};
            try {
                activeDoc.invokeNoReply(rgdispid[0], rgvarg, idNamedArgs);
            }
            catch (SWTException e) {
                String lerr = activeDoc.getLastError();
                if (lerr == null || lerr.isEmpty()) {
                    lerr = e.getMessage();
                }
                throw new IOException(lerr, e);
            }
        }
        finally {
            activeDoc.dispose();
        }
    }

    private void saveFormat(OleClientSite clientSite, File file) throws IOException {
        File tempFile = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
        this.renameFile(file, tempFile);
        boolean saved = false;
        try {
            this.saveAsFormat(clientSite, file.getPath());
            saved = true;
        }
        finally {
            if (saved) {
                tempFile.delete();
            } else {
                tempFile.renameTo(file);
            }
        }
    }

    private void renameFile(File file, File tempFile) {
        Path src = FileSystems.getDefault().getPath(file.getPath(), new String[0]);
        Path dest = FileSystems.getDefault().getPath(tempFile.getPath(), new String[0]);
        try {
            Files.move(src, dest, new CopyOption[0]);
        }
        catch (IOException e) {
            System.err.println("Rename backup '" + tempFile + "' failed:" + e.getMessage());
        }
    }

    private void printCurrentDocs(OleAutomation application) {
        int[] pId = application.getIDsOfNames(new String[]{"Documents"});
        Variant pVarResult = application.getProperty(pId[0]);
        OleAutomation docs = pVarResult.getAutomation();
        pId = docs.getIDsOfNames(new String[]{"Count"});
        pVarResult = docs.getProperty(pId[0]);
        int nbDocs = pVarResult.getInt();
        System.out.println(String.valueOf(nbDocs) + " documents currently in Word");
        int[] pItemId = docs.getIDsOfNames(new String[]{"Item"});
        int i = 1;
        while (i <= nbDocs) {
            Variant vdoc = docs.invoke(pItemId[0], new Variant[]{new Variant(i)});
            OleAutomation doc = vdoc.getAutomation();
            pId = doc.getIDsOfNames(new String[]{"Path"});
            pVarResult = docs.getProperty(pId[0]);
            String docPath = pVarResult == null ? "<null>" : pVarResult.getString();
            pId = doc.getIDsOfNames(new String[]{"Name"});
            pVarResult = docs.getProperty(pId[0]);
            String name = pVarResult == null ? "<null>" : pVarResult.getString();
            System.out.println("  - " + name + ":" + docPath);
            doc.dispose();
            ++i;
        }
        docs.dispose();
    }

    private void createAsFormat(OleClientSite clientSite, String fileName, EWdSaveFormat format) throws IOException {
        OleClientSite newSite = null;
        OleAutomation dispInterface = null;
        OleAutomation activeDoc = null;
        OleAutomation application = null;
        try {
            newSite = this.createWordApplicationClientSite(clientSite.getParent());
            dispInterface = new OleAutomation(newSite);
            int[] appId = dispInterface.getIDsOfNames(new String[]{"Application"});
            Variant pVarResult = dispInterface.getProperty(appId[0]);
            application = pVarResult.getAutomation();
            int[] pId = application.getIDsOfNames(new String[]{"Documents"});
            pVarResult = application.getProperty(pId[0]);
            OleAutomation docs = pVarResult.getAutomation();
            pId = docs.getIDsOfNames(new String[]{"Count"});
            pVarResult = docs.getProperty(pId[0]);
            int nbDocs = pVarResult.getInt();
            System.out.println(String.valueOf(nbDocs) + " documents currently in Word");
            pId = docs.getIDsOfNames(new String[]{"Add", "Visible"});
            pVarResult = docs.invoke(pId[0], new Variant[]{new Variant(false)}, new int[]{pId[1]});
            if (pVarResult == null) {
                docs.dispose();
                throw new IOException(docs.getLastError());
            }
            activeDoc = pVarResult.getAutomation();
            docs.dispose();
            int[] rgdispid = activeDoc.getIDsOfNames(new String[]{"SaveAs", "FileName", "FileFormat"});
            Variant[] rgvarg = new Variant[2];
            int[] idNamedArgs = new int[2];
            rgvarg[0] = new Variant(fileName);
            idNamedArgs[0] = rgdispid[1];
            rgvarg[1] = new Variant(format.getValue());
            idNamedArgs[1] = rgdispid[2];
            activeDoc.invokeNoReply(rgdispid[0], rgvarg, idNamedArgs);
            pId = activeDoc.getIDsOfNames(new String[]{"Close", "SaveChanges", "OriginalFormat", "RouteDocument"});
            try {
                activeDoc.invokeNoReply(pId[0], new Variant[]{new Variant(0)}, new int[]{pId[1]});
            }
            catch (SWTException e) {
                MicrosoftEditors.LOG.error("Couldn't save '" + fileName + "' to " + format + " format. See the error below.");
                throw new IOException(activeDoc.getLastError(), e);
            }
        }
        finally {
            if (activeDoc != null) {
                activeDoc.dispose();
            }
            if (application != null) {
                application.dispose();
            }
            if (dispInterface != null) {
                dispInterface.dispose();
            }
            if (newSite != null) {
                newSite.dispose();
            }
        }
    }

    private EWdSaveFormat getFileFormat(File file) {
        String name = file.getName();
        String ext = name.substring(name.indexOf("."));
        if (ext.equals(".rtf")) {
            return EWdSaveFormat.wdFormatRTF;
        }
        if (ext.equals(".html")) {
            return EWdSaveFormat.wdFormatFilteredHTML;
        }
        if (ext.equals(".doc")) {
            return EWdSaveFormat.wdFormatDocument97;
        }
        if (ext.equals(".docx")) {
            return EWdSaveFormat.wdFormatXMLDocument;
        }
        return EWdSaveFormat.FormatOle;
    }

    private OleClientSite createWordApplicationClientSite(Composite composite) throws IOException {
        String[] names = new String[]{"Word.Application.14", "Word.Application.12", "Word.Application.8", "Word.Application.6", "Word.Application"};
        SWTException lastErr = null;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                OleClientSite newSite = new OleClientSite(composite, 0, name);
                return newSite;
            }
            catch (SWTException e) {
                if (e.code != 1001 && e.code != 1004) {
                    throw new IOException(e);
                }
                lastErr = e;
                ++n2;
            }
        }
        throw new IOException(lastErr);
    }
}

