/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.microsoft.editor;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocFileUtil;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocLabelProvider;
import com.modeliosoft.modelio.edition.extern.microsoft.editor.MicrosoftDocumentViewer;
import com.modeliosoft.modelio.edition.extern.microsoft.editor.MicrosoftEditor;
import com.modeliosoft.modelio.edition.extern.microsoft.editor.MicrosoftEditorInput;
import com.modeliosoft.modelio.edition.extern.microsoft.plugin.MicrosoftEditors;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorPart;

public class MicrosoftEditor
extends EditorPart {
    public static final String EDITOR_ID = "com.modeliosoft.modelio.edition.extern.microsoft.editor";
    private static final String CONTEXT_ID = "edition.extern.microsoft.context";
    private DirtyWatcher dirtyWatcher = new DirtyWatcher(this);
    private MicrosoftDocumentViewer viewer;
    private ModelListener modelListener;

    public void createPartControl(Composite parent) {
        try {
            this.viewer = new MicrosoftDocumentViewer();
            this.viewer.createPartControl(parent);
            if (this.getEditedElement() != null) {
                this.loadElement(this.getEditedElement());
            }
            this.dirtyWatcher.start();
        }
        catch (RuntimeException e) {
            this.createErrorPartControl(parent, (Throwable)e);
        }
    }

    public void dispose() {
        this.unregisterListener();
        if (this.viewer != null) {
            this.viewer.close();
        }
        if (this.dirtyWatcher != null) {
            this.dirtyWatcher.interrupt();
            this.dirtyWatcher = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IElement element = this.getEditedElement();
        try {
            if (element instanceof IArtifact) {
                IArtifact art = (IArtifact)element;
                String fileName = art.getFileName();
                File f = new File(fileName);
                this.viewer.saveDocument(f);
            } else if (element instanceof IExternDocument) {
                IExternDocument doc = (IExternDocument)element;
                File f = ExternDocFileUtil.getFile((IExternDocument)doc);
                this.viewer.saveDocument(f);
            }
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.edition.extern.microsoft", (Throwable)e);
            MessageDialog.openError(null, (String)("Cannot save " + element), (String)e.getLocalizedMessage());
        }
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        IElement element = this.getEditedElement();
        try {
            if (element instanceof IArtifact) {
                this.viewer.saveDocumentAs();
            } else if (element instanceof IExternDocument) {
                this.viewer.saveDocumentAs();
            }
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.edition.extern.microsoft", (Throwable)e);
            MessageDialog.openError(null, (String)("Cannot save " + element), (String)e.getLocalizedMessage());
        }
    }

    public MicrosoftEditorInput getEditorInput() {
        return (MicrosoftEditorInput)super.getEditorInput();
    }

    private String getProgramId(IExternDocument doc) {
        DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getFormat(doc);
        if (format == null) {
            return null;
        }
        for (String ext : format.getFileExtensions()) {
            String progId = OLE.findProgramID((String)ext);
            if (progId == null || progId.isEmpty()) continue;
            return progId;
        }
        if (format.getData() != null) {
            return format.getData();
        }
        return null;
    }

    public Image getTitleImage() {
        IElement el = this.getEditedElement();
        if (el == null) {
            return super.getTitleImage();
        }
        if (el instanceof IExternDocument) {
            return ExternDocLabelProvider.getIcon((IExternDocument)((IExternDocument)el));
        }
        return StandardImageService.getStereotypedImage((IElement)el, null);
    }

    public String getTitle() {
        IElement el = this.getEditedElement();
        if (el == null) {
            return super.getTitle();
        }
        String title = el instanceof IExternDocument ? ExternDocLabelProvider.getLabel((IExternDocument)((IExternDocument)el)) : el.getName();
        if (el.getElementStatus().isModifiable()) {
            return title;
        }
        return String.valueOf(title) + MicrosoftEditors.I18N.getString("read_only");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        IContextService service = (IContextService)site.getService(IContextService.class);
        service.activateContext(CONTEXT_ID);
        this.getSite().getPage().addPartListener((IPartListener)new PartListener(this));
        if (!(input instanceof MicrosoftEditorInput)) {
            throw new PartInitException(input + " is not a MicrosoftEditorInput");
        }
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.viewer.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void setFocus() {
    }

    MicrosoftDocumentViewer getViewer() {
        return this.viewer;
    }

    protected void setInput(IEditorInput input) {
        MicrosoftEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        if (oldInput != null) {
            this.unregisterListener();
            this.viewer.close();
        }
        super.setInput(input);
        if (input == null) {
            this.viewer.close();
        } else {
            if (this.viewer != null) {
                this.loadElement(this.getEditedElement());
            }
            this.modelListener = new ModelListener(this, (MicrosoftEditorInput)input);
        }
        this.firePropertyChange(1);
    }

    private void createErrorPartControl(Composite parent, Throwable e) {
        Text text = new Text(parent, 2);
        text.setText(e.toString());
        LOG.error((String)"org.modelio.edition.extern.microsoft", (Throwable)e);
    }

    private File getAbsoluteFile(String fileName) {
        String f = fileName.replaceAll("\\{\\$project}", "");
        return new File(this.getEditorInput().getModelingSession().getProjectSpacePath(), f);
    }

    private IElement getEditedElement() {
        MicrosoftEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return editorInput.getEditedElement();
    }

    private void loadArtifact(IArtifact art) throws IOException, FileNotFoundException {
        String fileName = art.getFileName();
        File f = new File(fileName);
        if (!f.isFile()) {
            f = this.getAbsoluteFile(fileName);
        }
        if (!f.isFile()) {
            throw new FileNotFoundException("'" + fileName + "' not found.");
        }
        this.viewer.openDocument(f, this.getProgramID(f));
    }

    private void loadElement(IElement element) {
        try {
            if (element instanceof IArtifact) {
                IArtifact art = (IArtifact)element;
                this.loadArtifact(art);
            } else if (element instanceof IExternDocument) {
                IExternDocument doc = (IExternDocument)element;
                this.loadExternDocument(doc);
            } else {
                MessageDialog.openError(null, (String)"Cannot load element.", (String)(element + " is not handled."));
            }
            boolean writeMode = element.getElementStatus().isModifiable();
            this.viewer.setWriteable(writeMode);
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.edition.extern.microsoft", (Throwable)e);
            MessageDialog.openError(null, (String)("Cannot load " + element), (String)e.getLocalizedMessage());
        }
    }

    private void loadExternDocument(IExternDocument doc) throws IOException {
        File f = ExternDocFileUtil.getFile((IExternDocument)doc);
        if (f.isFile()) {
            this.viewer.openDocument(f, this.getProgramId(doc));
        } else {
            this.viewer.createDocument(doc);
            this.viewer.openDocument(f, this.getProgramId(doc));
        }
    }

    private void unregisterListener() {
        if (this.modelListener != null) {
            this.modelListener.dispose();
            this.modelListener = null;
        }
    }

    static void displayErrordialog(String title, String message, boolean modal) {
        1 runnable = new /* Unavailable Anonymous Inner Class!! */;
        if (modal) {
            Display.getDefault().syncExec((Runnable)runnable);
        } else {
            Display.getDefault().asyncExec((Runnable)runnable);
        }
    }

    private String getProgramID(File f) {
        String name = f.getName();
        String ext = name.substring(name.indexOf("."));
        return OLE.findProgramID((String)ext);
    }

    static /* synthetic */ void access$1(MicrosoftEditor microsoftEditor, int n) {
        microsoftEditor.firePropertyChange(n);
    }

    static /* synthetic */ MicrosoftDocumentViewer access$2(MicrosoftEditor microsoftEditor) {
        return microsoftEditor.viewer;
    }
}

