/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.extern.microsoft.testOle;

import com.modeliosoft.modelio.edition.extern.microsoft.testOle.OleEditor;
import com.modeliosoft.modelio.edition.extern.microsoft.testOle.OleMessages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

/*
 * Exception performing whole class analysis ignored.
 */
class OleEditor
extends EditorPart {
    private IResourceChangeListener resourceListener = new /* Unavailable Anonymous Inner Class!! */;
    private File source;
    private IFile resource;
    private Image oleTitleImage;
    boolean sourceDeleted = false;
    boolean sourceChanged = false;
    private boolean clientActive = false;
    private boolean oleActivated = false;
    private IPartListener partListener = new /* Unavailable Anonymous Inner Class!! */;
    private static final String RENAME_ERROR_TITLE = OleMessages.getString((String)"OleEditor.errorSaving");
    private static final String OLE_EXCEPTION_TITLE = OleMessages.getString((String)"OleEditor.oleExceptionTitle");
    private static final String OLE_EXCEPTION_MESSAGE = OleMessages.getString((String)"OleEditor.oleExceptionMessage");
    private static final String OLE_CREATE_EXCEPTION_MESSAGE = OleMessages.getString((String)"OleEditor.oleCreationExceptionMessage");
    private static final String OLE_CREATE_EXCEPTION_REASON = OleMessages.getString((String)"OleEditor.oleCreationExceptionReason");
    private static final String SAVE_ERROR_TITLE = OleMessages.getString((String)"OleEditor.savingTitle");
    private static final String SAVE_ERROR_MESSAGE = OleMessages.getString((String)"OleEditor.savingMessage");
    private boolean isDirty = false;
    private OleFrame clientFrame;
    private OleClientSite clientSite;

    void activateClient(IWorkbenchPart part) {
        if (part == this) {
            this.oleActivate();
            this.clientActive = true;
        }
    }

    public void createPartControl(Composite parent) {
        this.clientFrame = new OleFrame(parent, 4096);
        this.clientFrame.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
        this.initializeWorkbenchMenus();
        this.createClientSite();
        this.updateDirtyFlag();
    }

    private void createClientSite() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        try {
            this.clientSite = new OleClientSite((Composite)this.clientFrame, 0, this.source);
        }
        catch (SWTException exception) {
            Status errorStatus = new Status(4, "org.eclipse.ui", 4, OLE_CREATE_EXCEPTION_REASON, (Throwable)exception);
            ErrorDialog.openError(null, (String)OLE_EXCEPTION_TITLE, (String)OLE_CREATE_EXCEPTION_MESSAGE, (IStatus)errorStatus);
            return;
        }
        this.clientSite.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
    }

    void deactivateClient(IWorkbenchPart part) {
        if (part == this && this.clientActive) {
            if (this.clientSite != null) {
                this.clientSite.deactivateInPlaceClient();
            }
            this.clientActive = false;
            this.oleActivated = false;
        }
    }

    void displayErrorDialog(String title, String message) {
        Shell parent = null;
        if (this.getClientSite() != null) {
            parent = this.getClientSite().getShell();
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)message);
    }

    public void dispose() {
        if (this.resource != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resource = null;
        }
        if (this.oleTitleImage != null) {
            this.oleTitleImage.dispose();
            this.oleTitleImage = null;
        }
        if (this.getSite() != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
    }

    public void doPrint() {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doSaveAs() {
        if (this.clientSite == null) {
            return;
        }
        WorkspaceModifyOperation op = this.saveNewFileOperation();
        Shell shell = this.clientSite.getShell();
        try {
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationException) {
            MessageDialog.openError((Shell)shell, (String)RENAME_ERROR_TITLE, (String)invocationException.getTargetException().getMessage());
        }
    }

    public OleClientSite getClientSite() {
        return this.clientSite;
    }

    public File getSourceFile() {
        return this.source;
    }

    private void handleWord() {
        Variant pVarResult;
        OleAutomation dispInterface = new OleAutomation(this.clientSite);
        int[] appId = dispInterface.getIDsOfNames(new String[]{"Application"});
        if (appId != null && (pVarResult = dispInterface.getProperty(appId[0])) != null) {
            OleAutomation application = pVarResult.getAutomation();
            int[] dispid = application.getIDsOfNames(new String[]{"DisplayScrollBars"});
            if (dispid != null) {
                Variant rgvarg = new Variant(true);
                application.setProperty(dispid[0], rgvarg);
            }
            application.dispose();
        }
        dispInterface.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.validatePathEditorInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
        ImageDescriptor desc = input.getImageDescriptor();
        if (desc != null) {
            this.oleTitleImage = desc.createImage();
            this.setTitleImage(this.oleTitleImage);
        }
        site.getPage().addPartListener(this.partListener);
    }

    private boolean validatePathEditorInput(IEditorInput input) throws PartInitException {
        IPathEditorInput pathEditorInput = (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (pathEditorInput == null) {
            throw new PartInitException(OleMessages.format((String)"OleEditor.invalidInput", (Object[])new Object[]{input}));
        }
        IPath path = pathEditorInput.getPath();
        if (!new File(path.toOSString()).exists()) {
            throw new PartInitException(OleMessages.format((String)"OleEditor.noFileInput", (Object[])new Object[]{path.toOSString()}));
        }
        return true;
    }

    protected void initializeWorkbenchMenus() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        Shell shell = this.clientFrame.getShell();
        Menu menuBar = shell.getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)shell, 2);
            shell.setMenuBar(menuBar);
        }
        MenuItem[] windowMenu = new MenuItem[1];
        MenuItem[] fileMenu = new MenuItem[1];
        ArrayList<MenuItem> containerItems = new ArrayList<MenuItem>();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        int i = 0;
        while (i < menuBar.getItemCount()) {
            MenuItem item = menuBar.getItem(i);
            String id = "";
            if (item.getData() instanceof IMenuManager) {
                id = ((IMenuManager)item.getData()).getId();
            }
            if (id.equals("file")) {
                fileMenu[0] = item;
            } else if (id.equals("window")) {
                windowMenu[0] = item;
            } else if (window.isApplicationMenu(id)) {
                containerItems.add(item);
            }
            ++i;
        }
        MenuItem[] containerMenu = containerItems.toArray(new MenuItem[containerItems.size()]);
        this.clientFrame.setFileMenus(fileMenu);
        this.clientFrame.setContainerMenus(containerMenu);
        this.clientFrame.setWindowMenus(windowMenu);
    }

    public boolean isDirty() {
        return this.clientSite != null && this.clientSite.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveNeeded() {
        return this.isDirty();
    }

    private boolean saveFile(File file) {
        File tempFile = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
        file.renameTo(tempFile);
        boolean saved = false;
        saved = OLE.isOleFile((File)file) || OleEditor.usesStorageFiles((String)this.clientSite.getProgramID()) ? this.clientSite.save(file, true) : this.clientSite.save(file, false);
        if (saved) {
            tempFile.delete();
            return true;
        }
        tempFile.renameTo(file);
        return false;
    }

    private WorkspaceModifyOperation saveNewFileOperation() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setFocus() {
    }

    private void oleActivate() {
        if (this.clientSite == null || this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        if (!this.oleActivated) {
            this.clientSite.doVerb(-1);
            this.oleActivated = true;
            String progId = this.clientSite.getProgramID();
            if (progId != null && progId.startsWith("Word.Document")) {
                this.handleWord();
            }
        }
    }

    protected void setInputWithNotify(IEditorInput input) {
        IPathEditorInput pathEditorInput = (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (pathEditorInput != null) {
            this.source = new File(pathEditorInput.getPath().toOSString());
        }
        if (input instanceof IFileEditorInput) {
            if (this.resource == null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
            this.resource = ((IFileEditorInput)input).getFile();
        } else if (this.resource != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resource = null;
        }
        super.setInputWithNotify(input);
    }

    private static boolean usesStorageFiles(String progID) {
        return progID != null && (progID.startsWith("Word.", 0) || progID.startsWith("MSGraph", 0) || progID.startsWith("PowerPoint", 0) || progID.startsWith("Excel", 0));
    }

    void sourceChanged(IFile newFile) {
        FileEditorInput newInput = new FileEditorInput(newFile);
        this.setInputWithNotify((IEditorInput)newInput);
        this.sourceChanged = true;
        this.setPartName(newInput.getName());
    }

    public boolean isSaveOnCloseNeeded() {
        return !this.sourceDeleted && super.isSaveOnCloseNeeded();
    }

    void update(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private void updateDirtyFlag() {
        6 dirtyFlagUpdater = new /* Unavailable Anonymous Inner Class!! */;
        dirtyFlagUpdater.run();
    }

    static /* synthetic */ IFile access$0(OleEditor oleEditor) {
        return oleEditor.resource;
    }

    static /* synthetic */ OleClientSite access$1(OleEditor oleEditor) {
        return oleEditor.clientSite;
    }

    static /* synthetic */ String access$2() {
        return OLE_EXCEPTION_TITLE;
    }

    static /* synthetic */ String access$3() {
        return OLE_EXCEPTION_MESSAGE;
    }

    static /* synthetic */ File access$4(OleEditor oleEditor) {
        return oleEditor.source;
    }

    static /* synthetic */ boolean access$5(OleEditor oleEditor, File file) {
        return oleEditor.saveFile(file);
    }

    static /* synthetic */ String access$6() {
        return SAVE_ERROR_TITLE;
    }

    static /* synthetic */ String access$7() {
        return SAVE_ERROR_MESSAGE;
    }

    static /* synthetic */ OleFrame access$8(OleEditor oleEditor) {
        return oleEditor.clientFrame;
    }

    static /* synthetic */ boolean access$9(OleEditor oleEditor) {
        return oleEditor.isDirty;
    }

    static /* synthetic */ void access$10(OleEditor oleEditor, boolean bl) {
        oleEditor.isDirty = bl;
    }

    static /* synthetic */ void access$11(OleEditor oleEditor, int n) {
        oleEditor.firePropertyChange(n);
    }
}

