<?xml version="1.0" encoding="iso-8859-1"?>
<!-- 6.1 - Hades migration -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:include href="metaproject.xslt"/>
	<xsl:output method="xml" version="1.0" encoding="utf-8" indent="yes"/>
	<xsl:strip-space elements="*"/>

	<xsl:key name = "ParallelRegion" match = "/model/State[@IsConcurrent='TRUE']/Sub/link" use = "@refid" />
	<xsl:key name = "TopRegion" match = "/model/StateMachine/Top/link" use = "@refid" />
	<xsl:key name = "BadSequenceDiagram" match = "/model/*[name() != 'Interaction']/product/link[@classof='SequenceDiagram']" use = "@refid" />

	<!--==============================================================
		Default rule : copy the node / attribute identically
		==============================================================-->
	<xsl:template match="@* | node()">
	   <!-- <xsl:message>Default rule...</xsl:message>-->
	   <xsl:copy>
	   <xsl:apply-templates select="@* | node()" />
	   </xsl:copy>
	</xsl:template>


	<!--==============================================================
		Analyst model migration
		==============================================================-->
	<xsl:template match="RequirementProject" >
	<AnalystProject>
	    <xsl:apply-templates select="@* | node()" />
	</AnalystProject>
	</xsl:template>

	<xsl:template match="RequirementProject/DefinedProperty" >
  </xsl:template>
	<xsl:template match="RequirementProject/DefinedType" >
  </xsl:template>

	<!--==============================================================
		Composite and concurrent states are handled "at hand"
		==============================================================-->
  <xsl:template match="State/Sub" >
  </xsl:template>
  <xsl:template match="State/Part" >
  </xsl:template>

	<!--==============================================================
		Delete SequenceDiagram that are not under Interaction
		==============================================================-->
  <xsl:template match="/model/*[name() != 'Interaction']/product/link[@classof='SequenceDiagram']" >
			<xsl:message>Deleting sequence diagram at the wrong place ...</xsl:message>
  </xsl:template>
	<xsl:template match="SequenceDiagram[ key('BadSequenceDiagram',@id)]" >
  </xsl:template>

	<!--==============================================================
		Top State of StateMachine -> Top Region
		==============================================================-->
	<xsl:template match="State[ key('TopRegion',@id)]" >
  	<Region>
  	   <xsl:apply-templates select="@* | node()" />
  	   <Sub>
  	     <xsl:apply-templates select="Sub/link" />
  	     <xsl:apply-templates select="Part/link" />
  	   </Sub>
  	</Region>
 	</xsl:template>

	<!--==============================================================
		Create Region between composite states and their sub states:
		==============================================================-->
	<xsl:template match="State[not (key('TopRegion',@id)) and not (key('ParallelRegion',@id)) and @IsConcurrent='FALSE' and (Sub|Part)]" mode="create">
	<xsl:comment>Inserting a new region for <xsl:value-of select="@Name" /> composite state.</xsl:comment>
  	<Region id="Region_of_{@id}" Name="{@Name}">
  	   <Sub>
  	     <xsl:apply-templates select="Sub/link" />
  	     <xsl:apply-templates select="Part/link" />
  	   </Sub>
  	</Region>
  <xsl:comment>End of new region for <xsl:value-of select="@Name" /> composite state.</xsl:comment>
 	</xsl:template>

	<xsl:template match="State[not (key('TopRegion',@id)) and not(key('ParallelRegion',@id)) and @IsConcurrent='FALSE' and (Sub|Part)]" >
	  <State>
	    <xsl:apply-templates select="@* | node() [name() != Sub and name() != Part]" />
  	  <OwnedRegion>
    	   <link classof='Region' refid="Region_of_{@id}"/>
    	</OwnedRegion>
    </State>
 	</xsl:template>

	<!--==============================================================
		Transmute states under concurrent States to Regions
		==============================================================-->
 	<xsl:template match="State[key('ParallelRegion',@id)]" >
  	<Region>
  	   <xsl:apply-templates select="@* | node() [name() != Sub and name() != Part]" />
  	   <Sub>
  	     <xsl:apply-templates select="Sub/link" />
  	     <xsl:apply-templates select="Part/link" />
  	   </Sub>
  	</Region>
 	</xsl:template>

	<xsl:template match="State[@IsConcurrent='TRUE']/Sub" >
  	<OwnedRegion>
  	   <xsl:apply-templates select="@* | node()" />
  	</OwnedRegion>
 	</xsl:template>

	<xsl:template match="State[@IsConcurrent='TRUE']/Part" >
	<!-- pseudo states directly under the concurrent state !! -->
	<xsl:comment>A '<xsl:value-of select="@Name" />' <xsl:value-of select="name()" /> was directly under the concurrent state. The element is lost.</xsl:comment>
 	</xsl:template>

	<!--==============================================================
		Convert old PseudoStates to new ones
		==============================================================-->
<xsl:template match="PseudoState[migration_property[@type='behavior' and @value='statemachine'] or not(migration_property)]" >
		<xsl:comment>A state machine PseudoState was here</xsl:comment>
		<xsl:choose>
			<xsl:when test = "@Kind='InitialState' ">
				<InitialPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</InitialPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='DeepHistoryState' ">
				<DeepHistoryPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</DeepHistoryPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='ShallowHistoryState' ">
				<ShallowHistoryPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</ShallowHistoryPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='JoinState' ">
				<JoinPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</JoinPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='ForkState' ">
				<ForkPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</ForkPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='BranchState' ">
				<ChoicePseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</ChoicePseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='OldFinalState' ">
				<FinalState>
				   <xsl:apply-templates select="@* | node()" />
				</FinalState>
			</xsl:when>
			<xsl:when test = "@Kind='SynchronizationState' ">
				<JunctionPseudoState>
				   <xsl:apply-templates select="@* | node()" />
				</JunctionPseudoState>
			</xsl:when>
			<xsl:when test = "@Kind='SignalReceiptState' ">
				<State>
				   <xsl:apply-templates select="@* | node()" />
				</State>
			</xsl:when>
			<xsl:when test = "@Kind='SignalSendingState' ">
				<State>
				   <xsl:apply-templates select="@* | node()" />
				</State>
			</xsl:when>
			<xsl:when test = "@Kind='FinalState' ">
				<FinalState>
				   <xsl:apply-templates select="@* | node()" />
				</FinalState>
			</xsl:when>

			<xsl:otherwise>
  			<xsl:comment>The '<xsl:value-of select="@Name" />' <xsl:value-of select="@Kind" /> is an unknown <xsl:value-of select="name()" />.</xsl:comment>
  			<xsl:message>The '<xsl:value-of select="@Name" />' <xsl:value-of select="@Kind" /> is an unknown <xsl:value-of select="name()" />.</xsl:message>
				<State>
				   <xsl:apply-templates select="@* | node()" />
				</State>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>


	<!--==============================================================
		migration_property : Remove migration hints
		==============================================================-->
	<xsl:template match="migration_property" >
 	</xsl:template>

	<!--==============================================================
		Deleted metaclasses:

   Cannot find 'SiteIdent' dependency on '_predefinedTypes'(9604f1f4-b172-11dd-acca-001ec947ccaf) SoProject.
   Cannot find 'controlManage' dependency on '_predefinedTypes'(9604f1f4-b172-11dd-acca-001ec947ccaf) SoProject.
   12:02:46 WARN Unknown XML tag found "SeObjectNum". The metaclass may not exist anymore.
   12:02:46 WARN Unknown XML tag found "ScManager". The metaclass may not exist anymore.
   12:02:46 WARN Unknown XML tag found "DocumentType". The metaclass may not exist anymore.
   12:02:47 WARN Unknown XML tag found "StateDiagram". The metaclass may not exist anymore.
		==============================================================-->

	<xsl:template match="SoProject/SiteIdent" >
   	</xsl:template>
	<xsl:template match="SoSite/SiteIdent" >
   	</xsl:template>
	<xsl:template match="SoProject/controlManage" >
   	</xsl:template>
	<xsl:template match="SeObjectNum" >
   	</xsl:template>
	<xsl:template match="DocumentType" >
   	</xsl:template>
	<xsl:template match="ScManager" >
   	</xsl:template>

	<xsl:template match="StateDiagram" >
  	<StaticDiagram>
  	  <xsl:apply-templates select="@* | node()" />
    	<Extension>
    	 <link classof="Stereotype" name ="state" refid="StereotypeState"/>
    	</Extension>
  	</StaticDiagram>
  </xsl:template>

  <xsl:template match="StateDiagram/@saveGrapher" >
  </xsl:template>


	<!--==============================================================
		GrBaElement ==> ''
		==============================================================-->
	<xsl:template match="GrBaElement" >
   	</xsl:template>

	<xsl:template match="/model/*/Elements[link/@classof='GrBaElement']" >
   	</xsl:template>


	<!--=========================================================================
		PseudoState (activity) ==> InitialNode/ForkJoinNode/DecisionMergeNode/...
		=========================================================================-->
	<xsl:template match="PseudoState[migration_property[@type='behavior' and @value='activity'] ]" >
		<xsl:comment>An activity PseudoState was here</xsl:comment>
		<xsl:choose>
			<xsl:when test = "@Kind='InitialState' ">
				<InitialNode>
				   <xsl:apply-templates select="@* | node()" />
				</InitialNode>
			</xsl:when>
			<xsl:when test = "@Kind='JoinState' ">
				<ForkJoinNode>
				   <xsl:apply-templates select="@* | node()" />
				</ForkJoinNode>
			</xsl:when>
			<xsl:when test = "@Kind='ForkState' ">
				<ForkJoinNode>
				   <xsl:apply-templates select="@* | node()" />
				</ForkJoinNode>
			</xsl:when>
			<xsl:when test = "@Kind='BranchState' ">
				<DecisionMergeNode>
				   <xsl:apply-templates select="@* | node()" />
				</DecisionMergeNode>
			</xsl:when>
			<xsl:when test = "@Kind='FinalState' ">
				<ActivityFinalNode>
				   <xsl:apply-templates select="@* | node()" />
				</ActivityFinalNode>
			</xsl:when>
			<xsl:when test = "@Kind='SignalReceiptState' ">
				<AcceptSignalAction>
				   <xsl:apply-templates select="@* | node()" />
				   <Accepted>
				   <!--xsl:copy-of select = "key('TransitionGoingTo',@id)/Effects/link"/-->
				   <xsl:copy-of select = "key('Transition',OutGoing/link/@refid)/Effects/link"/>
				   </Accepted>
				</AcceptSignalAction>
			</xsl:when>
			<xsl:when test = "@Kind='SignalSendingState' ">
				<SendSignalAction>
				   <xsl:apply-templates select="@* | node()" />
				   <Sent>
				   <xsl:copy-of select = "key('TransitionGoingTo',@id)/Effects/link"/>
				   <!--xsl:copy-of select = "key('Transition',OutGoing/link/@refid)/Effects/link"/-->
				   </Sent>
				</SendSignalAction>
			</xsl:when>
		</xsl:choose>
   	</xsl:template>

	<!-- ===================================================================-->
    <!-- ===                    racine                                   ===-->
	<!-- ===================================================================-->
	<xsl:template match="/" >
    	<xsl:apply-templates select = "/model" />
	</xsl:template>

	<xsl:template match="/model" >
		<xsl:message>Processing XML file ...</xsl:message>
		<xsl:comment>Processing XML file ...</xsl:comment>
		<model>
			<!--==============================================================
			    manually add 'communication' stereotype
				==============================================================-->
			<Stereotype Name="communication" id="StereotypeCommunication" MSiteIdent="12338304:1704" BaseClass="StaticDiagram">
			</Stereotype>

			<Stereotype Name="state" id="StereotypeState" MSiteIdent="002005c0-0001-0011-0000-000000000000" BaseClass="StaticDiagram">
			</Stereotype>


			<!-- Racine du fichier XML -->
			<xsl:apply-templates select="@* | node()" />

			<!--============ nouveaux =====================-->
			<xsl:message>Processing UML elements creations ...</xsl:message>
			<xsl:comment>Processing UML elements creations ...</xsl:comment>

			<xsl:apply-templates mode="create" select="*"/>
		</model>

		<xsl:message>Transformation finished.</xsl:message>
	</xsl:template>

</xsl:stylesheet>
