<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="utf-8" indent="yes"/>
	<xsl:strip-space elements="*"/>

    <xsl:template match="SoBase/@strVersion_p[.!='1.1']">
    	<xsl:message> Converting project from <xsl:value-of select="."/> to "Modelio 1.1" </xsl:message>
    	<xsl:attribute name="strVersion_p">1.1</xsl:attribute>
    </xsl:template>



	<!-- ==== Delete obsolete Modelio 1.0 metaclasses ==== -->
	<xsl:template match="SoPointOfView">
	</xsl:template>
	<xsl:template match="SoSite">
	</xsl:template>
	<xsl:template match="MptItemGeneration" >
	</xsl:template>
	<xsl:template match="SoTaggedValue" >
	</xsl:template>
	<xsl:template match="SoParameter" >
	</xsl:template>
	<xsl:template match="SoTagParameter" >
	</xsl:template>
	<xsl:template match="SoSpecDirective" >
	</xsl:template>
	<xsl:template match="SoStereotype" >
	</xsl:template>
	<xsl:template match="SoTextType" >
	</xsl:template>
	<xsl:template match="SoMethod" >
	</xsl:template>
	<xsl:template match="SoConfigValue" >
	</xsl:template>
	<xsl:template match="MptProductType" >
	</xsl:template>
	<xsl:template match="SoAttributeDescriptor">
	</xsl:template>
	<xsl:template match="SoClassDescriptor">
	</xsl:template>
	<xsl:template match="SoCommand">
	</xsl:template>
	<xsl:template match="SoNote" >
	</xsl:template>
	<xsl:template match="SoParamEnumeration" >
	</xsl:template>

	<xsl:template match="Project/Selected" >
	</xsl:template>
	<xsl:template match="SoSite/pointOfView" >
	</xsl:template>

	<!--  SoClass ==> MetaclassReference   -->
	<xsl:template match="SoClass" >
  	<MetaclassReference>
  	  <xsl:apply-templates select="@* | node()" />
  	</MetaclassReference>
	</xsl:template>

	<xsl:template match="SoClass/@Name" >
		<xsl:attribute name="ReferencedClassName">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>
	<xsl:template match="SoClass/hAttribute" >
	</xsl:template>
	<xsl:template match="SoClass/hMethod" >
	</xsl:template>
	<xsl:template match="SoClass/redefHMethod" >
	</xsl:template>
	<xsl:template match="SoClass/dirType" >
	</xsl:template>
	<xsl:template match="SoClass/txtType" >
	</xsl:template>
	<xsl:template match="SoClass/steType" >
	</xsl:template>
	<xsl:template match="SoClass/MetaProduct" >
	</xsl:template>

	<!--  SoModule ==> Module   -->
	<xsl:template match="SoModule" >
  	<Module>
  	  <xsl:apply-templates select="@* | node()" />
  	</Module>
	</xsl:template>
	
	<xsl:template match="SoModule/Parent" >
   	</xsl:template>

	<xsl:template match="SoModule/commands" >
	</xsl:template>

	<xsl:key name = "ConfigParam.Value" match = "/model/migration_property[@key='ConfigParam.Value']" use = "@id" />
	<xsl:key name = "Profile.MetaclassReference" match = "/model/migration_property[@key='Profile.MetaclassReference']" use = "@id" />

	<!--  SoConfigParam ==> ConfigParam   -->
	<xsl:template match="SoConfigParam" >
  	<ConfigParam>
    	<xsl:for-each select="key('ConfigParam.Value', @id)" >
        <xsl:attribute name="Value">
          <xsl:value-of select="@value"/>
        </xsl:attribute >
     	</xsl:for-each>
  	  <xsl:apply-templates select="@* | node()" />
  	</ConfigParam>
	</xsl:template>

	<xsl:template match="SoConfigParam/paramEnumDef" >
	</xsl:template>

	<!--  PointOfView ==> Profile   -->
	<xsl:template match="PointOfView" >
  	<Profile>
  	  <xsl:apply-templates select="@* | node()" />
      <OwnedReference>
      	<xsl:for-each select="key('Profile.MetaclassReference', @id)/link" >
          <xsl:copy>
            <xsl:apply-templates select="@* | node()" />
          </xsl:copy>
       	</xsl:for-each>
      </OwnedReference>
  	</Profile>
	</xsl:template>

	<!--  PointOfView.STDefined ==> Profile.DefinedStereotype   -->
	<xsl:template match="PointOfView/STDefined" >
	   <DefinedStereotype>
         <xsl:apply-templates select="@* | node()" />
	   </DefinedStereotype>
	</xsl:template>

	<xsl:template match="Stereotype/RequiredTag" >
	   <DefinedTagType>
         <xsl:apply-templates select="@* | node()" />
	   </DefinedTagType>
	</xsl:template>

	<xsl:template match="Stereotype/RequiredNote" >
	   <DefinedNoteType>
         <xsl:apply-templates select="@* | node()" />
	   </DefinedNoteType>
	</xsl:template>

	<xsl:template match="Stereotype/@BaseClass" >
		<xsl:attribute name="BaseClassName">
			<xsl:value-of select="."/>
		</xsl:attribute>
	</xsl:template>

	<!-- Remove these links, they are already exported in the opposite direction -->
	<xsl:template match="LocalNote/LocalSubject" >
	</xsl:template>
	<xsl:template match="LocalTaggedValue/LocalAnnoted" >
	</xsl:template>

</xsl:stylesheet>
