#
# Sort  2.1
#  This macro sorts the model elements under a Classifier or a Package.
#  Classes, interfaces, component, use cases are all classifiers.
#
# Author:  Modeliosoft
#
# Applicable on: Classifier, Package
#
# Version history:
# 1.0   3rd Sept 2009   - creation
# 1.01  7th Sept 2009   - enable the macro on Classifiers
# 1.02  4th March 2011  - fix associations sort to sort only modifiable ones.
# 1.03  1st April 2011  - forces refresh in the explorer
# 1.04  20th May 2011   - enable the macro on Dictionary and RequirementContainers.
# 1.04  20th May 2011   - enable the macro on multi selection.
# 2.0   09th September 2011 - update for Modelio 2.0  
# 2.01  27th Avril 2012 - added sort of diagrams  

visibilityOrderingTable = [ObVisibilityModeEnum.PUBLIC, ObVisibilityModeEnum.PACKAGE_VISIBILITY, ObVisibilityModeEnum.PROTECTED, ObVisibilityModeEnum.PRIVATE, ObVisibilityModeEnum.VISIBILITY_UNDEFINED]

def isModifiable(o):
    return modelingSession.getElementStatus(o).isModifiable()

def attributeCompare(a, b):
    return cmp(a.getName(), b.getName())

def operationCompare(a, b):
    nameA = a.getName()
    nameB = b.getName()
    visA = a.getVisibility()
    visB = b.getVisibility()
    if ( visibilityCompare(visA, visB) == 0 ):
        return  cmp(nameA, nameB)
    else:
        return visibilityCompare(visA, visB)

def visibilityCompare(x, y):
    return cmp(visibilityOrderingTable.index(x), visibilityOrderingTable.index(y))


def sortAttributes(clazz):
    attributes = []
    for att in clazz.getPart(IAttribute):
        attributes.append(att)
        clazz.removePart(att)
    attributes.sort(attributeCompare)
    for att in attributes:
        clazz.addPart(att)

def sortOperations(clazz):
    operations = []
    for op in clazz.getPart(IOperation):
        operations.append(op)
        clazz.removePart(op)

    operations.sort(operationCompare)

    for op in operations:
        clazz.addPart(op)

def sortAssociationEnds(clazz):
    oldRoles = []
    newRoles = []
    for role in clazz.getPart(IAssociationEnd):
        if isModifiable(role):
            oldRoles.append(role)
            newRoles.append(role)
            
    newRoles.sort(attributeCompare)
    
    if oldRoles != newRoles:
        for role in oldRoles:
            clazz.removePart(role)

        for role in newRoles:
            clazz.addPart(role)
    return

def getSortKey(el):
    if (el.getElementStatus().isRamcObject()):
        return '1'+el.getName()
    else:
        return '0'+el.getName()
    
    
def sortModelTree(modeltree):
    ownedElements = []
    for e in modeltree.getOwnedElement():
        ownedElements.append(e)
        modeltree.removeOwnedElement(e)
    ownedElements.sort(lambda x, y: cmp(getSortKey(x), getSortKey(y)))
    for e in ownedElements:
        modeltree.addOwnedElement(e)

def sortRequirementContainer(package):
    ownedElements = []
    for e in package.getOwned():
        ownedElements.append(e)
        package.removeOwned(e)
    ownedElements.sort(lambda x, y: cmp(x.getName(), y.getName()))
    for e in ownedElements:
        package.addOwned(e)

def sortDictionary(package):
    ownedElements = []
    for e in package.getOwned():
        ownedElements.append(e)
        package.removeOwned(e)
    ownedElements.sort(lambda x, y: cmp(x.getName(), y.getName()))
    for e in ownedElements:
        package.addOwned(e)
		
def sortDiagrams(modelelement):
	ownedDiagrams = []
	for d in modelelement.getproduct():
		ownedDiagrams.append(d)
		modelelement.removeproduct(d)
	ownedDiagrams.sort(lambda x, y: cmp(x.getName(), y.getName()))
	for d in ownedDiagrams:
		modelelement.addproduct(d)
        
#
# The macro execution starts here
#
if (selectedElements.size > 0):
    for element in selectedElements:
		status = modelingSession.getElementStatus(element)
		if (status.isModifiable()):
			if (isinstance(element, IModelElement)):
				sortDiagrams(element)
				element.setmodifDate(element.getmodifDate() + 1)
			
			if (isinstance(element, IModelTree)):				
				sortModelTree(element)
				element.setmodifDate(element.getmodifDate() + 1)
				
			if (isinstance(element, IClassifier)):				
				sortAttributes(element)
				sortOperations(element)
				sortAssociationEnds(element)				
				element.setmodifDate(element.getmodifDate() + 1)			
				
			if (isinstance(element, IRequirementContainer)):
				sortRequirementContainer(element)
				element.setmodifDate(element.getmodifDate() + 1)
				
			if (isinstance(element, IDictionary)):
				sortDictionary(element)
				element.setmodifDate(element.getmodifDate() + 1)			
				
			if (not(isinstance(element, IClassifier) or isinstance(element, IModelTree) or isinstance(element, IRequirementContainer) or isinstance(element, IDictionary) or isinstance(element, IModelElement))):			
				print "ERROR: The selected element must be a Classifier (Class, Interface, Component, ...) or a Package."
		else:
			print "ERROR: The selected element is not modifiable!"
