/*
 * Decompiled with CFR 0.152.
 */
package commands;

import commands.AdvancedEditingCommandGateway;
import commands.CommandType;
import commands.EditingCommandGateway;
import commands.FileCommandGateway;
import commands.FormatCommandGateway;
import commands.SettingsCommandGateway;
import commands.StyledToolBarCommandGateway;
import commands.WindowCommandGateway;
import gui.Application;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.DocumentRestorer;
import neutrino.text.PlainTextArea;
import neutrino.text.StyledTextComponent;
import neutrino.text.TextComponent;

public class CommandGateway {
    private Application application = null;
    private FileCommandGateway fileCommandGateway = null;
    private SettingsCommandGateway settingsCommandGateway = null;
    private EditingCommandGateway editingCommandGateway = null;
    private AdvancedEditingCommandGateway advancedEditingCommandGateway = null;
    private FormatCommandGateway formatCommandGateway = null;
    private WindowCommandGateway windowCommandGateway = null;
    private StyledToolBarCommandGateway styledToolBarCommandGateway = null;

    public CommandGateway(Application application) {
        this.application = application;
        this.fileCommandGateway = new FileCommandGateway(application);
        this.settingsCommandGateway = new SettingsCommandGateway(application);
        this.editingCommandGateway = new EditingCommandGateway(application);
        this.advancedEditingCommandGateway = new AdvancedEditingCommandGateway(application);
        this.formatCommandGateway = new FormatCommandGateway(application);
        this.windowCommandGateway = new WindowCommandGateway(application);
        this.styledToolBarCommandGateway = new StyledToolBarCommandGateway(application);
    }

    public void performCommand(CommandType commandType) {
        switch (commandType) {
            case NEW: {
                this.fileCommandGateway.newText();
                break;
            }
            case OPEN: {
                this.fileCommandGateway.open();
                break;
            }
            case RESTORE: {
                this.fileCommandGateway.restore();
                break;
            }
            case SAVE: {
                this.fileCommandGateway.save();
                break;
            }
            case SAVE_AS: {
                this.fileCommandGateway.saveAs();
                break;
            }
            case SAVE_ALL: {
                this.fileCommandGateway.saveAll();
                break;
            }
            case REVERT: {
                this.fileCommandGateway.revert();
                break;
            }
            case RELOAD: {
                this.fileCommandGateway.reload();
                break;
            }
            case CHANGE_DIR: {
                this.fileCommandGateway.changeDir();
                break;
            }
            case PRINT: {
                this.fileCommandGateway.print();
                break;
            }
            case EXIT: {
                this.fileCommandGateway.exit();
                break;
            }
            case UNDO: {
                this.editingCommandGateway.undo();
                break;
            }
            case REDO: {
                this.editingCommandGateway.redo();
                break;
            }
            case CUT: {
                this.editingCommandGateway.cut();
                break;
            }
            case COPY: {
                this.editingCommandGateway.copy();
                break;
            }
            case PASTE: {
                this.editingCommandGateway.paste();
                break;
            }
            case GO_TO: {
                this.editingCommandGateway.goTo();
                break;
            }
            case FIND: {
                this.editingCommandGateway.find();
                break;
            }
            case REPLACE: {
                this.editingCommandGateway.replace();
                break;
            }
            case SELECT_ALL: {
                this.editingCommandGateway.selectAll();
                break;
            }
            case MAKE_UPPERCASE: {
                this.advancedEditingCommandGateway.makeUppercase();
                break;
            }
            case MAKE_LOWERCASE: {
                this.advancedEditingCommandGateway.makeLowercase();
                break;
            }
            case TABIFY_SELECTED_LINES: {
                this.advancedEditingCommandGateway.tabifySelectedLines();
                break;
            }
            case UNTABIFY_SELECTED_LINES: {
                this.advancedEditingCommandGateway.untabifySelectedLines();
                break;
            }
            case DELETE_HORIZONTAL_WHITE_SPACE: {
                this.advancedEditingCommandGateway.deleteHorizontalWhiteSpace();
                break;
            }
            case REMOVE_TRAILING_WHITESPACES: {
                this.advancedEditingCommandGateway.removeTrailingWhitespaces();
                break;
            }
            case INCREASE_LINE_INDENT: {
                this.advancedEditingCommandGateway.shiftInRight();
                break;
            }
            case DECREASE_LINE_INDENT: {
                this.advancedEditingCommandGateway.shiftInLeft();
                break;
            }
            case PERFORM_COMPLEX_OPERATION: {
                this.advancedEditingCommandGateway.performComplexOperation();
                break;
            }
            case PARAGRAPH: {
                this.formatCommandGateway.paragraph();
                break;
            }
            case STYLE: {
                this.formatCommandGateway.style();
                break;
            }
            case STYLED_BACKGROUND: {
                this.formatCommandGateway.background();
                break;
            }
            case INSERT_IMAGE: {
                this.formatCommandGateway.insertImage();
                break;
            }
            case FOREGROUND: {
                this.settingsCommandGateway.foreground();
                break;
            }
            case BACKGROUND: {
                this.settingsCommandGateway.background();
                break;
            }
            case FONT: {
                this.settingsCommandGateway.font();
                break;
            }
            case ENCODING: {
                this.settingsCommandGateway.encoding();
                break;
            }
            case ADVANCED: {
                this.settingsCommandGateway.advanced();
                break;
            }
            case NEW_PLAIN_TEXT_EDITOR: {
                this.windowCommandGateway.newPlainTextEditor();
                break;
            }
            case NEW_XML_EDITOR: {
                this.windowCommandGateway.newXMLEditor();
                break;
            }
            case NEW_RTF_EDITOR: {
                this.windowCommandGateway.newRTFEditor();
                break;
            }
            case NEW_HTML_EDITOR: {
                this.windowCommandGateway.newHTMLEditor();
                break;
            }
            case CLOSE: {
                this.windowCommandGateway.close();
                break;
            }
            case CLOSE_OTHERS: {
                this.windowCommandGateway.closeOthers();
                break;
            }
            case CLOSE_ALL: {
                this.windowCommandGateway.closeAll();
                break;
            }
            case ABOUT: {
                this.fileCommandGateway.about();
                break;
            }
            case TOGGLE_BOLD: {
                this.styledToolBarCommandGateway.toggleBold();
                break;
            }
            case TOGGLE_ITALIC: {
                this.styledToolBarCommandGateway.toggleItalic();
                break;
            }
            case TOGGLE_UNDERLINE: {
                this.styledToolBarCommandGateway.toggleUnderline();
                break;
            }
            case ALIGN_LEFT: {
                this.styledToolBarCommandGateway.alignLeft();
                break;
            }
            case ALIGN_CENTER: {
                this.styledToolBarCommandGateway.alignCenter();
                break;
            }
            case ALIGN_RIGHT: {
                this.styledToolBarCommandGateway.alignRight();
                break;
            }
            case SET_STYLE_FOREGROUND: {
                this.styledToolBarCommandGateway.setStyleForeground();
                break;
            }
            case SET_STYLE_BACKGROUND: {
                this.styledToolBarCommandGateway.setStyleBackground();
            }
        }
    }

    public boolean canPeformCommand(CommandType commandType) {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        switch (commandType) {
            case NEW: {
                return this.application.getTextEditor().canClear();
            }
            case RESTORE: {
                return DocumentRestorer.hasBackup();
            }
            case SAVE: {
                return this.application.getTextEditor().canSave();
            }
            case SAVE_ALL: {
                return this.application.getMultiTextComponent().canSaveAll();
            }
            case SAVE_AS: {
                return this.application.getTextEditor().canSaveAs();
            }
            case REVERT: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canRevert();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canRevert();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canRevert();
                }
                return false;
            }
            case RELOAD: {
                return this.application.getTextEditor().canReload();
            }
            case PRINT: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canPrint();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canPrint();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canPrint();
                }
                return true;
            }
            case UNDO: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canUndo();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canUndo();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canUndo();
                }
                return false;
            }
            case REDO: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canRedo();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canRedo();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canRedo();
                }
                return false;
            }
            case CUT: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canCut();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canCut();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canCut();
                }
                return true;
            }
            case COPY: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canCopy();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canCopy();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canCopy();
                }
                return true;
            }
            case PASTE: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canPaste();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canPaste();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canPaste();
                }
                return true;
            }
            case GO_TO: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return true;
            }
            case FIND: {
                return !this.application.getMultiTextComponent().isTextsEmpty();
            }
            case REPLACE: {
                return !this.application.getMultiTextComponent().isTextsEmpty();
            }
            case SELECT_ALL: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).canSelectAll();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).canSelectAll();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).canSelectAll();
                }
                return true;
            }
            case MAKE_UPPERCASE: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).isTextSelected();
                }
                return false;
            }
            case MAKE_LOWERCASE: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).isTextSelected();
                }
                return false;
            }
            case TABIFY_SELECTED_LINES: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).isTextSelected();
                }
                return false;
            }
            case UNTABIFY_SELECTED_LINES: {
                if (jTextComponent instanceof PlainTextArea) {
                    return ((PlainTextArea)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof TextComponent) {
                    return ((TextComponent)jTextComponent).isTextSelected();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return ((StyledTextComponent)jTextComponent).isTextSelected();
                }
                return false;
            }
            case DELETE_HORIZONTAL_WHITE_SPACE: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case REMOVE_TRAILING_WHITESPACES: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case INCREASE_LINE_INDENT: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case DECREASE_LINE_INDENT: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case PERFORM_COMPLEX_OPERATION: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case ADVANCED_EDITING_COMMAND: {
                if (jTextComponent instanceof PlainTextArea) {
                    return !((PlainTextArea)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof TextComponent) {
                    return !((TextComponent)jTextComponent).isTextEmpty();
                }
                if (jTextComponent instanceof StyledTextComponent) {
                    return !((StyledTextComponent)jTextComponent).isTextEmpty();
                }
                return false;
            }
            case CLOSE: {
                return this.application.getMultiTextComponent().canClose();
            }
            case CLOSE_OTHERS: {
                return this.application.getMultiTextComponent().canCloseOthers();
            }
            case CLOSE_ALL: {
                return this.application.getMultiTextComponent().canCloseAll();
            }
        }
        return true;
    }
}

