/*
 * Decompiled with CFR 0.152.
 */
package commands;

import gui.Application;
import java.awt.Window;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.LineChooser;
import neutrino.dialogs.TextFinder;
import neutrino.text.PlainTextArea;
import neutrino.text.StyledTextComponent;
import neutrino.text.TextComponent;

class EditingCommandGateway {
    private Application application = null;

    public EditingCommandGateway(Application application) {
        this.application = application;
    }

    public void undo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).undo();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).undo();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).undo();
        }
    }

    public void redo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).redo();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).redo();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).redo();
        }
    }

    public void cut() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).cut();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).cut();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).cut();
        }
    }

    public void copy() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).copy();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).copy();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).copy();
        }
    }

    public void paste() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).paste();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).paste();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).paste();
        }
    }

    public void goTo() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        boolean bl = jTextComponent instanceof PlainTextArea ? !((PlainTextArea)jTextComponent).isTextEmpty() : (jTextComponent instanceof TextComponent ? !((TextComponent)jTextComponent).isTextEmpty() : (jTextComponent instanceof StyledTextComponent ? !((StyledTextComponent)jTextComponent).isTextEmpty() : true));
        if (bl) {
            LineChooser.showGoToLineDialog(this.application, jTextComponent);
        }
    }

    public void find() {
        if (!this.application.getMultiTextComponent().isTextsEmpty()) {
            TextFinder.showFindDialog((Window)this.application, this.application.getMultiTextComponent());
        }
    }

    public void replace() {
        if (!this.application.getMultiTextComponent().isTextsEmpty()) {
            TextFinder.showReplaceDialog((Window)this.application, this.application.getMultiTextComponent());
        }
    }

    public void selectAll() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        boolean bl = jTextComponent instanceof PlainTextArea ? ((PlainTextArea)jTextComponent).canSelectAll() : (jTextComponent instanceof TextComponent ? ((TextComponent)jTextComponent).canSelectAll() : (jTextComponent instanceof StyledTextComponent ? ((StyledTextComponent)jTextComponent).canSelectAll() : true));
        if (bl) {
            jTextComponent.selectAll();
        }
    }
}

