/*
 * Decompiled with CFR 0.152.
 */
package commands;

import gui.Application;
import gui.dialog.AboutDialog;
import java.awt.print.PrinterException;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import neutrino.dialogs.DirectoryChooser;
import neutrino.dialogs.DocumentRestorer;
import neutrino.text.PlainTextArea;
import neutrino.text.StyledTextComponent;
import neutrino.text.TextComponent;
import neutrino.text.TextEditor;

class FileCommandGateway {
    private Application application = null;

    public FileCommandGateway(Application application) {
        this.application = application;
    }

    public void newText() {
        if (!this.application.getTextEditor().isTextSaved()) {
            return;
        }
        this.application.getTextEditor().clear();
    }

    public void open() {
        if (!this.application.getTextEditor().isTextSaved()) {
            return;
        }
        this.application.getTextEditor().open();
    }

    public void restore() {
        File[] fileArray = DocumentRestorer.showMultiRestoreDialog(this.application);
        this.application.getMultiTextComponent().restoreBackups(fileArray);
    }

    public void save() {
        this.application.getTextEditor().save();
    }

    public void saveAs() {
        this.application.getTextEditor().saveAs();
    }

    public void saveAll() {
        if (this.application.getMultiTextComponent().canSaveAll()) {
            this.application.getMultiTextComponent().saveAll();
        }
    }

    public void revert() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        if (jTextComponent instanceof PlainTextArea) {
            ((PlainTextArea)jTextComponent).revert();
        } else if (jTextComponent instanceof TextComponent) {
            ((TextComponent)jTextComponent).revert();
        } else if (jTextComponent instanceof StyledTextComponent) {
            ((StyledTextComponent)jTextComponent).revert();
        } else {
            return;
        }
    }

    public void reload() {
        TextEditor textEditor = this.application.getTextEditor();
        if (textEditor.isFileLoaded()) {
            if (this.application.getSettings().isConfirmReloading()) {
                JPanel jPanel = new JPanel();
                BoxLayout boxLayout = new BoxLayout(jPanel, 1);
                jPanel.setLayout(boxLayout);
                jPanel.add(new JLabel("Do you want to reload current file?"));
                jPanel.add(Box.createVerticalStrut(5));
                JCheckBox jCheckBox = new JCheckBox("Always reload without prompt");
                jPanel.add(jCheckBox);
                int n = JOptionPane.showConfirmDialog(this.application, jPanel, "Confirm reloading", 0, 3);
                this.application.getSettings().setConfirmingReloading(!jCheckBox.isSelected());
                if (n == 1) {
                    return;
                }
            }
            textEditor.reload();
        }
    }

    public void print() {
        JTextComponent jTextComponent = this.application.getTextEditor().getTextComponent();
        boolean bl = jTextComponent instanceof PlainTextArea ? ((PlainTextArea)jTextComponent).canPrint() : (jTextComponent instanceof TextComponent ? ((TextComponent)jTextComponent).canPrint() : (jTextComponent instanceof StyledTextComponent ? ((StyledTextComponent)jTextComponent).canPrint() : true));
        try {
            if (!bl) {
                JOptionPane.showMessageDialog(this.application, "Nothing to print.", "Information", 1);
            } else if (jTextComponent instanceof PlainTextArea) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setTabSize(((PlainTextArea)jTextComponent).getTabSize());
                jTextArea.setText(this.application.getTextEditor().getTextComponent().getText());
                jTextArea.setFont(this.application.getTextEditor().getTextComponent().getFont());
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(false);
                jTextArea.print();
                jTextArea = null;
                System.gc();
            } else {
                jTextComponent.print();
            }
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
        }
    }

    public void changeDir() {
        File file = DirectoryChooser.showDirectoryDialog(this.application, this.application.getTextEditor().getCurrentDirectory());
        if (file != null) {
            this.application.getMultiTextComponent().setCurrentDirectory(file);
        }
    }

    public void exit() {
        if (this.application.getSettings().isConfirmExit()) {
            JPanel jPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(new JLabel("Do you want to exit?"));
            jPanel.add(Box.createVerticalStrut(5));
            JCheckBox jCheckBox = new JCheckBox("Always exit without prompt");
            jCheckBox.setSelected(false);
            jPanel.add(jCheckBox);
            int n = JOptionPane.showConfirmDialog(this.application, jPanel, "Confirm exit", 0);
            this.application.getSettings().setConfirmingExit(!jCheckBox.isSelected());
            if (n == 1) {
                return;
            }
        }
        if (!this.application.getMultiTextComponent().isTextsSaved()) {
            return;
        }
        this.application.getPropertiesManager().saveProperties();
        this.application.getMultiTextComponent().shutdown();
        this.application.setVisible(false);
        this.application.dispose();
        System.exit(0);
    }

    public void about() {
        AboutDialog.showAboutDialog(this.application);
    }
}

