/*
 * Decompiled with CFR 0.152.
 */
package gui;

import commands.CommandGateway;
import commands.CommandType;
import gui.ToolBarBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ActionBuilder
extends ToolBarBuilder
implements ActionListener {
    private CommandGateway commandGateway = null;
    private WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ActionBuilder.this.getCommandGateway().performCommand(CommandType.EXIT);
        }
    };

    public ActionBuilder() {
        this.commandGateway = new CommandGateway(this);
        this.addWindowListener(this.windowListener);
        this.setDefaultCloseOperation(0);
    }

    public void bindHelpset() {
        Object object;
        String string = this.getSettings().getHelpsetFileName();
        ClassLoader classLoader = ActionBuilder.class.getClassLoader();
        HelpSet helpSet = null;
        try {
            object = HelpSet.findHelpSet(classLoader, string);
            helpSet = new HelpSet(null, (URL)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Helpset not exists", "Error", 0);
            return;
        }
        object = helpSet.createHelpBroker();
        CSH.DisplayHelpFromSource displayHelpFromSource = new CSH.DisplayHelpFromSource((HelpBroker)object);
        this.miHelp.addActionListener(displayHelpFromSource);
        this.bHelp.addActionListener(displayHelpFromSource);
    }

    @Override
    protected void buildActions() {
        super.buildActions();
        this.miNew.addActionListener(this);
        this.miOpen.addActionListener(this);
        this.miRestore.addActionListener(this);
        this.miSave.addActionListener(this);
        this.miSaveAs.addActionListener(this);
        this.miSaveAll.addActionListener(this);
        this.miReload.addActionListener(this);
        this.miRevert.addActionListener(this);
        this.miChangeDir.addActionListener(this);
        this.miPrint.addActionListener(this);
        this.miExit.addActionListener(this);
        this.miUndo.addActionListener(this);
        this.miRedo.addActionListener(this);
        this.miCut.addActionListener(this);
        this.miCopy.addActionListener(this);
        this.miPaste.addActionListener(this);
        this.miGoTo.addActionListener(this);
        this.miFind.addActionListener(this);
        this.miReplace.addActionListener(this);
        this.miSelectAll.addActionListener(this);
        this.miOptions.addActionListener(this);
        this.miMakeUppercase.addActionListener(this);
        this.miMakeLowercase.addActionListener(this);
        this.miTabifySelectedLines.addActionListener(this);
        this.miUntabifySelectedLines.addActionListener(this);
        this.miDeleteHorizontalWhiteSpace.addActionListener(this);
        this.miRemoveTrailingWhitespaces.addActionListener(this);
        this.miShiftInLeft.addActionListener(this);
        this.miShiftInRight.addActionListener(this);
        this.miPerformComplexOperation.addActionListener(this);
        this.miParagraph.addActionListener(this);
        this.miStyle.addActionListener(this);
        this.miStyledBackground.addActionListener(this);
        this.miInsertImage.addActionListener(this);
        this.miForeground.addActionListener(this);
        this.miBackgound.addActionListener(this);
        this.miFont.addActionListener(this);
        this.miEncoding.addActionListener(this);
        this.miAdvanced.addActionListener(this);
        this.miPlainText.addActionListener(this);
        this.miXML.addActionListener(this);
        this.miRTF.addActionListener(this);
        this.miHTML.addActionListener(this);
        this.miClose.addActionListener(this);
        this.miCloseOthers.addActionListener(this);
        this.miCloseAll.addActionListener(this);
        this.miAbout.addActionListener(this);
        this.bNew.addActionListener(this);
        this.bOpen.addActionListener(this);
        this.bReload.addActionListener(this);
        this.bSave.addActionListener(this);
        this.bSaveAll.addActionListener(this);
        this.bRevert.addActionListener(this);
        this.bPrint.addActionListener(this);
        this.bUndo.addActionListener(this);
        this.bRedo.addActionListener(this);
        this.bCut.addActionListener(this);
        this.bCopy.addActionListener(this);
        this.bPaste.addActionListener(this);
        this.bFind.addActionListener(this);
        this.bReplace.addActionListener(this);
        this.bMakeUpperCase.addActionListener(this);
        this.bMakeLowerCase.addActionListener(this);
        this.bDeleteHorizontalWhiteSpace.addActionListener(this);
        this.bIncreaseLineIndent.addActionListener(this);
        this.bDecreaseLineIndent.addActionListener(this);
        this.bPerformComplexOperation.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.bExit.addActionListener(this);
        this.cbFontNames.addActionListener(this);
        this.cbFontSizes.addActionListener(this);
        this.bBold.addActionListener(this);
        this.bItalic.addActionListener(this);
        this.bUnderline.addActionListener(this);
        this.bLeft.addActionListener(this);
        this.bCenter.addActionListener(this);
        this.bRight.addActionListener(this);
        this.bForeground.addActionListener(this);
        this.bBackground.addActionListener(this);
        this.bParagraph.addActionListener(this);
        this.bStyle.addActionListener(this);
        this.pmiUndo.addActionListener(this);
        this.pmiRedo.addActionListener(this);
        this.pmiCut.addActionListener(this);
        this.pmiCopy.addActionListener(this);
        this.pmiPaste.addActionListener(this);
        this.pmiSelectAll.addActionListener(this);
        this.pmiPlainText.addActionListener(this);
        this.pmiXML.addActionListener(this);
        this.pmiRTF.addActionListener(this);
        this.pmiHTML.addActionListener(this);
        this.pmiClose.addActionListener(this);
        this.pmiCloseOthers.addActionListener(this);
        this.pmiCloseAll.addActionListener(this);
    }

    @Override
    public CommandGateway getCommandGateway() {
        return this.commandGateway;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.miNew || actionEvent.getSource() == this.bNew) {
            this.getCommandGateway().performCommand(CommandType.NEW);
        } else if (actionEvent.getSource() == this.miOpen || actionEvent.getSource() == this.bOpen) {
            this.getCommandGateway().performCommand(CommandType.OPEN);
        } else if (actionEvent.getSource() == this.miRestore) {
            this.getCommandGateway().performCommand(CommandType.RESTORE);
        } else if (actionEvent.getSource() == this.miSave || actionEvent.getSource() == this.bSave) {
            this.getCommandGateway().performCommand(CommandType.SAVE);
        } else if (actionEvent.getSource() == this.miSaveAs) {
            this.getCommandGateway().performCommand(CommandType.SAVE_AS);
        } else if (actionEvent.getSource() == this.miSaveAll || actionEvent.getSource() == this.bSaveAll) {
            this.getCommandGateway().performCommand(CommandType.SAVE_ALL);
        } else if (actionEvent.getSource() == this.miRevert || actionEvent.getSource() == this.bRevert) {
            this.getCommandGateway().performCommand(CommandType.REVERT);
        } else if (actionEvent.getSource() == this.miReload || actionEvent.getSource() == this.bReload) {
            this.getCommandGateway().performCommand(CommandType.RELOAD);
        } else if (actionEvent.getSource() == this.miChangeDir) {
            this.getCommandGateway().performCommand(CommandType.CHANGE_DIR);
        } else if (actionEvent.getSource() == this.miPrint || actionEvent.getSource() == this.bPrint) {
            this.getCommandGateway().performCommand(CommandType.PRINT);
        } else if (actionEvent.getSource() == this.miExit || actionEvent.getSource() == this.bExit) {
            this.getCommandGateway().performCommand(CommandType.EXIT);
        } else if (actionEvent.getSource() == this.miUndo || actionEvent.getSource() == this.bUndo || actionEvent.getSource() == this.pmiUndo) {
            this.getCommandGateway().performCommand(CommandType.UNDO);
        } else if (actionEvent.getSource() == this.miRedo || actionEvent.getSource() == this.bRedo || actionEvent.getSource() == this.pmiRedo) {
            this.getCommandGateway().performCommand(CommandType.REDO);
        } else if (actionEvent.getSource() == this.miCut || actionEvent.getSource() == this.bCut || actionEvent.getSource() == this.pmiCut) {
            this.getCommandGateway().performCommand(CommandType.CUT);
        } else if (actionEvent.getSource() == this.miCopy || actionEvent.getSource() == this.bCopy || actionEvent.getSource() == this.pmiCopy) {
            this.getCommandGateway().performCommand(CommandType.COPY);
        } else if (actionEvent.getSource() == this.miPaste || actionEvent.getSource() == this.bPaste || actionEvent.getSource() == this.pmiPaste) {
            this.getCommandGateway().performCommand(CommandType.PASTE);
        } else if (actionEvent.getSource() == this.miGoTo) {
            this.getCommandGateway().performCommand(CommandType.GO_TO);
        } else if (actionEvent.getSource() == this.miFind || actionEvent.getSource() == this.bFind) {
            this.getCommandGateway().performCommand(CommandType.FIND);
        } else if (actionEvent.getSource() == this.miReplace || actionEvent.getSource() == this.bReplace) {
            this.getCommandGateway().performCommand(CommandType.REPLACE);
        } else if (actionEvent.getSource() == this.miSelectAll || actionEvent.getSource() == this.pmiSelectAll) {
            this.getCommandGateway().performCommand(CommandType.SELECT_ALL);
        } else if (actionEvent.getSource() == this.miMakeUppercase || actionEvent.getSource() == this.bMakeUpperCase) {
            this.getCommandGateway().performCommand(CommandType.MAKE_UPPERCASE);
        } else if (actionEvent.getSource() == this.miMakeLowercase || actionEvent.getSource() == this.bMakeLowerCase) {
            this.getCommandGateway().performCommand(CommandType.MAKE_LOWERCASE);
        } else if (actionEvent.getSource() == this.miTabifySelectedLines) {
            this.getCommandGateway().performCommand(CommandType.TABIFY_SELECTED_LINES);
        } else if (actionEvent.getSource() == this.miUntabifySelectedLines) {
            this.getCommandGateway().performCommand(CommandType.UNTABIFY_SELECTED_LINES);
        } else if (actionEvent.getSource() == this.miDeleteHorizontalWhiteSpace || actionEvent.getSource() == this.bDeleteHorizontalWhiteSpace) {
            this.getCommandGateway().performCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE);
        } else if (actionEvent.getSource() == this.miRemoveTrailingWhitespaces) {
            this.getCommandGateway().performCommand(CommandType.REMOVE_TRAILING_WHITESPACES);
        } else if (actionEvent.getSource() == this.miShiftInLeft || actionEvent.getSource() == this.bDecreaseLineIndent) {
            this.getCommandGateway().performCommand(CommandType.DECREASE_LINE_INDENT);
        } else if (actionEvent.getSource() == this.miShiftInRight || actionEvent.getSource() == this.bIncreaseLineIndent) {
            this.getCommandGateway().performCommand(CommandType.INCREASE_LINE_INDENT);
        } else if (actionEvent.getSource() == this.miPerformComplexOperation || actionEvent.getSource() == this.bPerformComplexOperation) {
            this.getCommandGateway().performCommand(CommandType.PERFORM_COMPLEX_OPERATION);
        } else if (actionEvent.getSource() == this.miParagraph || actionEvent.getSource() == this.bParagraph) {
            this.getCommandGateway().performCommand(CommandType.PARAGRAPH);
        } else if (actionEvent.getSource() == this.miStyle || actionEvent.getSource() == this.bStyle) {
            this.getCommandGateway().performCommand(CommandType.STYLE);
        } else if (actionEvent.getSource() == this.miStyledBackground) {
            this.getCommandGateway().performCommand(CommandType.STYLED_BACKGROUND);
        } else if (actionEvent.getSource() == this.miInsertImage) {
            this.getCommandGateway().performCommand(CommandType.INSERT_IMAGE);
        } else if (actionEvent.getSource() == this.miForeground) {
            this.getCommandGateway().performCommand(CommandType.FOREGROUND);
        } else if (actionEvent.getSource() == this.miBackgound) {
            this.getCommandGateway().performCommand(CommandType.BACKGROUND);
        } else if (actionEvent.getSource() == this.miFont) {
            this.getCommandGateway().performCommand(CommandType.FONT);
        } else if (actionEvent.getSource() == this.miEncoding) {
            this.getCommandGateway().performCommand(CommandType.ENCODING);
        } else if (actionEvent.getSource() == this.miAdvanced || actionEvent.getSource() == this.miOptions) {
            this.getCommandGateway().performCommand(CommandType.ADVANCED);
        } else if (actionEvent.getSource() == this.miAbout) {
            this.getCommandGateway().performCommand(CommandType.ABOUT);
        } else if (actionEvent.getSource() == this.miPlainText || actionEvent.getSource() == this.pmiPlainText) {
            this.getCommandGateway().performCommand(CommandType.NEW_PLAIN_TEXT_EDITOR);
        } else if (actionEvent.getSource() == this.miXML || actionEvent.getSource() == this.pmiXML) {
            this.getCommandGateway().performCommand(CommandType.NEW_XML_EDITOR);
        } else if (actionEvent.getSource() == this.miRTF || actionEvent.getSource() == this.pmiRTF) {
            this.getCommandGateway().performCommand(CommandType.NEW_RTF_EDITOR);
        } else if (actionEvent.getSource() == this.miHTML || actionEvent.getSource() == this.pmiHTML) {
            this.getCommandGateway().performCommand(CommandType.NEW_HTML_EDITOR);
        } else if (actionEvent.getSource() == this.miClose || actionEvent.getSource() == this.pmiClose) {
            this.getCommandGateway().performCommand(CommandType.CLOSE);
        } else if (actionEvent.getSource() == this.miCloseOthers || actionEvent.getSource() == this.pmiCloseOthers) {
            this.getCommandGateway().performCommand(CommandType.CLOSE_OTHERS);
        } else if (actionEvent.getSource() == this.miCloseAll || actionEvent.getSource() == this.pmiCloseAll) {
            this.getCommandGateway().performCommand(CommandType.CLOSE_ALL);
        } else if (actionEvent.getSource() == this.bBold) {
            this.getCommandGateway().performCommand(CommandType.TOGGLE_BOLD);
        } else if (actionEvent.getSource() == this.bItalic) {
            this.getCommandGateway().performCommand(CommandType.TOGGLE_ITALIC);
        } else if (actionEvent.getSource() == this.bUnderline) {
            this.getCommandGateway().performCommand(CommandType.TOGGLE_UNDERLINE);
        } else if (actionEvent.getSource() == this.bLeft) {
            this.getCommandGateway().performCommand(CommandType.ALIGN_LEFT);
        } else if (actionEvent.getSource() == this.bCenter) {
            this.getCommandGateway().performCommand(CommandType.ALIGN_CENTER);
        } else if (actionEvent.getSource() == this.bRight) {
            this.getCommandGateway().performCommand(CommandType.ALIGN_RIGHT);
        } else if (actionEvent.getSource() == this.bForeground) {
            this.getCommandGateway().performCommand(CommandType.SET_STYLE_FOREGROUND);
        } else if (actionEvent.getSource() == this.bBackground) {
            this.getCommandGateway().performCommand(CommandType.SET_STYLE_BACKGROUND);
        } else if (actionEvent.getSource() == this.cbFontNames) {
            this.changeFontFamily();
        } else if (actionEvent.getSource() == this.cbFontSizes) {
            this.changeFontSize();
        }
        this.getTextEditor().getTextComponent().grabFocus();
    }

    private void changeFontFamily() {
        if (!(this.getTextEditor().getTextComponent() instanceof JTextPane)) {
            return;
        }
        JTextPane jTextPane = (JTextPane)this.getTextEditor().getTextComponent();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, this.cbFontNames.getSelectedItem().toString());
        jTextPane.setCharacterAttributes(simpleAttributeSet, false);
    }

    private void changeFontSize() {
        int n;
        if (!(this.getTextEditor().getTextComponent() instanceof JTextPane)) {
            return;
        }
        JTextPane jTextPane = (JTextPane)this.getTextEditor().getTextComponent();
        AttributeSet attributeSet = jTextPane.getCharacterAttributes();
        int n2 = n = StyleConstants.getFontSize(attributeSet);
        try {
            n2 = Integer.parseInt(this.cbFontSizes.getSelectedItem().toString());
            if (n2 <= 0) {
                n2 = n;
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.cbFontSizes.getEditor().setItem(Integer.toString(n2));
        }
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n2);
        jTextPane.setCharacterAttributes(simpleAttributeSet, false);
    }
}

