/*
 * Decompiled with CFR 0.152.
 */
package gui;

import editing.MultiDocumentComponent;
import gui.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Hashtable;
import neutrino.multitext.EditorChangeEvent;
import neutrino.multitext.EditorChangeListener;
import neutrino.multitext.MultiTextComponent;
import neutrino.text.FileChangeEvent;
import neutrino.text.FileChangeListener;
import neutrino.text.TextEditor;

abstract class ContentBuilder
extends Application {
    private MultiTextComponent multiTextComponent = null;
    private FileChangeListener fileListener = new FileChangeListener(){

        @Override
        public void fileChanged(FileChangeEvent fileChangeEvent) {
            switch (fileChangeEvent.getType()) {
                case CLEARING: {
                    ContentBuilder.this.setTitle("MultiText Editor");
                    break;
                }
                case OPENING: 
                case SAVING: 
                case RESTORING: {
                    if (fileChangeEvent.getSource().isFileLoaded()) {
                        if (ContentBuilder.this.getSettings().isAutoChangeDirMode()) {
                            File file = fileChangeEvent.getSource().getFile().getParentFile();
                            ContentBuilder.this.getMultiTextComponent().setCurrentDirectory(file);
                        }
                        ContentBuilder.this.setTitle("MultiText Editor - " + fileChangeEvent.getSource().getFile().getAbsolutePath());
                        ContentBuilder.this.updateHistory(fileChangeEvent.getSource());
                        break;
                    }
                    ContentBuilder.this.setTitle("MultiText Editor");
                }
            }
        }
    };
    private EditorChangeListener editorListener = new EditorChangeListener(){

        @Override
        public void editorAdded(EditorChangeEvent editorChangeEvent) {
            editorChangeEvent.getTextEditor().addFileChangeListener(ContentBuilder.this.fileListener);
        }

        @Override
        public void editorChanged(EditorChangeEvent editorChangeEvent) {
            if (editorChangeEvent.getTextEditor().isFileLoaded()) {
                ContentBuilder.this.setTitle("MultiText Editor - " + editorChangeEvent.getTextEditor().getFile().getAbsolutePath());
            } else {
                ContentBuilder.this.setTitle("MultiText Editor");
            }
        }

        @Override
        public void editorClosed(EditorChangeEvent editorChangeEvent) {
        }
    };

    public ContentBuilder() {
        this.multiTextComponent = new MultiDocumentComponent();
        this.setLayout(new BorderLayout());
        this.add((Component)this.multiTextComponent, "Center");
        this.multiTextComponent.getCurrentTextEditor().addFileChangeListener(this.fileListener);
        this.multiTextComponent.addEditorChangeListener(this.editorListener);
    }

    @Override
    public TextEditor getTextEditor() {
        return this.multiTextComponent.getCurrentTextEditor();
    }

    @Override
    public MultiTextComponent getMultiTextComponent() {
        return this.multiTextComponent;
    }

    private void updateHistory(TextEditor textEditor) {
        if (!this.getSettings().isKeepHistory()) {
            return;
        }
        if (!textEditor.isFileLoaded()) {
            return;
        }
        Hashtable<File, Integer> hashtable = this.getSettings().getHistory();
        if (hashtable.get(textEditor.getFile()) == null) {
            hashtable.put(textEditor.getFile(), new Integer(1));
        } else {
            int n = hashtable.get(textEditor.getFile());
            hashtable.put(textEditor.getFile(), new Integer(n + 1));
        }
    }
}

