/*
 * Decompiled with CFR 0.152.
 */
package gui;

import commands.CommandType;
import gui.ContentBuilder;
import gui.menu.FileMenuItem;
import gui.menu.TabMenuItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import neutrino.multitext.EditorChangeEvent;
import neutrino.multitext.EditorChangeListener;
import neutrino.multitext.MultiTextComponent;
import neutrino.text.PlainTextArea;
import neutrino.text.PlainTextComponent;
import neutrino.text.TextEditor;

abstract class MenuBarBuilder
extends ContentBuilder {
    private JMenuBar menuBar = null;
    private ClassLoader loader = MenuBarBuilder.class.getClassLoader();
    protected ImageIcon iconNew = new ImageIcon(this.loader.getResource("icons/new.gif"));
    protected ImageIcon iconOpen = new ImageIcon(this.loader.getResource("icons/open.gif"));
    protected ImageIcon iconReload = new ImageIcon(this.loader.getResource("icons/reload.gif"));
    protected ImageIcon iconRestore = new ImageIcon(this.loader.getResource("icons/restore.gif"));
    protected ImageIcon iconSave = new ImageIcon(this.loader.getResource("icons/save.gif"));
    protected ImageIcon iconSaveAll = new ImageIcon(this.loader.getResource("icons/saveAll.gif"));
    protected ImageIcon iconRevert = new ImageIcon(this.loader.getResource("icons/revert.gif"));
    protected ImageIcon iconPrint = new ImageIcon(this.loader.getResource("icons/print.gif"));
    protected ImageIcon iconExit = new ImageIcon(this.loader.getResource("icons/exit.gif"));
    protected ImageIcon iconUndo = new ImageIcon(this.loader.getResource("icons/undo.gif"));
    protected ImageIcon iconRedo = new ImageIcon(this.loader.getResource("icons/redo.gif"));
    protected ImageIcon iconCut = new ImageIcon(this.loader.getResource("icons/cut.gif"));
    protected ImageIcon iconCopy = new ImageIcon(this.loader.getResource("icons/copy.gif"));
    protected ImageIcon iconPaste = new ImageIcon(this.loader.getResource("icons/paste.gif"));
    protected ImageIcon iconFind = new ImageIcon(this.loader.getResource("icons/find.gif"));
    protected ImageIcon iconReplace = new ImageIcon(this.loader.getResource("icons/replace.gif"));
    protected ImageIcon iconSelectAll = new ImageIcon(this.loader.getResource("icons/selectAll.gif"));
    protected ImageIcon iconStyle = new ImageIcon(this.loader.getResource("icons/style.gif"));
    protected ImageIcon iconParagraph = new ImageIcon(this.loader.getResource("icons/paragraph.gif"));
    protected ImageIcon iconImage = new ImageIcon(this.loader.getResource("icons/image.gif"));
    protected ImageIcon iconForeground = new ImageIcon(this.loader.getResource("icons/foreground.gif"));
    protected ImageIcon iconBackground = new ImageIcon(this.loader.getResource("icons/background.gif"));
    protected ImageIcon iconFont = new ImageIcon(this.loader.getResource("icons/font.gif"));
    protected ImageIcon iconEncoding = new ImageIcon(this.loader.getResource("icons/encoding.gif"));
    protected ImageIcon iconAdvanced = new ImageIcon(this.loader.getResource("icons/advanced.gif"));
    protected ImageIcon iconUpperCase = new ImageIcon(this.loader.getResource("icons/upperCase.gif"));
    protected ImageIcon iconLowerCase = new ImageIcon(this.loader.getResource("icons/lowerCase.gif"));
    protected ImageIcon iconDeleteHorizontalWhiteSpace = new ImageIcon(this.loader.getResource("icons/deleteHorizontalWhiteSpace.gif"));
    protected ImageIcon iconShiftLeft = new ImageIcon(this.loader.getResource("icons/shiftLeft.gif"));
    protected ImageIcon iconShiftRight = new ImageIcon(this.loader.getResource("icons/shiftRight.gif"));
    protected ImageIcon iconComplexOperation = new ImageIcon(this.loader.getResource("icons/complexOperation.gif"));
    protected ImageIcon iconHelp = new ImageIcon(this.loader.getResource("icons/help.gif"));
    protected ImageIcon iconAbout = new ImageIcon(this.loader.getResource("icons/about.gif"));
    protected ImageIcon iconBold = new ImageIcon(this.loader.getResource("icons/bold.gif"));
    protected ImageIcon iconItalic = new ImageIcon(this.loader.getResource("icons/italic.gif"));
    protected ImageIcon iconUnderline = new ImageIcon(this.loader.getResource("icons/underline.gif"));
    protected ImageIcon iconLeft = new ImageIcon(this.loader.getResource("icons/left.gif"));
    protected ImageIcon iconCenter = new ImageIcon(this.loader.getResource("icons/center.gif"));
    protected ImageIcon iconRight = new ImageIcon(this.loader.getResource("icons/right.gif"));
    protected JMenu mFile = new JMenu("File");
    protected JMenuItem miNew = new JMenuItem("New", this.iconNew);
    protected JMenuItem miOpen = new JMenuItem("Open...", this.iconOpen);
    protected JMenu mReopen = new JMenu("Reopen");
    protected JMenuItem miRestore = new JMenuItem("Restore...", this.iconRestore);
    protected JMenuItem miReload = new JMenuItem("Reload", this.iconReload);
    protected JMenuItem miSave = new JMenuItem("Save", this.iconSave);
    protected JMenuItem miSaveAs = new JMenuItem("Save As...");
    protected JMenuItem miSaveAll = new JMenuItem("Save All", this.iconSaveAll);
    protected JMenuItem miRevert = new JMenuItem("Revert", this.iconRevert);
    protected JMenuItem miChangeDir = new JMenuItem("Change Dir...");
    protected JMenuItem miPrint = new JMenuItem("Print...", this.iconPrint);
    protected JMenuItem miExit = new JMenuItem("Exit", this.iconExit);
    protected JMenu mEdit = new JMenu("Edit");
    protected JMenuItem miUndo = new JMenuItem("Undo", this.iconUndo);
    protected JMenuItem miRedo = new JMenuItem("Redo", this.iconRedo);
    protected JMenuItem miCut = new JMenuItem("Cut", this.iconCut);
    protected JMenuItem miCopy = new JMenuItem("Copy", this.iconCopy);
    protected JMenuItem miPaste = new JMenuItem("Paste", this.iconPaste);
    protected JMenuItem miGoTo = new JMenuItem("Go To...");
    protected JMenuItem miFind = new JMenuItem("Find...", this.iconFind);
    protected JMenuItem miReplace = new JMenuItem("Replace...", this.iconReplace);
    protected JMenuItem miSelectAll = new JMenuItem("Select All", this.iconSelectAll);
    protected JMenuItem miOptions = new JMenuItem("Options...", this.iconAdvanced);
    protected JMenu mAdvanced = new JMenu("Advanced");
    protected JMenuItem miMakeUppercase = new JMenuItem("Make Uppercase", this.iconUpperCase);
    protected JMenuItem miMakeLowercase = new JMenuItem("Make Lowercase", this.iconLowerCase);
    protected JMenuItem miTabifySelectedLines = new JMenuItem("Tabify Selected Lines");
    protected JMenuItem miUntabifySelectedLines = new JMenuItem("Untabify Selected Lines");
    protected JMenuItem miDeleteHorizontalWhiteSpace = new JMenuItem("Delete Horizontal White Space", this.iconDeleteHorizontalWhiteSpace);
    protected JMenuItem miRemoveTrailingWhitespaces = new JMenuItem("Remove Trailing Whitespaces");
    protected JMenuItem miShiftInRight = new JMenuItem("Increase Line Indent", this.iconShiftRight);
    protected JMenuItem miShiftInLeft = new JMenuItem("Decrease Line Indent", this.iconShiftLeft);
    protected JMenuItem miPerformComplexOperation = new JMenuItem("Perform Complex Operation...", this.iconComplexOperation);
    protected JMenu mFormat = new JMenu("Format");
    protected JMenuItem miStyledBackground = new JMenuItem("Background...", this.iconBackground);
    protected JMenuItem miParagraph = new JMenuItem("Paragraph...", this.iconParagraph);
    protected JMenuItem miStyle = new JMenuItem("Style...", this.iconStyle);
    protected JMenuItem miInsertImage = new JMenuItem("Insert Image...", this.iconImage);
    protected JMenu mOptions = new JMenu("Options");
    protected JMenuItem miForeground = new JMenuItem("Foreground...", this.iconForeground);
    protected JMenuItem miBackgound = new JMenuItem("Background...", this.iconBackground);
    protected JMenuItem miFont = new JMenuItem("Font...", this.iconFont);
    protected JMenuItem miEncoding = new JMenuItem("Encoding...", this.iconEncoding);
    protected JMenuItem miAdvanced = new JMenuItem("Advanced...", this.iconAdvanced);
    protected JMenu mWindow = new JMenu("Window");
    protected JMenu mNewEditor = new JMenu("New Editor");
    protected JMenuItem miPlainText = new JMenuItem("Plain Text");
    protected JMenuItem miXML = new JMenuItem("XML");
    protected JMenuItem miRTF = new JMenuItem("RTF");
    protected JMenuItem miHTML = new JMenuItem("HTML");
    protected JMenuItem miClose = new JMenuItem("Close");
    protected JMenuItem miCloseOthers = new JMenuItem("Close Others");
    protected JMenuItem miCloseAll = new JMenuItem("Close All");
    protected JMenu mHelp = new JMenu("Help");
    protected JMenuItem miHelp = new JMenuItem("Help", this.iconHelp);
    protected JMenuItem miAbout = new JMenuItem("About", this.iconAbout);
    private MenuListener mlFile = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miNew.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.NEW));
            MenuBarBuilder.this.miSave.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.SAVE));
            MenuBarBuilder.this.miSaveAs.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.SAVE_AS));
            MenuBarBuilder.this.miSaveAll.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.SAVE_ALL));
            MenuBarBuilder.this.miReload.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.RELOAD));
            MenuBarBuilder.this.miRevert.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.REVERT));
            MenuBarBuilder.this.miPrint.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.PRINT));
            MenuBarBuilder.this.miRestore.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.RESTORE));
            if (MenuBarBuilder.this.getSettings().isKeepHistory()) {
                MenuBarBuilder.this.mReopen.setVisible(true);
                MenuBarBuilder.this.mReopen.setEnabled(!MenuBarBuilder.this.getSettings().getHistory().isEmpty());
            } else {
                MenuBarBuilder.this.mReopen.setVisible(false);
            }
        }
    };
    private MenuListener mlReopen = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.mReopen.removeAll();
            TextEditor textEditor = MenuBarBuilder.this.getTextEditor();
            Iterator iterator = MenuBarBuilder.this.getFilesFromHistory().iterator();
            while (iterator.hasNext()) {
                File file = ((FileInfo)iterator.next()).file;
                if (!file.exists() || !file.isFile()) continue;
                FileMenuItem fileMenuItem = new FileMenuItem(textEditor, file);
                MenuBarBuilder.this.mReopen.add(fileMenuItem);
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    };
    private MenuListener mlEdit = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miUndo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.UNDO));
            MenuBarBuilder.this.miRedo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.REDO));
            MenuBarBuilder.this.miCut.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.CUT));
            MenuBarBuilder.this.miCopy.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.COPY));
            MenuBarBuilder.this.miPaste.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.PASTE));
            MenuBarBuilder.this.miGoTo.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.GO_TO));
            MenuBarBuilder.this.miFind.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.FIND));
            MenuBarBuilder.this.miReplace.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.REPLACE));
            MenuBarBuilder.this.miSelectAll.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.SELECT_ALL));
            MenuBarBuilder.this.mAdvanced.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.ADVANCED_EDITING_COMMAND));
        }
    };
    private MenuListener mlAdvanced = new MenuListener(){

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.miMakeUppercase.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.MAKE_UPPERCASE));
            MenuBarBuilder.this.miMakeLowercase.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.MAKE_LOWERCASE));
            MenuBarBuilder.this.miTabifySelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.TABIFY_SELECTED_LINES));
            MenuBarBuilder.this.miUntabifySelectedLines.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.UNTABIFY_SELECTED_LINES));
        }
    };
    private MenuListener mlWindow = new MenuListener(){

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            MenuBarBuilder.this.rebuildWindowMenu();
            MenuBarBuilder.this.miClose.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.CLOSE));
            MenuBarBuilder.this.miCloseOthers.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.CLOSE_OTHERS));
            MenuBarBuilder.this.miCloseAll.setEnabled(MenuBarBuilder.this.getCommandGateway().canPeformCommand(CommandType.CLOSE_ALL));
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }
    };
    private EditorChangeListener menuRebuildingListener = new EditorChangeListener(){

        @Override
        public void editorClosed(EditorChangeEvent editorChangeEvent) {
            MenuBarBuilder.this.rebuildMenuBar();
        }

        @Override
        public void editorChanged(EditorChangeEvent editorChangeEvent) {
            MenuBarBuilder.this.rebuildMenuBar();
        }

        @Override
        public void editorAdded(EditorChangeEvent editorChangeEvent) {
            MenuBarBuilder.this.rebuildMenuBar();
        }
    };

    public MenuBarBuilder() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.getMultiTextComponent().addEditorChangeListener(this.menuRebuildingListener);
    }

    private void buildMenus() {
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mEdit);
        this.menuBar.add(this.mFormat);
        this.menuBar.add(this.mOptions);
        this.menuBar.add(this.mWindow);
        this.menuBar.add(this.mHelp);
        this.mFile.add(this.miNew);
        this.mFile.add(this.miOpen);
        this.mFile.add(this.mReopen);
        this.mFile.add(this.miReload);
        this.mFile.add(this.miRestore);
        this.mFile.addSeparator();
        this.mFile.add(this.miSave);
        this.mFile.add(this.miSaveAs);
        this.mFile.add(this.miSaveAll);
        this.mFile.add(this.miRevert);
        this.mFile.addSeparator();
        this.mFile.add(this.miChangeDir);
        this.mFile.add(this.miPrint);
        this.mFile.addSeparator();
        this.mFile.add(this.miExit);
        this.mAdvanced.add(this.miMakeUppercase);
        this.mAdvanced.add(this.miMakeLowercase);
        this.mAdvanced.add(this.miTabifySelectedLines);
        this.mAdvanced.add(this.miUntabifySelectedLines);
        this.mAdvanced.add(this.miDeleteHorizontalWhiteSpace);
        this.mAdvanced.add(this.miRemoveTrailingWhitespaces);
        this.mAdvanced.add(this.miShiftInRight);
        this.mAdvanced.add(this.miShiftInLeft);
        this.mAdvanced.addSeparator();
        this.mAdvanced.add(this.miPerformComplexOperation);
        this.mFormat.add(this.miParagraph);
        this.mFormat.add(this.miStyle);
        this.mFormat.add(this.miStyledBackground);
        this.mFormat.add(this.miInsertImage);
        this.mFormat.add(this.miOptions);
        this.mOptions.add(this.miForeground);
        this.mOptions.add(this.miBackgound);
        this.mOptions.add(this.miFont);
        this.mOptions.add(this.miEncoding);
        this.mOptions.add(this.miAdvanced);
        this.rebuildWindowMenu();
        this.mNewEditor.add(this.miPlainText);
        this.mNewEditor.add(this.miXML);
        this.mNewEditor.add(this.miRTF);
        this.mNewEditor.add(this.miHTML);
        this.mHelp.add(this.miHelp);
        this.mHelp.add(this.miAbout);
        this.rebuildMenuBar();
    }

    @Override
    public void rebuildMenuBar() {
        JTextComponent jTextComponent = this.getTextEditor().getTextComponent();
        this.mEdit.removeAll();
        this.mEdit.add(this.miUndo);
        this.mEdit.add(this.miRedo);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miCut);
        this.mEdit.add(this.miCopy);
        this.mEdit.add(this.miPaste);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miGoTo);
        this.mEdit.add(this.miFind);
        this.mEdit.add(this.miReplace);
        this.mEdit.addSeparator();
        this.mEdit.add(this.miSelectAll);
        if (jTextComponent instanceof PlainTextArea || jTextComponent instanceof PlainTextComponent) {
            this.mEdit.add(this.mAdvanced);
            this.mFormat.setVisible(false);
            this.mOptions.setVisible(true);
        } else {
            this.mFormat.setVisible(true);
            this.mOptions.setVisible(false);
        }
    }

    private void buildAccelerators() {
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.miSaveAll.setAccelerator(KeyStroke.getKeyStroke(113, 128));
        this.miReload.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.miExit.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.miGoTo.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.miFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.miReplace.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.miMakeUppercase.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        this.miMakeLowercase.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.miDeleteHorizontalWhiteSpace.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.miRemoveTrailingWhitespaces.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.miShiftInLeft.setAccelerator(KeyStroke.getKeyStroke(37, 512));
        this.miShiftInRight.setAccelerator(KeyStroke.getKeyStroke(39, 512));
        this.miParagraph.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.miStyle.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.miForeground.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.miBackgound.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        this.miFont.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.miEncoding.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.miAdvanced.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.miOptions.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.miHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
    }

    private void buildMnemonics() {
        this.mFile.setMnemonic(70);
        this.mEdit.setMnemonic(69);
        this.mFormat.setMnemonic(82);
        this.mOptions.setMnemonic(79);
        this.mWindow.setMnemonic(87);
        this.mHelp.setMnemonic(72);
        this.miNew.setMnemonic(78);
        this.miOpen.setMnemonic(79);
        this.mReopen.setMnemonic(82);
        this.miRestore.setMnemonic(69);
        this.miSave.setMnemonic(83);
        this.miSaveAs.setMnemonic(65);
        this.miSaveAll.setMnemonic(76);
        this.miReload.setMnemonic(68);
        this.miRevert.setMnemonic(86);
        this.miChangeDir.setMnemonic(67);
        this.miPrint.setMnemonic(80);
        this.miExit.setMnemonic(88);
        this.miUndo.setMnemonic(85);
        this.miRedo.setMnemonic(82);
        this.miCut.setMnemonic(67);
        this.miCopy.setMnemonic(79);
        this.miPaste.setMnemonic(80);
        this.miGoTo.setMnemonic(71);
        this.miFind.setMnemonic(70);
        this.miReplace.setMnemonic(82);
        this.miSelectAll.setMnemonic(83);
        this.miOptions.setMnemonic(84);
        this.mAdvanced.setMnemonic(65);
        this.miMakeUppercase.setMnemonic(85);
        this.miMakeLowercase.setMnemonic(76);
        this.miTabifySelectedLines.setMnemonic(84);
        this.miUntabifySelectedLines.setMnemonic(85);
        this.miDeleteHorizontalWhiteSpace.setMnemonic(68);
        this.miRemoveTrailingWhitespaces.setMnemonic(82);
        this.miShiftInRight.setMnemonic(73);
        this.miShiftInLeft.setMnemonic(69);
        this.miPerformComplexOperation.setMnemonic(80);
        this.miParagraph.setMnemonic(80);
        this.miStyle.setMnemonic(83);
        this.miStyledBackground.setMnemonic(66);
        this.miInsertImage.setMnemonic(73);
        this.miForeground.setMnemonic(79);
        this.miBackgound.setMnemonic(66);
        this.miFont.setMnemonic(70);
        this.miEncoding.setMnemonic(69);
        this.miAdvanced.setMnemonic(65);
        this.mNewEditor.setMnemonic(69);
        this.miPlainText.setMnemonic(80);
        this.miXML.setMnemonic(88);
        this.miRTF.setMnemonic(82);
        this.miHTML.setMnemonic(72);
        this.miClose.setMnemonic(67);
        this.miCloseOthers.setMnemonic(79);
        this.miCloseAll.setMnemonic(65);
        this.miHelp.setMnemonic(72);
        this.miAbout.setMnemonic(65);
    }

    protected void buildActions() {
        this.mFile.addMenuListener(this.mlFile);
        this.mReopen.addMenuListener(this.mlReopen);
        this.mEdit.addMenuListener(this.mlEdit);
        this.mWindow.addMenuListener(this.mlWindow);
        this.mAdvanced.addMenuListener(this.mlAdvanced);
    }

    protected void buildMenuBar() {
        this.buildMenus();
        this.buildAccelerators();
        this.buildMnemonics();
    }

    private List<FileInfo> getFilesFromHistory() {
        Object object;
        ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
        Hashtable<File, Integer> hashtable = this.getSettings().getHistory();
        Enumeration<File> enumeration = this.getSettings().getHistory().keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            FileInfo fileInfo = new FileInfo();
            fileInfo.file = object;
            fileInfo.numberOfOpening = hashtable.get(object);
            arrayList.add(fileInfo);
        }
        object = new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
                if (fileInfo.numberOfOpening == fileInfo2.numberOfOpening) {
                    return 0;
                }
                if (fileInfo.numberOfOpening <= fileInfo2.numberOfOpening) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(arrayList, object);
        return arrayList.subList(0, arrayList.size() < 15 ? arrayList.size() : 15);
    }

    private void rebuildWindowMenu() {
        this.mWindow.removeAll();
        this.mWindow.add(this.mNewEditor);
        this.mWindow.addSeparator();
        this.mWindow.add(this.miClose);
        this.mWindow.add(this.miCloseOthers);
        this.mWindow.add(this.miCloseAll);
        if (!this.getMultiTextComponent().isSingleTextComponent()) {
            this.mWindow.addSeparator();
            TextEditor[] textEditorArray = this.getMultiTextComponent().getTextEditors();
            for (int i = 0; i < textEditorArray.length; ++i) {
                String string = MultiTextComponent.createTitleForTextComponent(textEditorArray[i]);
                TabMenuItem tabMenuItem = new TabMenuItem(this.getMultiTextComponent(), textEditorArray[i], string, i);
                this.mWindow.add(tabMenuItem);
            }
        }
    }

    private class FileInfo {
        public File file;
        public Integer numberOfOpening;

        private FileInfo() {
        }
    }
}

