/*
 * Decompiled with CFR 0.152.
 */
package gui;

import commands.CommandType;
import gui.MenuBarBuilder;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

abstract class PopupMenuBuilder
extends MenuBarBuilder {
    private JPopupMenu textComponentPopupMenu = new JPopupMenu();
    private JPopupMenu multiTextComponentPopupMenu = new JPopupMenu();
    protected JMenuItem pmiUndo = new JMenuItem("Undo", this.iconUndo);
    protected JMenuItem pmiRedo = new JMenuItem("Redo", this.iconRedo);
    protected JMenuItem pmiCut = new JMenuItem("Cut", this.iconCut);
    protected JMenuItem pmiCopy = new JMenuItem("Copy", this.iconCopy);
    protected JMenuItem pmiPaste = new JMenuItem("Paste", this.iconPaste);
    protected JMenuItem pmiSelectAll = new JMenuItem("Select all", this.iconSelectAll);
    protected JMenu pmNewEditor = new JMenu("New Editor");
    protected JMenuItem pmiPlainText = new JMenuItem("Plain Text");
    protected JMenuItem pmiXML = new JMenuItem("XML");
    protected JMenuItem pmiRTF = new JMenuItem("RTF");
    protected JMenuItem pmiHTML = new JMenuItem("HTML");
    protected JMenuItem pmiClose = new JMenuItem("Close");
    protected JMenuItem pmiCloseOthers = new JMenuItem("Close Others");
    protected JMenuItem pmiCloseAll = new JMenuItem("Close All");

    public PopupMenuBuilder() {
        this.getMultiTextComponent().setPopupMenuForTextComponents(this.textComponentPopupMenu);
        this.textComponentPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                PopupMenuBuilder.this.updateTextComponentPopupMenuState();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.getMultiTextComponent().setPopupMenu(this.multiTextComponentPopupMenu);
        this.multiTextComponentPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                PopupMenuBuilder.this.updateMultiDocumentComponentPopupMenuState();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void updateTextComponentPopupMenuState() {
        this.pmiUndo.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.UNDO));
        this.pmiRedo.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.REDO));
        this.pmiCut.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.CUT));
        this.pmiCopy.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.COPY));
        this.pmiPaste.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.PASTE));
        this.pmiSelectAll.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.SELECT_ALL));
    }

    private void updateMultiDocumentComponentPopupMenuState() {
        this.pmiClose.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.CLOSE));
        this.pmiCloseOthers.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.CLOSE_OTHERS));
        this.pmiCloseAll.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.CLOSE_ALL));
    }

    private void buildPopupMenuForTextComponent() {
        this.textComponentPopupMenu.add(this.pmiUndo);
        this.textComponentPopupMenu.add(this.pmiRedo);
        this.textComponentPopupMenu.addSeparator();
        this.textComponentPopupMenu.add(this.pmiCut);
        this.textComponentPopupMenu.add(this.pmiCopy);
        this.textComponentPopupMenu.add(this.pmiPaste);
        this.textComponentPopupMenu.addSeparator();
        this.textComponentPopupMenu.add(this.pmiSelectAll);
    }

    private void buildPopupMenuForMultiTextComponent() {
        this.multiTextComponentPopupMenu.add(this.pmNewEditor);
        this.pmNewEditor.add(this.pmiPlainText);
        this.pmNewEditor.add(this.pmiXML);
        this.pmNewEditor.add(this.pmiRTF);
        this.pmNewEditor.add(this.pmiHTML);
        this.multiTextComponentPopupMenu.addSeparator();
        this.multiTextComponentPopupMenu.add(this.pmiClose);
        this.multiTextComponentPopupMenu.add(this.pmiCloseOthers);
        this.multiTextComponentPopupMenu.add(this.pmiCloseAll);
    }

    private void buildMnemonics() {
        this.pmiUndo.setMnemonic(85);
        this.pmiRedo.setMnemonic(82);
        this.pmiCut.setMnemonic(67);
        this.pmiCopy.setMnemonic(79);
        this.pmiPaste.setMnemonic(80);
        this.pmiSelectAll.setMnemonic(83);
        this.pmNewEditor.setMnemonic(78);
        this.pmiPlainText.setMnemonic(80);
        this.pmiXML.setMnemonic(88);
        this.pmiRTF.setMnemonic(82);
        this.pmiHTML.setMnemonic(72);
        this.pmiClose.setMnemonic(67);
        this.pmiCloseOthers.setMnemonic(79);
        this.pmiCloseAll.setMnemonic(65);
    }

    private void buildAccelerators() {
        this.pmiUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.pmiRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.pmiCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.pmiCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.pmiPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.pmiSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
    }

    protected void buildPopupMenu() {
        this.buildPopupMenuForTextComponent();
        this.buildPopupMenuForMultiTextComponent();
        this.buildMnemonics();
        this.buildAccelerators();
    }
}

