/*
 * Decompiled with CFR 0.152.
 */
package gui;

import commands.CommandType;
import gui.PopupMenuBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import neutrino.multitext.EditorChangeEvent;
import neutrino.multitext.EditorChangeListener;
import neutrino.text.PlainTextArea;
import neutrino.text.PlainTextComponent;

abstract class ToolBarBuilder
extends PopupMenuBuilder {
    private JToolBar toolBar = new JToolBar();
    protected JButton bNew = new JButton(this.iconNew);
    protected JButton bOpen = new JButton(this.iconOpen);
    protected JButton bReload = new JButton(this.iconReload);
    protected JButton bSave = new JButton(this.iconSave);
    protected JButton bSaveAll = new JButton(this.iconSaveAll);
    protected JButton bRevert = new JButton(this.iconRevert);
    protected JButton bPrint = new JButton(this.iconPrint);
    protected JButton bUndo = new JButton(this.iconUndo);
    protected JButton bRedo = new JButton(this.iconRedo);
    protected JButton bCut = new JButton(this.iconCut);
    protected JButton bCopy = new JButton(this.iconCopy);
    protected JButton bPaste = new JButton(this.iconPaste);
    protected JButton bFind = new JButton(this.iconFind);
    protected JButton bReplace = new JButton(this.iconReplace);
    protected JButton bMakeUpperCase = new JButton(this.iconUpperCase);
    protected JButton bMakeLowerCase = new JButton(this.iconLowerCase);
    protected JButton bDeleteHorizontalWhiteSpace = new JButton(this.iconDeleteHorizontalWhiteSpace);
    protected JButton bIncreaseLineIndent = new JButton(this.iconShiftRight);
    protected JButton bDecreaseLineIndent = new JButton(this.iconShiftLeft);
    protected JButton bPerformComplexOperation = new JButton(this.iconComplexOperation);
    protected JButton bHelp = new JButton(this.iconHelp);
    protected JButton bExit = new JButton(this.iconExit);
    private JLabel lCaretPosition = new JLabel();
    private JToolBar styledToolBar = new JToolBar();
    protected JComboBox cbFontNames = null;
    protected JComboBox cbFontSizes = null;
    protected JToggleButton bBold = new JToggleButton(this.iconBold);
    protected JToggleButton bItalic = new JToggleButton(this.iconItalic);
    protected JToggleButton bUnderline = new JToggleButton(this.iconUnderline);
    protected JToggleButton bLeft = new JToggleButton(this.iconLeft);
    protected JToggleButton bCenter = new JToggleButton(this.iconCenter);
    protected JToggleButton bRight = new JToggleButton(this.iconRight);
    protected JButton bForeground = new JButton(this.iconForeground);
    protected JButton bBackground = new JButton(this.iconBackground);
    protected JButton bParagraph = new JButton(this.iconParagraph);
    protected JButton bStyle = new JButton(this.iconStyle);
    private JPanel pToolBar = new JPanel();
    private EditorChangeListener rebuildToolbarListener = new EditorChangeListener(){

        @Override
        public void editorClosed(EditorChangeEvent editorChangeEvent) {
            ToolBarBuilder.this.rebuildToolbar();
        }

        @Override
        public void editorChanged(EditorChangeEvent editorChangeEvent) {
            ToolBarBuilder.this.rebuildToolbar();
        }

        @Override
        public void editorAdded(EditorChangeEvent editorChangeEvent) {
            ToolBarBuilder.this.rebuildToolbar();
        }
    };
    private Timer toolBarUpdatingTimer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ToolBarBuilder.this.pToolBar.isVisible()) {
                try {
                    ToolBarBuilder.this.updateButtonsState();
                    ToolBarBuilder.this.updateStyledToolBarState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    });

    public ToolBarBuilder() {
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(0);
        this.styledToolBar.setFloatable(false);
        this.styledToolBar.setOrientation(0);
        this.pToolBar.add(this.toolBar);
        this.pToolBar.add(this.styledToolBar);
        this.pToolBar.setLayout(new LayoutManager(){

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return ToolBarBuilder.this.getToolBarSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return ToolBarBuilder.this.getToolBarSize();
            }

            @Override
            public void layoutContainer(Container container) {
                ToolBarBuilder.this.layoutToolBar();
            }

            @Override
            public void addLayoutComponent(String string, Component component) {
            }
        });
        this.getContentPane().add((Component)this.pToolBar, "North");
        this.getMultiTextComponent().addEditorChangeListener(this.rebuildToolbarListener);
    }

    private Dimension getToolBarSize() {
        int n = this.toolBar.isVisible() ? this.toolBar.getPreferredSize().height : 0;
        int n2 = this.styledToolBar.isVisible() ? this.styledToolBar.getPreferredSize().height : 0;
        int n3 = n + n2;
        return new Dimension(this.getWidth(), n3);
    }

    private void layoutToolBar() {
        int n;
        int n2 = this.toolBar.isVisible() ? this.getWidth() : 0;
        int n3 = n = this.toolBar.isVisible() ? this.toolBar.getPreferredSize().height : 0;
        if (this.toolBar.isVisible()) {
            this.toolBar.setBounds(0, 0, n2, n);
        }
        if (this.styledToolBar.isVisible()) {
            int n4 = this.getWidth();
            int n5 = this.styledToolBar.getPreferredSize().height;
            this.styledToolBar.setBounds(0, n, n4, n5);
        }
    }

    protected void buildToolBar() {
        this.rebuildToolbar();
        this.buildToolTips();
        this.buildStyledToolBar();
        this.buildToolTipsForStyledToolBar();
        this.layoutToolBar();
    }

    private void buildStyledToolBar() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontNames = new JComboBox<String>(graphicsEnvironment.getAvailableFontFamilyNames());
        this.cbFontNames.setMaximumSize(this.cbFontNames.getPreferredSize());
        this.cbFontNames.setEditable(false);
        String[] stringArray = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        this.cbFontSizes = new JComboBox<String>(stringArray);
        this.cbFontSizes.setPreferredSize(new Dimension(this.cbFontSizes.getPreferredSize().width + 5, this.cbFontSizes.getPreferredSize().height));
        this.cbFontSizes.setMaximumSize(this.cbFontSizes.getPreferredSize());
        this.cbFontSizes.setEditable(true);
        this.styledToolBar.add(this.cbFontNames);
        this.styledToolBar.addSeparator();
        this.styledToolBar.add(this.cbFontSizes);
        this.styledToolBar.addSeparator();
        this.styledToolBar.add(this.bBold);
        this.styledToolBar.add(this.bItalic);
        this.styledToolBar.add(this.bUnderline);
        this.styledToolBar.addSeparator();
        this.styledToolBar.add(this.bLeft);
        this.styledToolBar.add(this.bCenter);
        this.styledToolBar.add(this.bRight);
        this.styledToolBar.addSeparator();
        this.styledToolBar.add(this.bForeground);
        this.styledToolBar.add(this.bBackground);
        this.styledToolBar.addSeparator();
        this.styledToolBar.add(this.bParagraph);
        this.styledToolBar.add(this.bStyle);
    }

    private void buildToolTipsForStyledToolBar() {
        this.cbFontNames.setToolTipText("Font Family");
        this.cbFontSizes.setToolTipText("Font Size");
        this.bBold.setToolTipText("Bold");
        this.bItalic.setToolTipText("Italic");
        this.bUnderline.setToolTipText("Underline");
        this.bLeft.setToolTipText("Align Left");
        this.bCenter.setToolTipText("Align Center");
        this.bRight.setToolTipText("Align Right");
        this.bForeground.setToolTipText("Text Color");
        this.bBackground.setToolTipText("Background Color");
        this.bParagraph.setToolTipText("Paragraph Style");
        this.bStyle.setToolTipText("Character Style");
    }

    private void buildToolTips() {
        this.bNew.setToolTipText("New");
        this.bOpen.setToolTipText("Open");
        this.bReload.setToolTipText("Reload");
        this.bSave.setToolTipText("Save");
        this.bSaveAll.setToolTipText("Save All");
        this.bRevert.setToolTipText("Revert");
        this.bPrint.setToolTipText("Print");
        this.bUndo.setToolTipText("Undo");
        this.bRedo.setToolTipText("Redo");
        this.bCut.setToolTipText("Cut");
        this.bCopy.setToolTipText("Copy");
        this.bPaste.setToolTipText("Paste");
        this.bFind.setToolTipText("Find");
        this.bReplace.setToolTipText("Replace");
        this.bMakeUpperCase.setToolTipText("Make Uppercase");
        this.bMakeLowerCase.setToolTipText("Make Lowercase");
        this.bDeleteHorizontalWhiteSpace.setToolTipText("Delete Horizontal White Space");
        this.bIncreaseLineIndent.setToolTipText("Increase Line Indent");
        this.bDecreaseLineIndent.setToolTipText("Decrease Line Indent");
        this.bPerformComplexOperation.setToolTipText("Perform Complex Operation");
        this.bHelp.setToolTipText("Help");
        this.bExit.setToolTipText("Exit");
    }

    private void rebuildToolbar() {
        JTextComponent jTextComponent = this.getTextEditor().getTextComponent();
        this.toolBar.removeAll();
        this.toolBar.add(this.bNew);
        this.toolBar.add(this.bOpen);
        this.toolBar.add(this.bReload);
        this.toolBar.add(this.bSave);
        this.toolBar.add(this.bSaveAll);
        this.toolBar.add(this.bRevert);
        this.toolBar.add(this.bPrint);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bUndo);
        this.toolBar.add(this.bRedo);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bCut);
        this.toolBar.add(this.bCopy);
        this.toolBar.add(this.bPaste);
        this.toolBar.addSeparator();
        this.toolBar.add(this.bFind);
        this.toolBar.add(this.bReplace);
        if (jTextComponent instanceof PlainTextArea || jTextComponent instanceof PlainTextComponent) {
            this.toolBar.addSeparator();
            this.toolBar.add(this.bMakeUpperCase);
            this.toolBar.add(this.bMakeLowerCase);
            this.toolBar.add(this.bDeleteHorizontalWhiteSpace);
            this.toolBar.add(this.bIncreaseLineIndent);
            this.toolBar.add(this.bDecreaseLineIndent);
            this.toolBar.add(this.bPerformComplexOperation);
        }
        this.toolBar.addSeparator();
        this.toolBar.add(this.bHelp);
        this.toolBar.add(this.bExit);
        if (jTextComponent instanceof PlainTextArea || jTextComponent instanceof PlainTextComponent) {
            this.toolBar.addSeparator();
            this.toolBar.add(this.lCaretPosition);
        }
        this.toolBar.revalidate();
        this.toolBar.repaint();
        if (jTextComponent instanceof PlainTextArea || jTextComponent instanceof PlainTextComponent) {
            this.styledToolBar.setVisible(false);
        } else {
            this.styledToolBar.setVisible(true);
        }
    }

    private void updateButtonsState() {
        this.bNew.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.NEW));
        this.bSave.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.SAVE));
        this.bSaveAll.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.SAVE_ALL));
        this.bReload.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.RELOAD));
        this.bRevert.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.REVERT));
        this.bPrint.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.PRINT));
        this.bUndo.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.UNDO));
        this.bRedo.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.REDO));
        this.bCut.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.CUT));
        this.bCopy.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.COPY));
        this.bPaste.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.PASTE));
        this.bFind.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.FIND));
        this.bReplace.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.REPLACE));
        this.bMakeUpperCase.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.MAKE_UPPERCASE));
        this.bMakeLowerCase.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.MAKE_LOWERCASE));
        this.bDeleteHorizontalWhiteSpace.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.DELETE_HORIZONTAL_WHITE_SPACE));
        this.bIncreaseLineIndent.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.INCREASE_LINE_INDENT));
        this.bDecreaseLineIndent.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.DECREASE_LINE_INDENT));
        this.bPerformComplexOperation.setEnabled(this.getCommandGateway().canPeformCommand(CommandType.PERFORM_COMPLEX_OPERATION));
        if (this.getTextEditor().getTextComponent() instanceof PlainTextArea) {
            PlainTextArea plainTextArea = (PlainTextArea)this.getTextEditor().getTextComponent();
            String string = "Line " + plainTextArea.getNumberOfCurrentLine() + ", Col. " + plainTextArea.getNumberOfCurrentColumn();
            if (this.getTextEditor().isFileChanged()) {
                this.lCaretPosition.setText(string + ", *");
                this.lCaretPosition.setToolTipText("The file has been changed on the file system");
            } else {
                this.lCaretPosition.setText(string);
                this.lCaretPosition.setToolTipText("Caret position");
            }
        } else {
            this.lCaretPosition.setText("");
            this.lCaretPosition.setToolTipText("");
        }
    }

    private void updateStyledToolBarState() {
        int n;
        if (!(this.getTextEditor().getTextComponent() instanceof JTextPane)) {
            return;
        }
        JTextPane jTextPane = (JTextPane)this.getTextEditor().getTextComponent();
        AttributeSet attributeSet = jTextPane.getParagraphAttributes();
        int n2 = StyleConstants.getAlignment(attributeSet);
        switch (n2) {
            case 0: {
                this.bLeft.setSelected(true);
                this.bCenter.setSelected(false);
                this.bRight.setSelected(false);
                break;
            }
            case 1: {
                this.bLeft.setSelected(false);
                this.bCenter.setSelected(true);
                this.bRight.setSelected(false);
                break;
            }
            case 2: {
                this.bLeft.setSelected(false);
                this.bCenter.setSelected(false);
                this.bRight.setSelected(true);
                break;
            }
            default: {
                this.bLeft.setSelected(false);
                this.bCenter.setSelected(false);
                this.bRight.setSelected(false);
            }
        }
        AttributeSet attributeSet2 = jTextPane.getCharacterAttributes();
        this.bBold.setSelected(StyleConstants.isBold(attributeSet2));
        this.bItalic.setSelected(StyleConstants.isItalic(attributeSet2));
        this.bUnderline.setSelected(StyleConstants.isUnderline(attributeSet2));
        String string = StyleConstants.getFontFamily(attributeSet2);
        if (!this.cbFontNames.getSelectedItem().toString().equals(string)) {
            this.cbFontNames.setSelectedItem(string);
        }
        int n3 = StyleConstants.getFontSize(attributeSet2);
        try {
            n = Integer.parseInt(this.cbFontSizes.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n3 != n) {
            this.cbFontSizes.setSelectedItem(Integer.toString(n3));
        }
    }

    @Override
    protected void buildActions() {
        super.buildActions();
        this.toolBarUpdatingTimer.start();
    }

    @Override
    public void setToolBarVisible(boolean bl) {
        this.pToolBar.setVisible(bl);
    }

    @Override
    public boolean isToolBarVisible() {
        return this.pToolBar.isVisible();
    }
}

