/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Window
extends JFrame {
    protected final String PROGRAM_NAME = "MultiText Editor";
    protected final String TITLE_HEAD = "MultiText Editor - ";
    private final String ICON_FILE_NAME = "multiTextEditor.gif";
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 500;
    private String lookAndFeelClassName = null;

    public Window() {
        this.setIconImage(this.getToolkit().createImage("multiTextEditor.gif"));
        this.lookAndFeelClassName = UIManager.getCrossPlatformLookAndFeelClassName();
        this.setSize(this.getDefaultSize());
        this.centerWindowOnScreen();
    }

    public Dimension getDefaultSize() {
        return new Dimension(800, 500);
    }

    public void centerWindowOnScreen() {
        Dimension dimension = this.getSize();
        this.setBounds(this.getBoundsOnScreen(dimension));
    }

    public void randomizeWindowLocation() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        Random random = new Random();
        int n = random.nextInt(dimension2.width - dimension.width);
        int n2 = random.nextInt(dimension2.height - dimension.height);
        this.setLocation(n, n2);
    }

    public Rectangle getBoundsOnScreen(Dimension dimension) {
        Rectangle rectangle = new Rectangle();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        rectangle.x = (dimension2.width - dimension.width) / 2;
        rectangle.y = (dimension2.height - dimension.height) / 2;
        return rectangle;
    }

    public String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public void setLookAndFeel(String string) {
        if (string == null) {
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
            this.lookAndFeelClassName = string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
    }
}

