/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import gui.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class AdvancedDialog
extends JDialog {
    private JLabel lTabSize = new JLabel("Tab size :");
    private JTextField tfTabSize = new JTextField(2);
    private JLabel lMargin = new JLabel("Margin :");
    private JTextField tfMargin = new JTextField(2);
    private JCheckBox cbLineWrap = new JCheckBox("Line wrap");
    private JRadioButton rbCharacter = new JRadioButton("Character");
    private JRadioButton rbWord = new JRadioButton("Word");
    private ButtonGroup bgWrapStyle = new ButtonGroup();
    private JCheckBox cbSaveCaretPosition = new JCheckBox("Save caret position");
    private JCheckBox cbSaveWindowSize = new JCheckBox("Save window size");
    private JCheckBox cbConfirmExit = new JCheckBox("Confirm exit when closing window");
    private JCheckBox cbShowToolBar = new JCheckBox("Show tool bar");
    private JCheckBox cbConfirmReloading = new JCheckBox("Confirm reloading");
    private JCheckBox cbPersistCurrentFiles = new JCheckBox("Persist current files");
    private JCheckBox cbPersistBackups = new JCheckBox("Persist backups");
    private JCheckBox cbKeepHistory = new JCheckBox("Keep history");
    private JCheckBox cbAutoIndentMode = new JCheckBox("Auto indent mode");
    private JCheckBox cbAutoChangeDirMode = new JCheckBox("Change dir on open");
    private JButton bClearHistory = new JButton("Clear history");
    private JRadioButton rbCenterWindowOnScreen = new JRadioButton("Center window on screen");
    private JRadioButton rbSaveWindowLocation = new JRadioButton("Save window location");
    private JRadioButton rbRandomizeWindowLocation = new JRadioButton("Randomize window location");
    private ButtonGroup bgWindowLocation = new ButtonGroup();
    private JList lookAndFeelList = new JList();
    private JButton bOk = new JButton("Ok");
    private JButton bCancel = new JButton("Cancel");
    private JButton bDefaults = new JButton("Defaults");
    Hashtable<String, String> lookAndFeels = new Hashtable();
    private Application application = null;
    private ActionListener alOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AdvancedDialog.this.validateInput()) {
                AdvancedDialog.this.establishValues();
                AdvancedDialog.this.setVisible(false);
                AdvancedDialog.this.dispose();
            }
        }
    };
    private ActionListener alCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedDialog.this.setVisible(false);
            AdvancedDialog.this.dispose();
        }
    };
    private ActionListener alDefaults = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdvancedDialog.this.defaults();
        }
    };

    private Application getApplication() {
        return this.application;
    }

    private void initialize() {
        JTextComponent jTextComponent = this.getApplication().getTextEditor().getTextComponent();
        this.tfTabSize.setText(Integer.toString(this.getApplication().getMultiTextComponent().getTabSize()));
        this.tfMargin.setText(Integer.toString(jTextComponent.getMargin().left));
        this.cbAutoIndentMode.setSelected(this.getApplication().getMultiTextComponent().isAutoIndentMode());
        this.cbLineWrap.setSelected(this.getApplication().getMultiTextComponent().getLineWrap());
        if (this.getApplication().getMultiTextComponent().getWrapStyleWord()) {
            this.rbWord.setSelected(true);
        } else {
            this.rbCharacter.setSelected(true);
        }
        this.cbLineWrap.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = AdvancedDialog.this.cbLineWrap.isSelected();
                AdvancedDialog.this.rbCharacter.setEnabled(bl);
                AdvancedDialog.this.rbWord.setEnabled(bl);
            }
        });
        boolean bl = this.cbLineWrap.isSelected();
        this.rbCharacter.setEnabled(bl);
        this.rbWord.setEnabled(bl);
        this.cbConfirmExit.setSelected(this.getApplication().getSettings().isConfirmExit());
        this.cbShowToolBar.setSelected(this.getApplication().isToolBarVisible());
        this.cbSaveWindowSize.setSelected(this.getApplication().getSettings().isSaveWindowSize());
        if (this.getApplication().getSettings().getTypeOfWindowLocation() == 1) {
            this.rbSaveWindowLocation.setSelected(true);
        } else if (this.getApplication().getSettings().getTypeOfWindowLocation() == 2) {
            this.rbCenterWindowOnScreen.setSelected(true);
        } else if (this.getApplication().getSettings().getTypeOfWindowLocation() == 3) {
            this.rbRandomizeWindowLocation.setSelected(true);
        }
        this.cbConfirmReloading.setSelected(this.getApplication().getSettings().isConfirmReloading());
        this.cbPersistCurrentFiles.setSelected(this.getApplication().getSettings().isPersistCurrentFiles());
        this.cbAutoChangeDirMode.setSelected(this.getApplication().getSettings().isAutoChangeDirMode());
        this.cbSaveCaretPosition.setSelected(this.getApplication().getSettings().isSaveCaretPosition());
        this.cbSaveCaretPosition.setEnabled(this.cbPersistCurrentFiles.isSelected());
        this.cbPersistBackups.setSelected(this.getApplication().getTextEditor().getBackupManager().isEnabled());
        this.bClearHistory.setEnabled(!this.getApplication().getSettings().getHistory().isEmpty());
        this.bClearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedDialog.this.getApplication().getSettings().getHistory().clear();
                AdvancedDialog.this.bClearHistory.setEnabled(false);
            }
        });
        this.cbPersistCurrentFiles.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AdvancedDialog.this.cbSaveCaretPosition.setEnabled(AdvancedDialog.this.cbPersistCurrentFiles.isSelected());
            }
        });
        this.cbKeepHistory.setSelected(this.getApplication().getSettings().isKeepHistory());
        String string = null;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            this.lookAndFeels.put(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            if (!lookAndFeelInfo.getClassName().equals(this.getApplication().getLookAndFeelClassName())) continue;
            string = lookAndFeelInfo.getName();
        }
        this.lookAndFeelList.setListData(this.lookAndFeels.keySet().toArray());
        this.lookAndFeelList.setSelectedValue(string, true);
        this.lookAndFeelList.setSelectionMode(0);
    }

    private void defaults() {
        this.tfTabSize.setText(Integer.toString(4));
        this.tfMargin.setText(Integer.toString(10));
        this.cbLineWrap.setSelected(false);
        this.rbWord.setSelected(true);
        this.cbAutoIndentMode.setSelected(true);
        this.cbAutoChangeDirMode.setSelected(false);
        this.cbConfirmReloading.setSelected(true);
        this.cbPersistCurrentFiles.setSelected(true);
        this.cbPersistBackups.setSelected(true);
        this.cbKeepHistory.setSelected(false);
        this.cbConfirmExit.setSelected(true);
        this.cbShowToolBar.setSelected(true);
        this.cbSaveCaretPosition.setSelected(false);
        this.cbSaveWindowSize.setSelected(true);
        this.rbCenterWindowOnScreen.setSelected(true);
        this.lookAndFeelList.setSelectedValue("Metal", true);
    }

    private boolean validateInput() {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.tfTabSize.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Tab size is not a number", "Error message", 0);
            return false;
        }
        try {
            n = Integer.parseInt(this.tfMargin.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Margin is not a number", "Error message", 0);
            return false;
        }
        if (n2 < 1 || n2 > 99) {
            JOptionPane.showMessageDialog(this, "Tab size mast be in interval from 1 to 99", "Error message", 0);
            return false;
        }
        if (n < 0 || n > 99) {
            JOptionPane.showMessageDialog(this, "Margin mast be in inteval from 0 to 99", "Error message", 0);
            return false;
        }
        return true;
    }

    private void establishValues() {
        int n = Integer.parseInt(this.tfTabSize.getText());
        int n2 = Integer.parseInt(this.tfMargin.getText());
        String string = this.lookAndFeels.get(this.lookAndFeelList.getSelectedValue());
        this.getApplication().getMultiTextComponent().setTabSize(n);
        this.getApplication().getMultiTextComponent().setMargin(n2);
        this.getApplication().getMultiTextComponent().setLineWrap(this.cbLineWrap.isSelected());
        this.getApplication().getMultiTextComponent().setWrapStyleWord(this.rbWord.isSelected());
        this.getApplication().getMultiTextComponent().setAutoIndentMode(this.cbAutoIndentMode.isSelected());
        this.getApplication().getSettings().setConfirmingReloading(this.cbConfirmReloading.isSelected());
        this.getApplication().getSettings().setPersistingCurrentFiles(this.cbPersistCurrentFiles.isSelected());
        this.getApplication().getSettings().setConfirmingExit(this.cbConfirmExit.isSelected());
        this.getApplication().getSettings().setAutoChangeDirMode(this.cbAutoChangeDirMode.isSelected());
        this.getApplication().getSettings().setSavingCaretPosition(this.cbSaveCaretPosition.isSelected());
        this.getApplication().getMultiTextComponent().setPersistBackups(this.cbPersistBackups.isSelected());
        this.getApplication().getSettings().setKeepHistory(this.cbKeepHistory.isSelected());
        this.getApplication().getSettings().setSavingWindowSize(this.cbSaveWindowSize.isSelected());
        this.getApplication().setToolBarVisible(this.cbShowToolBar.isSelected());
        if (this.rbSaveWindowLocation.isSelected()) {
            this.getApplication().getSettings().setTypeOfWindowLocation(1);
        } else if (this.rbCenterWindowOnScreen.isSelected()) {
            this.getApplication().getSettings().setTypeOfWindowLocation(2);
        } else if (this.rbRandomizeWindowLocation.isSelected()) {
            this.getApplication().getSettings().setTypeOfWindowLocation(3);
        }
        if (!string.equals(this.getApplication().getLookAndFeelClassName())) {
            this.getApplication().setLookAndFeel(string);
        }
        this.getApplication().getTextEditor().getTextComponent().repaint();
    }

    private AdvancedDialog(Application application) {
        this.application = application;
        this.setTitle("Advanced options");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.getMainPanel());
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.bOk);
        this.pack();
        this.initialize();
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
    }

    private static void establishBounds(JDialog jDialog, Window window) {
        Dimension dimension = jDialog.getSize();
        Dimension dimension2 = window.getSize();
        Dimension dimension3 = jDialog.getToolkit().getScreenSize();
        int n = Math.max((dimension2.width - dimension.width) / 2, 0);
        int n2 = Math.max((dimension2.height - dimension.height) / 2, 0);
        int n3 = n + dimension.width + window.getX() > dimension3.width ? (dimension3.width - dimension.width) / 2 - n : window.getX();
        int n4 = n2 + dimension.height + window.getY() > dimension3.height ? (dimension3.height - dimension.height) / 2 - n2 : window.getY();
        jDialog.setBounds(n + n3, n2 + n4, dimension.width, dimension.height);
    }

    public static void showAdvancedDialog(Application application) {
        AdvancedDialog advancedDialog = new AdvancedDialog(application);
        AdvancedDialog.establishBounds(advancedDialog, application);
        advancedDialog.setVisible(true);
    }

    private JPanel getSecondPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getEditingPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getWrapPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getFirstPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.getWindowPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.getLookAndFeelPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.getFirstPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.getSecondPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.getCurrentFilesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)this.getButtonsPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getEditingPanel() {
        this.lTabSize.setLabelFor(this.tfTabSize);
        this.lTabSize.setDisplayedMnemonic(84);
        this.lMargin.setLabelFor(this.tfMargin);
        this.lMargin.setDisplayedMnemonic(77);
        this.cbAutoIndentMode.setMnemonic(65);
        JPanel jPanel = new JPanel();
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder("Editing"), new EmptyBorder(0, 5, 5, 5));
        jPanel.setBorder(compoundBorder);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.lTabSize, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfTabSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.lMargin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfMargin, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.cbAutoIndentMode, gridBagConstraints);
        return jPanel;
    }

    private JPanel getWrapPanel() {
        this.cbLineWrap.setMnemonic(76);
        this.rbCharacter.setMnemonic(72);
        this.rbWord.setMnemonic(87);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = new TitledBorder("Wrap style");
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(boxLayout);
        jPanel.add(this.rbCharacter);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this.rbWord);
        this.bgWrapStyle.add(this.rbCharacter);
        this.bgWrapStyle.add(this.rbWord);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder2 = new TitledBorder("Line wrap");
        BoxLayout boxLayout2 = new BoxLayout(jPanel2, 1);
        jPanel2.setBorder(titledBorder2);
        jPanel2.setLayout(boxLayout2);
        jPanel2.add(this.cbLineWrap);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private JPanel getCurrentFilesPanel() {
        this.cbConfirmReloading.setMnemonic(73);
        this.cbPersistCurrentFiles.setMnemonic(80);
        this.cbSaveCaretPosition.setMnemonic(82);
        this.cbPersistBackups.setMnemonic(75);
        this.cbKeepHistory.setMnemonic(89);
        this.cbAutoChangeDirMode.setMnemonic(71);
        JPanel jPanel = new JPanel();
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder("Current files"), new EmptyBorder(0, 0, 0, 5));
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.cbConfirmReloading, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.cbPersistCurrentFiles, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.cbSaveCaretPosition, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.cbPersistBackups, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.cbAutoChangeDirMode, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)this.cbKeepHistory, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel.add((Component)this.bClearHistory, gridBagConstraints);
        return jPanel;
    }

    private JPanel getWindowPanel() {
        this.cbConfirmExit.setMnemonic(78);
        this.cbShowToolBar.setMnemonic(66);
        this.cbSaveWindowSize.setMnemonic(86);
        this.rbCenterWindowOnScreen.setMnemonic(69);
        this.rbSaveWindowLocation.setMnemonic(83);
        this.rbRandomizeWindowLocation.setMnemonic(90);
        this.bgWindowLocation.add(this.rbSaveWindowLocation);
        this.bgWindowLocation.add(this.rbCenterWindowOnScreen);
        this.bgWindowLocation.add(this.rbRandomizeWindowLocation);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setBorder(new TitledBorder("Location"));
        jPanel.setLayout(boxLayout);
        jPanel.add(this.rbCenterWindowOnScreen);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.rbSaveWindowLocation);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(this.rbRandomizeWindowLocation);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = new TitledBorder("Window");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel2.add((Component)this.cbConfirmExit, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)this.cbShowToolBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)this.cbSaveWindowSize, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    private JPanel getLookAndFeelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new TitledBorder("Look and feel"), new EmptyBorder(5, 5, 5, 5));
        jPanel.setBorder(compoundBorder);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(190, 80));
        jScrollPane.getViewport().setView(this.lookAndFeelList);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private JPanel getButtonsPanel() {
        this.bOk.setMnemonic(79);
        this.bCancel.setMnemonic(67);
        this.bDefaults.setMnemonic(68);
        this.bOk.addActionListener(this.alOk);
        this.bCancel.addActionListener(this.alCancel);
        this.bDefaults.addActionListener(this.alDefaults);
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 1, 0, 5);
        jPanel.setLayout(gridLayout);
        jPanel.add(this.bOk);
        jPanel.add(this.bCancel);
        jPanel.add(this.bDefaults);
        return jPanel;
    }
}

