/*
 * Decompiled with CFR 0.152.
 */
package properties;

import gui.Application;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.UIManager;
import neutrino.multitext.MultiTextComponent;
import neutrino.multitext.TextInfo;
import neutrino.text.TextEditor;
import properties.Settings;

public class EditorProperties
implements Serializable {
    private Settings m_settings = new Settings();
    private ArrayList<TextInfo> m_currentFiles = null;
    private File m_currentFile = null;
    private File m_currentDirectory = null;
    private Font m_font = null;
    private Color m_foreground = Color.BLACK;
    private Color m_background = Color.WHITE;
    private String m_encoding = Charset.defaultCharset().name();
    private int m_tabSize = 4;
    private int m_margin = 10;
    private boolean m_lineWrap = false;
    private boolean m_wrapStyleWord = true;
    private boolean m_isLineStartAsPrevious = true;
    private Rectangle m_bounds = new Rectangle(0, 0, 800, 500);
    private String m_lookAndFeelClassName = UIManager.getCrossPlatformLookAndFeelClassName();
    private boolean m_isToolBarVisible = true;
    private boolean m_isPersistBackups = true;

    public void buildProperties(Application application) {
        TextEditor textEditor = application.getTextEditor();
        this.m_settings = application.getSettings();
        if (application.getSettings().isPersistCurrentFiles()) {
            this.m_currentFiles = application.getMultiTextComponent().getCurrentFiles();
            if (textEditor.isFileLoaded()) {
                this.m_currentFile = textEditor.getFile();
            }
        } else {
            this.m_currentFiles = null;
        }
        this.m_currentDirectory = application.getTextEditor().getCurrentDirectory();
        this.m_font = textEditor.getTextComponent().getFont();
        this.m_foreground = textEditor.getTextComponent().getForeground();
        this.m_background = textEditor.getTextComponent().getBackground();
        this.m_encoding = textEditor.getEncoding().name();
        this.m_tabSize = application.getMultiTextComponent().getTabSize();
        this.m_margin = textEditor.getTextComponent().getMargin().left;
        this.m_lineWrap = application.getMultiTextComponent().getLineWrap();
        this.m_wrapStyleWord = application.getMultiTextComponent().getWrapStyleWord();
        this.m_isLineStartAsPrevious = application.getMultiTextComponent().isAutoIndentMode();
        this.m_bounds = application.getBounds();
        this.m_lookAndFeelClassName = application.getLookAndFeelClassName();
        this.m_isToolBarVisible = application.isToolBarVisible();
        this.m_isPersistBackups = textEditor.getBackupManager().isEnabled();
    }

    public void establishProperties(String[] stringArray, Application application) {
        MultiTextComponent multiTextComponent = application.getMultiTextComponent();
        application.setSettings(this.m_settings);
        multiTextComponent.setPersistBackups(this.m_isPersistBackups);
        multiTextComponent.setEncoding(Charset.forName(this.m_encoding));
        if (this.m_currentFiles != null && application.getSettings().isPersistCurrentFiles()) {
            application.getMultiTextComponent().openFiles(this.m_currentFiles, application.getSettings().isSaveCaretPosition());
            if (this.m_currentFile != null) {
                application.getMultiTextComponent().activateTab(this.m_currentFile);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            application.getMultiTextComponent().openFiles(stringArray);
        }
        multiTextComponent.setCurrentDirectory(this.m_currentDirectory);
        multiTextComponent.setForeground(this.m_foreground);
        multiTextComponent.setBackground(this.m_background);
        if (this.m_font != null) {
            multiTextComponent.setFont(this.m_font);
        }
        multiTextComponent.setTabSize(this.m_tabSize);
        multiTextComponent.setMargin(this.m_margin);
        multiTextComponent.setLineWrap(this.m_lineWrap);
        multiTextComponent.setWrapStyleWord(this.m_wrapStyleWord);
        multiTextComponent.setAutoIndentMode(this.m_isLineStartAsPrevious);
        if (this.m_settings.isSaveWindowSize()) {
            application.setSize(this.m_bounds.width, this.m_bounds.height);
        } else {
            application.setSize(application.getDefaultSize());
        }
        if (this.m_settings.getTypeOfWindowLocation() == 1) {
            application.setLocation(this.m_bounds.x, this.m_bounds.y);
        } else if (this.m_settings.getTypeOfWindowLocation() == 2) {
            application.centerWindowOnScreen();
        } else if (this.m_settings.getTypeOfWindowLocation() == 3) {
            application.randomizeWindowLocation();
        }
        application.setLookAndFeel(this.m_lookAndFeelClassName);
        application.setToolBarVisible(this.m_isToolBarVisible);
    }
}

