/*
 * Decompiled with CFR 0.152.
 */
package properties;

import gui.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import properties.EditorProperties;

public class PropertiesManager {
    private static final String PROPERTIES_FILE_NAME = "properties.dat";
    private Application application = null;

    public PropertiesManager(Application application) {
        this.application = application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(String[] stringArray) {
        File file = new File(PROPERTIES_FILE_NAME);
        ObjectInputStream objectInputStream = null;
        EditorProperties editorProperties = null;
        boolean bl = false;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            editorProperties = (EditorProperties)objectInputStream.readObject();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (!bl) {
            editorProperties = new EditorProperties();
        }
        editorProperties.establishProperties(stringArray, this.application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties() {
        File file = new File(PROPERTIES_FILE_NAME);
        EditorProperties editorProperties = new EditorProperties();
        editorProperties.buildProperties(this.application);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(editorProperties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

