package neutrino.dialogs;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import static javax.swing.JOptionPane.*;
import neutrino.multitext.MultiTextComponent;
import neutrino.text.PlainTextArea;
import neutrino.text.TextEditor;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class TextSaver {
	
	private class SavingConfirmationDialog extends JDialog implements ActionListener {
		
		protected JList lTexts = new JList();
		private JButton bSave = new JButton("Save");
		private JButton bSaveAll = new JButton("Save All");
		private JButton bNo = new JButton("No");
		private JButton bCancel = new JButton("Cancel");
		private ArrayList<TextEditor> texts = null;
		private ArrayList<TextEditor> selectedTexts = null;
		protected int option = JOptionPane.CANCEL_OPTION;
		protected ListModel listModel = new ListModel() {

			public void addListDataListener(ListDataListener l) { }

			public Object getElementAt(int index) {
				return MultiTextComponent.createTitleForTextComponent(texts.get(index));
			}

			public int getSize() {
				return texts.size();
			}

			public void removeListDataListener(ListDataListener l) { }
			
		};

		public SavingConfirmationDialog(ArrayList<TextEditor> texts) {
			super();
			this.texts = texts;
			setTitle("Saving confirmation");
			setModal(true);
			setResizable(false);
			getRootPane().setDefaultButton(bSave);
			setDefaultCloseOperation(DISPOSE_ON_CLOSE);
			
			lTexts.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
			lTexts.setModel(listModel);
			Dimension size = new Dimension(400, 300);
			lTexts.setMinimumSize(size);
			lTexts.setPreferredSize(size);
			lTexts.setMaximumSize(size);
			lTexts.setSelectedIndex(0);
			
			JPanel pBackups = new JPanel();
			pBackups.setBorder(new CompoundBorder(new TitledBorder("Document"), new EmptyBorder(0, 5, 5, 5)));
			pBackups.setLayout(new BorderLayout());
			pBackups.add(new JScrollPane(lTexts), BorderLayout.CENTER);
			
			bSave.setMnemonic(KeyEvent.VK_S);
			bSaveAll.setMnemonic(KeyEvent.VK_A);
			bNo.setMnemonic(KeyEvent.VK_N);
			bCancel.setMnemonic(KeyEvent.VK_C);
			
			bSave.addActionListener(this);
			bSaveAll.addActionListener(this);
			bNo.addActionListener(this);
			bCancel.addActionListener(this);
			
			GridBagLayout layout = new GridBagLayout();
			getContentPane().setLayout(layout);
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.gridheight = 5;
			c.insets = new Insets(5, 5, 5, 0);
			getContentPane().add(pBackups, c);
			c.gridx = 1;
			c.gridy = 0;
			c.gridheight = 1;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.insets = new Insets(10, 5, 0, 5);
			getContentPane().add(bSave, c);
			c.gridy = 1;
			c.insets = new Insets(5, 5, 0, 5);
			getContentPane().add(bSaveAll, c);
			c.gridy = 2;
			c.insets = new Insets(5, 5, 0, 5);
			getContentPane().add(bNo, c);
			c.gridy = 3;
			getContentPane().add(bCancel, c);	
			pack();
		}
		
		public int getOption() {
			return this.option;
		}
		
		public ArrayList<TextEditor> getTexts() {
			return selectedTexts;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			if (e.getSource() == bSave) {
				int[] indices = lTexts.getSelectedIndices();
				if (indices == null || indices.length == 0) return;
				selectedTexts = new ArrayList<TextEditor>();
				for (int i = 0; i < indices.length; i++) {
					selectedTexts.add(texts.get(indices[i]));
				}
				this.option = JOptionPane.YES_OPTION;
				setVisible(false);
			} else if (e.getSource() == bSaveAll) {
				selectedTexts = texts;
				this.option = JOptionPane.YES_OPTION;
				setVisible(false);
			} else if (e.getSource() == bNo) {
				this.option = JOptionPane.NO_OPTION;
				setVisible(false);
			} if (e.getSource() == bCancel) {
				this.option = JOptionPane.CANCEL_OPTION;
				setVisible(false);
			}
		}
		
	}
	
	private static void establishBounds(JDialog dialog) {
        Dimension d1 = dialog.getSize();
        Dimension d2 = dialog.getToolkit().getScreenSize();
        int x = Math.max((d2.width-d1.width)/2, 0);
        int y = Math.max((d2.height-d1.height)/2, 0);
        dialog.setBounds(x + 0, y + 0, d1.width, d1.height);
	}
	
	public static boolean showSavingConfirmationDialog(JComponent owner, ArrayList<TextEditor> list) {
		SavingConfirmationDialog dialog = new TextSaver().new SavingConfirmationDialog(list);
		establishBounds(dialog);
		dialog.setVisible(true);
		int option = dialog.getOption();
		ArrayList<TextEditor> texts = dialog.getTexts();
		dialog.dispose();
		switch (option) {
		case YES_OPTION:
			Iterator<TextEditor> iterator = texts.iterator();
			while (iterator.hasNext()) {
				if (!iterator.next().save()) return false;
			}
			break;
		case NO_OPTION:
			break;
		case CANCEL_OPTION:
			return false;
		}
		return true;
	}

}
