package neutrino.multitext;

import neutrino.text.TextEditor;

/**
 * Stores information about event in MultiTextComponent
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class EditorChangeEvent {

	private MultiTextComponent source = null;
	private TextEditor textEditor = null;
	
	public EditorChangeEvent(MultiTextComponent source, TextEditor textEditor) {
		this.source = source;
		this.textEditor = textEditor;
	}

	/**
	 * Returns source of event
	 * @return a multitext component
	 */
	public MultiTextComponent getSource() {
		return source;
	}

	/**
	 * Returns current text component of event
	 * @return a text component
	 */
	public TextEditor getTextEditor() {
		return textEditor;
	}

}
