package neutrino.multitext;

/**
 * Interface for observe changes of tabs in MultiTextComponent
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public interface EditorChangeListener {
	
	/**
	 * Fires when new tab with text component is added in MultiTextComponent
	 * @param an event
	 */
	public void editorAdded(EditorChangeEvent e);
	
	/**
	 * Fires when current tab in MultiTextComponent is closed
	 * @param an event
	 */
	public void editorClosed(EditorChangeEvent e);
	
	/**
	 * Fires when other tab in MultiTextComponent is selected
	 * @param an event
	 */
	public void editorChanged(EditorChangeEvent e);

}
