package neutrino.multitext;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

import neutrino.text.HTMLComponent;
import neutrino.text.TextEditor;

/**
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public class HTMLEditorAdapter extends TextEditorAdapter {

	private HTMLComponent textComponent = null;
	private TextEditor textEditor = null;
	private JScrollPane component = null;
	
	public HTMLEditorAdapter() {
		super();
		textComponent = new HTMLComponent();
		textComponent.setUndoable(true);
		MutableAttributeSet attributeSet = new SimpleAttributeSet();
		StyleConstants.setForeground(attributeSet, Color.BLACK);
		StyleConstants.setBackground(attributeSet, Color.WHITE);
		textComponent.setCharacterAttributes(attributeSet, false);
		textEditor = new TextEditor(textComponent);
		textEditor.setAcceptAllFileFilterUsed(false);
		textEditor.setFileFilter(new FileNameExtensionFilter("WEB Page (HTML)", "htm", "html"));
		component = new JScrollPane();
		component.setViewportView(textComponent);
		setLayout(new BorderLayout());
		add(component, BorderLayout.CENTER);	
	}

	@Override
	public TextEditor getTextEditor() {
		return textEditor;
	}

}
