/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CRect;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.MultiListButton;
import controlP5.MultiListInterface;
import controlP5.Tab;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiList
extends Controller<MultiList>
implements MultiListInterface,
ControlListener {
    private List<MultiListButton> _myChildren;
    protected Tab _myTab;
    protected boolean isVisible = true;
    private int cnt;
    protected boolean isOccupied;
    protected boolean isUpdateLocation = false;
    protected MultiListInterface mostRecent;
    protected CRect _myRect;
    protected int _myDirection = 39;
    public int closeDelay = 30;
    protected int _myDefaultButtonHeight = 10;
    protected boolean isUpperCase = true;

    public MultiList(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0, 0, 99, 19);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public MultiList(ControlP5 theControlP5, Tab theParent, String theName, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, 0);
        this._myDefaultButtonHeight = theHeight;
        this.setup();
    }

    @Override
    public MultiList toUpperCase(boolean theValue) {
        this.isUpperCase = theValue;
        for (MultiListButton c : this._myChildren) {
            c.toUpperCase(this.isUpperCase);
        }
        return this;
    }

    @ControlP5.Invisible
    public void setup() {
        this._myChildren = new ArrayList<MultiListButton>();
        this.mostRecent = this;
        this.isVisible = true;
        this.updateRect(this.position.x, this.position.y, this.width, this._myDefaultButtonHeight);
    }

    public List<MultiListButton> getChildren() {
        return this._myChildren;
    }

    protected void updateRect(float theX, float theY, float theW, float theH) {
        this._myRect = new CRect(theX, theY, theW, theH);
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    void setDirection(int theDirection) {
        this._myDirection = theDirection == 37 ? 37 : 39;
        for (int i = 0; i < this._myChildren.size(); ++i) {
            this._myChildren.get(i).setDirection(this._myDirection);
        }
    }

    @Override
    @ControlP5.Invisible
    public void updateLocation(float theX, float theY) {
        this.position.x += theX;
        this.position.y += theY;
        this.updateRect(this.position.x, this.position.y, this.width, this._myDefaultButtonHeight);
        for (int i = 0; i < this._myChildren.size(); ++i) {
            ((MultiListInterface)this._myChildren.get(i)).updateLocation(theX, theY);
        }
    }

    @Override
    public void remove() {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.cp5 != null) {
            this.cp5.remove(this);
        }
        for (int i = 0; i < this._myChildren.size(); ++i) {
            this._myChildren.get(i).removeListener(this);
            this._myChildren.get(i).remove();
        }
    }

    public MultiListButton add(String theName, int theValue) {
        int x = (int)this.position.x;
        int yy = 0;
        for (MultiListButton c : this._myChildren) {
            yy += c.getHeight() + 1;
        }
        int y = (int)this.position.y + yy;
        MultiListButton b = new MultiListButton(this.cp5, theName, theValue, x, y, this.width, this._myDefaultButtonHeight, this, this);
        b.toUpperCase(this.isUpperCase);
        b.isMoveable = false;
        this.cp5.register(null, "", b);
        b.addListener(this);
        this._myChildren.add(b);
        b.show();
        this.updateRect(this.position.x, this.position.y, this.width, (this._myDefaultButtonHeight + 1) * this._myChildren.size());
        return b;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.getController() instanceof MultiListButton) {
            this._myValue = theEvent.getController().getValue();
            ControlEvent myEvent = new ControlEvent(this);
            this.cp5.getControlBroadcaster().broadcast(myEvent, 2);
        }
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet theApplet) {
        this.update(theApplet);
    }

    @ControlP5.Invisible
    public boolean update(PApplet theApplet) {
        if (!this.isOccupied) {
            ++this.cnt;
            if (this.cnt == this.closeDelay) {
                this.close();
            }
        }
        if (this.isUpdateLocation) {
            this.updateLocation(this._myControlWindow.mouseX - this._myControlWindow.pmouseX, this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.isUpdateLocation = theApplet.mousePressed;
        }
        if (this.isOccupied && theApplet.keyPressed && theApplet.mousePressed && theApplet.keyCode == 18) {
            this.isUpdateLocation = true;
            return true;
        }
        return false;
    }

    @ControlP5.Invisible
    public void occupied(boolean theFlag) {
        this.isOccupied = theFlag;
        this.cnt = 0;
    }

    @Override
    @ControlP5.Invisible
    public boolean observe() {
        return CRect.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    @Override
    public void close(MultiListInterface theInterface) {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            if (theInterface == (MultiListInterface)this._myChildren.get(i)) continue;
            ((MultiListInterface)this._myChildren.get(i)).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            ((MultiListInterface)this._myChildren.get(i)).close();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this._myChildren.size(); ++i) {
            ((MultiListInterface)this._myChildren.get(i)).open();
        }
    }

    @Override
    public MultiList setValue(float theValue) {
        return this;
    }

    @Override
    public MultiList update() {
        return this.setValue(this._myValue);
    }

    @Deprecated
    public List<MultiListButton> subelements() {
        return this._myChildren;
    }
}

