/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.Tab;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accordion
extends ControlGroup<Accordion> {
    protected final List<ControlGroup<?>> items = new ArrayList();
    protected int spacing = 1;
    protected int minHeight = 100;
    protected int itemheight;
    protected int _myMode = 0;

    public Accordion(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0, 0, 200);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    Accordion(ControlP5 theControlP5, Tab theTab, String theName, int theX, int theY, int theW) {
        super(theControlP5, theTab, theName, theX, theY, theW, 9);
        this.hideBar();
    }

    public Accordion addItem(ControlGroup<?> theGroup) {
        theGroup.close();
        theGroup.moveTo(this);
        theGroup.activateEvent(true);
        theGroup.addListener(this);
        theGroup.setMoveable(false);
        if (theGroup.getBackgroundHeight() < this.minHeight) {
            theGroup.setBackgroundHeight(this.minHeight);
        }
        this.items.add(theGroup);
        this.updateItems();
        return this;
    }

    @Override
    public Accordion remove(ControllerInterface<?> theGroup) {
        if (theGroup instanceof ControlGroup) {
            this.items.remove(theGroup);
            ((ControlGroup)theGroup).removeListener(this);
            this.updateItems();
        }
        super.remove(theGroup);
        return this;
    }

    public Accordion removeItem(ControlGroup<?> theGroup) {
        if (theGroup == null) {
            return this;
        }
        this.items.remove(theGroup);
        theGroup.removeListener(this);
        theGroup.moveTo(this.cp5.controlWindow);
        this.updateItems();
        return this;
    }

    public Accordion updateItems() {
        int n = 0;
        this.setWidth(this._myWidth);
        for (ControlGroup<?> cg : this.items) {
            cg.setPosition(0.0f, n += cg.getBarHeight() + this.spacing);
            if (!cg.isOpen()) continue;
            n += cg.getBackgroundHeight();
        }
        return this;
    }

    public Accordion setMinItemHeight(int theHeight) {
        this.minHeight = theHeight;
        for (ControlGroup<?> cg : this.items) {
            if (cg.getBackgroundHeight() >= this.minHeight) continue;
            cg.setBackgroundHeight(this.minHeight);
        }
        this.updateItems();
        return this;
    }

    public int getMinItemHeight() {
        return this.minHeight;
    }

    public Accordion setItemHeight(int theHeight) {
        this.itemheight = theHeight;
        for (ControlGroup<?> cg : this.items) {
            cg.setBackgroundHeight(this.itemheight);
        }
        this.updateItems();
        return this;
    }

    public int getItemHeight() {
        return this.itemheight;
    }

    @Override
    public Accordion setWidth(int theWidth) {
        super.setWidth(theWidth);
        for (ControlGroup<?> cg : this.items) {
            cg.setWidth(theWidth);
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isGroup()) {
            int n = 0;
            for (ControlGroup<?> cg : this.items) {
                cg.setPosition(0.0f, n += cg.getBarHeight() + this.spacing);
                if (this._myMode == 0) {
                    if (cg == theEvent.getGroup() && cg.isOpen()) {
                        n += cg.getBackgroundHeight();
                        continue;
                    }
                    cg.close();
                    continue;
                }
                if (!cg.isOpen()) continue;
                n += cg.getBackgroundHeight();
            }
        }
    }

    @Override
    public Accordion open() {
        int[] n = new int[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            n[i] = i;
        }
        return this.open(n);
    }

    @Override
    public Accordion close() {
        int[] n = new int[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            n[i] = i;
        }
        return this.close(n);
    }

    public Accordion open(int ... theId) {
        if (theId[0] == -1) {
            return this.open();
        }
        int n = 0;
        int i = 0;
        for (ControlGroup<?> cg : this.items) {
            boolean a = false;
            for (int j = 0; j < theId.length; ++j) {
                if (theId[j] != i) continue;
                a = true;
            }
            boolean b = cg.isOpen() || a;
            ++i;
            cg.setPosition(0.0f, n += cg.getBarHeight() + this.spacing);
            if (!b) continue;
            n += cg.getBackgroundHeight();
            cg.open();
        }
        return this;
    }

    public Accordion close(int ... theId) {
        if (theId[0] == -1) {
            return this.close();
        }
        int n = 0;
        int i = 0;
        for (ControlGroup<?> cg : this.items) {
            boolean a = false;
            for (int j = 0; j < theId.length; ++j) {
                if (theId[j] != i) continue;
                a = true;
            }
            boolean b = !cg.isOpen() || a;
            ++i;
            cg.setPosition(0.0f, n += cg.getBarHeight() + this.spacing);
            if (b) {
                cg.close();
                continue;
            }
            n += cg.getBackgroundHeight();
        }
        return this;
    }

    public Accordion setCollapseMode(int theMode) {
        this._myMode = theMode == 0 ? 0 : 1;
        return this;
    }
}

