/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Label;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlGroup<T>
extends ControllerGroup<T>
implements ControlListener {
    protected Button _myCloseButton;
    protected int _myBackgroundHeight = 0;
    protected int _myBackgroundColor = 0xFFFFFF;
    protected boolean isEventActive = false;
    protected boolean isBarVisible = true;
    protected List<ControlListener> _myControlListener = new ArrayList<ControlListener>();
    protected boolean isArrowVisible = true;

    public ControlGroup(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0, 0, 100, 9);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public ControlGroup(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, int theX, int theY, int theW, int theH) {
        super(theControlP5, theParent, theName, theX, theY);
        this._myValueLabel = new Label(this.cp5, "");
        this._myWidth = theW;
        this._myHeight = theH;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        if (this.isBarVisible && this.isCollapse && !this.cp5.keyHandler.isAltDown()) {
            boolean bl = this.isOpen = !this.isOpen;
            if (this.isEventActive) {
                ControlEvent myEvent = new ControlEvent(this);
                this.cp5.getControlBroadcaster().broadcast(myEvent, 0);
                for (ControlListener cl : this._myControlListener) {
                    cl.controlEvent(myEvent);
                }
            }
        }
    }

    public T activateEvent(boolean theFlag) {
        this.isEventActive = theFlag;
        return (T)this.me;
    }

    public int getBackgroundHeight() {
        return this._myBackgroundHeight;
    }

    public T setBackgroundHeight(int theHeight) {
        this._myBackgroundHeight = theHeight;
        return (T)this.me;
    }

    public T setBackgroundColor(int theColor) {
        this._myBackgroundColor = theColor;
        return (T)this.me;
    }

    public T setBarHeight(int theHeight) {
        this._myHeight = theHeight;
        return (T)this.me;
    }

    public int getBarHeight() {
        return this._myHeight;
    }

    @Override
    public T updateInternalEvents(PApplet theApplet) {
        if (this.isInside && this.isBarVisible) {
            this._myControlWindow.setMouseOverController(this);
        }
        return (T)this.me;
    }

    @Override
    protected void preDraw(PApplet theApplet) {
        if (this.isOpen) {
            theApplet.fill(this._myBackgroundColor);
            theApplet.rect(0.0f, 0.0f, (float)this._myWidth, (float)(this._myBackgroundHeight - 1));
        }
    }

    @Override
    protected void postDraw(PApplet theApplet) {
        if (this.isBarVisible) {
            theApplet.fill(this.isInside ? this.color.getForeground() : this.color.getBackground());
            theApplet.rect(0.0f, -1.0f, (float)this._myWidth, (float)(-this._myHeight));
            this._myLabel.draw(theApplet, 0, -this._myHeight, this);
            if (this.isCollapse && this.isArrowVisible) {
                theApplet.fill(this._myLabel.getColor());
                if (this.isOpen) {
                    theApplet.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 4), (float)(-this._myHeight / 2 - 3), (float)(this._myWidth - 7), (float)(-this._myHeight / 2));
                } else {
                    theApplet.triangle((float)(this._myWidth - 10), (float)(-this._myHeight / 2), (float)(this._myWidth - 4), (float)(-this._myHeight / 2), (float)(this._myWidth - 7), (float)(-this._myHeight / 2 - 3));
                }
            }
        }
    }

    @ControlP5.Invisible
    public T addCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton = new Button(this.cp5, this, this.getName() + "close", 1.0f, this._myWidth + 1, -10, 12, 9);
            this._myCloseButton.setCaptionLabel("X");
            this._myCloseButton.addListener(this);
        }
        return (T)this.me;
    }

    @ControlP5.Invisible
    public T removeCloseButton() {
        if (this._myCloseButton == null) {
            this._myCloseButton.remove();
        }
        this._myCloseButton = null;
        return (T)this.me;
    }

    public T hideBar() {
        this.isBarVisible = false;
        return (T)this.me;
    }

    public T showBar() {
        this.isBarVisible = true;
        return (T)this.me;
    }

    public boolean isBarVisible() {
        return this.isBarVisible;
    }

    public T hideArrow() {
        this.isArrowVisible = false;
        return (T)this.me;
    }

    public T showArrow() {
        this.isArrowVisible = true;
        return (T)this.me;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.getController().getName().equals(this.getName() + "close")) {
            this.hide();
        }
    }

    @Override
    @ControlP5.Invisible
    public String stringValue() {
        return Float.toString(this._myValue);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String getInfo() {
        return "type:\tControlGroup\n" + super.getInfo();
    }

    public T addListener(ControlListener theListener) {
        this._myControlListener.add(theListener);
        return (T)this.me;
    }

    public T removeListener(ControlListener theListener) {
        this._myControlListener.remove(theListener);
        return (T)this.me;
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }
}

