/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.TickMark;
import java.util.ArrayList;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slider
extends Controller<Slider> {
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    protected int _mySliderMode = 1;
    protected float _myValuePosition;
    protected int _myHandleSize = 0;
    protected int _myDefaultHandleSize = 10;
    protected int triggerId = 2;
    protected ArrayList<TickMark> _myTickMarks = new ArrayList();
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected static int autoWidth = 99;
    protected static int autoHeight = 9;
    protected float scrollSensitivity = 0.1f;
    protected int _myColorTickMark = -1;
    private SliderView _myView;
    protected float _myMinReal = 0.0f;
    protected float _myMaxReal = 1.0f;
    protected float _myInternalValue = 0.0f;

    public Slider(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 100.0f, 0.0f, 0, 0, autoWidth, autoHeight);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public Slider(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, float theMin, float theMax, float theDefaultValue, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myMin = 0.0f;
        this._myMax = 1.0f;
        this._myMinReal = theMin;
        this._myMaxReal = theMax;
        this._myValue = PApplet.map((float)theDefaultValue, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this._myCaptionLabel = new Label(this.cp5, theName).setColor(this.color.getCaptionLabel());
        this._myValueLabel = new Label(this.cp5, "" + this.getValue()).setColor(this.color.getValueLabel());
        this.setSliderMode(1);
    }

    @Override
    @ControlP5.Invisible
    public void init() {
        this._myDefaultValue = this.getValue();
        this.cp5.getControlBroadcaster().plug((Object)this.cp5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.cp5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    public Slider setSliderMode(int theMode) {
        this._myView = this.width > this.height ? new SliderViewH() : new SliderViewV();
        this._myControllerView = this.width > this.height ? new SliderViewH() : new SliderViewV();
        this._mySliderMode = theMode;
        this._myHandleSize = this._mySliderMode == 0 ? (this._myDefaultHandleSize >= this.getHeight() / 2 ? this._myDefaultHandleSize / 2 : this._myDefaultHandleSize) : 0;
        this._myView.updateUnit();
        this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public int getSliderMode() {
        return this._mySliderMode;
    }

    public Slider setHandleSize(int theSize) {
        this._myDefaultHandleSize = theSize;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    public int getHandleSize() {
        return this._myHandleSize;
    }

    @Override
    @ControlP5.Invisible
    public Slider updateInternalEvents(PApplet theApplet) {
        if (this.isVisible && this.isMousePressed && !this.cp5.keyHandler.isAltDown()) {
            this._myView.updateInternalEvents(theApplet);
        }
        return this;
    }

    public Slider setTriggerEvent(int theEventID) {
        this.triggerId = theEventID;
        return this;
    }

    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    protected void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    protected void mouseReleased() {
        if (this.triggerId == 1) {
            this._myView.update();
            this.broadcast(2);
        }
    }

    protected Slider snapValue(float theValue) {
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
            this._myView.setSnapValue();
        }
        return this;
    }

    public float getValuePosition() {
        return this._myValuePosition;
    }

    @Override
    public Slider setValue(float theValue) {
        if (this.isMousePressed && theValue == this.getValue()) {
            return this;
        }
        this._myInternalValue = theValue;
        this._myValue = PApplet.map((float)theValue, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.snapValue(this._myValue);
        this._myValue = this._myValue <= this._myMin ? this._myMin : this._myValue;
        this._myValue = this._myValue >= this._myMax ? this._myMax : this._myValue;
        this._myValuePosition = (this._myValue - this._myMin) / this._myUnit;
        this._myValueLabel.set(this.adjustValue(this.getValue()));
        if (this.triggerId == 2) {
            this.broadcast(2);
        }
        return this;
    }

    @Override
    public float getValue() {
        return PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal);
    }

    public Slider shuffle() {
        float r = (float)Math.random();
        this.setValue(PApplet.map((float)r, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public Slider setScrollSensitivity(float theValue) {
        this.scrollSensitivity = theValue;
        return this;
    }

    @ControlP5.Invisible
    public Slider scrolled(int theRotationValue) {
        if (this.isVisible) {
            float f = this._myValue;
            float steps = this.isSnapToTickMarks ? 1.0f / (float)this.getNumberOfTickMarks() : this.scrollSensitivity * 0.1f;
            this.setValue(PApplet.map((float)(f += (this._myMax - this._myMin) * ((float)(-theRotationValue) * steps)), (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
            if (this.triggerId == 1) {
                this.broadcast(2);
            }
        }
        return this;
    }

    @Override
    public Slider update() {
        return this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
    }

    @Override
    public Slider setMin(float theValue) {
        float f = this.getValue();
        this._myMinReal = theValue;
        this._myValue = PApplet.map((float)f, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setMax(float theValue) {
        float f = this.getValue();
        this._myMaxReal = theValue;
        this._myValue = PApplet.map((float)f, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public float getMin() {
        return this._myMinReal;
    }

    @Override
    public float getMax() {
        return this._myMaxReal;
    }

    public Slider setRange(float theMin, float theMax) {
        float f = this._myInternalValue;
        this._myMinReal = theMin;
        this._myMaxReal = theMax;
        this._myValue = PApplet.map((float)f, (float)this._myMinReal, (float)this._myMaxReal, (float)0.0f, (float)1.0f);
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setWidth(int theValue) {
        this.width = theValue;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setHeight(int theValue) {
        this.height = theValue;
        this.setSliderMode(this._mySliderMode);
        return this;
    }

    @Override
    public Slider setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        this.setHeight(theHeight);
        this._myView = this.width > this.height ? new SliderViewH() : new SliderViewV();
        return this;
    }

    protected Slider setTickMarks() {
        return this;
    }

    public Slider setNumberOfTickMarks(int theNumber) {
        this._myTickMarks.clear();
        if (theNumber > 0) {
            for (int i = 0; i < theNumber; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
            this.showTickMarks(true);
            this.snapToTickMarks(true);
            this.setHandleSize(20);
        } else {
            this.showTickMarks(false);
            this.snapToTickMarks(false);
            this.setHandleSize(this._myDefaultHandleSize);
        }
        this.setValue(PApplet.map((float)this._myValue, (float)0.0f, (float)1.0f, (float)this._myMinReal, (float)this._myMaxReal));
        return this;
    }

    public int getNumberOfTickMarks() {
        return this._myTickMarks.size();
    }

    public Slider showTickMarks(boolean theFlag) {
        this.isShowTickMarks = theFlag;
        return this;
    }

    public Slider snapToTickMarks(boolean theFlag) {
        this.isSnapToTickMarks = theFlag;
        return this;
    }

    public TickMark getTickMark(int theIndex) {
        if (theIndex >= 0 && theIndex < this._myTickMarks.size()) {
            return this._myTickMarks.get(theIndex);
        }
        return null;
    }

    public ArrayList<TickMark> getTickMarks() {
        return this._myTickMarks;
    }

    @Override
    @ControlP5.Invisible
    public Slider linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, autoSpacing);
        return this;
    }

    public Slider setColorTickMark(int theColor) {
        this._myColorTickMark = theColor;
        return this;
    }

    public int getDirection() {
        return this._myView instanceof SliderViewH ? 0 : 1;
    }

    @Override
    @ControlP5.Invisible
    public Slider updateDisplayMode(int theMode) {
        this._myDisplayMode = theMode;
        switch (theMode) {
            case 0: {
                this._myControllerView = this.width > this.height ? new SliderViewH() : new SliderViewV();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return this;
    }

    @Deprecated
    public void setSliderBarSize(int theSize) {
        this._myDefaultHandleSize = theSize;
        this.setSliderMode(this._mySliderMode);
    }

    @Deprecated
    public Slider setSensitivity(float theValue) {
        return this.setScrollSensitivity(theValue);
    }

    private class SliderViewH
    extends SliderView {
        SliderViewH() {
            Slider.this._myCaptionLabel.align(11, 3);
            Slider.this._myValueLabel.set("" + Slider.this.adjustValue(Slider.this.getValue())).align(37, 3);
        }

        void setSnapValue() {
            float n = PApplet.round((float)PApplet.map((float)Slider.this._myValuePosition, (float)0.0f, (float)Slider.this.getWidth(), (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1)));
            Slider.this._myValue = PApplet.map((float)n, (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1), (float)Slider.this._myMin, (float)Slider.this._myMax);
        }

        void updateUnit() {
            Slider.this._myUnit = (Slider.this._myMax - Slider.this._myMin) / (float)(Slider.this.width - Slider.this._myHandleSize);
        }

        void update() {
            float f = Slider.this._myMin + ((float)Slider.this._myControlWindow.mouseX - (Slider.this._myParent.getAbsolutePosition().x + Slider.this.position.x)) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        void updateInternalEvents(PApplet theApplet) {
            float f = Slider.this._myMin + ((float)Slider.this._myControlWindow.mouseX - (Slider.this._myParent.getAbsolutePosition().x + Slider.this.position.x)) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        public void display(PApplet theApplet, Slider theController) {
            theApplet.fill(Slider.this.getColor().getBackground());
            theApplet.noStroke();
            if ((Slider.this.getColor().getBackground() >> 24 & 0xFF) > 0) {
                theApplet.rect(0.0f, 0.0f, (float)Slider.this.getWidth(), (float)Slider.this.getHeight());
            }
            theApplet.fill(Slider.this.getIsInside() ? Slider.this.getColor().getActive() : Slider.this.getColor().getForeground());
            if (Slider.this.getSliderMode() == 1) {
                theApplet.rect(0.0f, 0.0f, Slider.this.getValuePosition(), (float)Slider.this.getHeight());
            } else if (Slider.this.isShowTickMarks) {
                theApplet.triangle(Slider.this.getValuePosition(), 0.0f, Slider.this.getValuePosition() + (float)Slider.this.getHandleSize(), 0.0f, Slider.this.getValuePosition() + (float)(Slider.this._myHandleSize / 2), (float)Slider.this.getHeight());
            } else {
                theApplet.rect(Slider.this.getValuePosition(), 0.0f, (float)Slider.this.getHandleSize(), (float)Slider.this.getHeight());
            }
            theApplet.fill(255);
            if (Slider.this.isLabelVisible) {
                Slider.this.getValueLabel().draw(theApplet, 0, 0, theController);
                Slider.this.getCaptionLabel().draw(theApplet, 0, 0, theController);
            }
            if (Slider.this.isShowTickMarks) {
                theApplet.pushMatrix();
                theApplet.pushStyle();
                theApplet.translate(Slider.this.getSliderMode() == 1 ? 0.0f : (float)(Slider.this.getHandleSize() / 2), (float)Slider.this.getHeight());
                theApplet.fill(Slider.this._myColorTickMark);
                theApplet.noStroke();
                float x = (Slider.this.getWidth() - (Slider.this.getSliderMode() == 1 ? 0 : Slider.this.getHandleSize())) / (Slider.this.getTickMarks().size() - 1);
                for (TickMark tm : Slider.this.getTickMarks()) {
                    tm.draw(theApplet, Slider.this.getDirection());
                    theApplet.translate(x, 0.0f);
                }
                theApplet.popStyle();
                theApplet.popMatrix();
            }
        }
    }

    private class SliderViewV
    extends SliderView {
        SliderViewV() {
            Slider.this._myCaptionLabel.align(37, 13).setPadding(0, Label.paddingY);
            Slider.this._myValueLabel.set("" + Slider.this.adjustValue(Slider.this.getValue())).align(11, 101);
        }

        void setSnapValue() {
            float n = PApplet.round((float)PApplet.map((float)Slider.this._myValuePosition, (float)0.0f, (float)Slider.this.getHeight(), (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1)));
            Slider.this._myValue = PApplet.map((float)n, (float)0.0f, (float)(Slider.this._myTickMarks.size() - 1), (float)Slider.this._myMin, (float)Slider.this._myMax);
        }

        void updateUnit() {
            Slider.this._myUnit = (Slider.this._myMax - Slider.this._myMin) / (float)(Slider.this.height - Slider.this._myHandleSize);
        }

        void update() {
            float f = Slider.this._myMin + -((float)Slider.this._myControlWindow.mouseY - (Slider.this._myParent.getAbsolutePosition().y + Slider.this.position.y) - (float)Slider.this.height) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        void updateInternalEvents(PApplet theApplet) {
            float f = Slider.this._myMin + -((float)Slider.this._myControlWindow.mouseY - (Slider.this._myParent.getAbsolutePosition().y + Slider.this.position.y) - (float)Slider.this.height) * Slider.this._myUnit;
            Slider.this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)Slider.this._myMinReal, (float)Slider.this._myMaxReal));
        }

        public void display(PApplet theApplet, Slider theController) {
            theApplet.fill(Slider.this.getColor().getBackground());
            theApplet.noStroke();
            if ((Slider.this.getColor().getBackground() >> 24 & 0xFF) > 0) {
                theApplet.rect(0.0f, 0.0f, (float)Slider.this.getWidth(), (float)Slider.this.getHeight());
            }
            theApplet.fill(Slider.this.getIsInside() ? Slider.this.getColor().getActive() : Slider.this.getColor().getForeground());
            if (Slider.this.getSliderMode() == 1) {
                theApplet.rect(0.0f, (float)Slider.this.getHeight(), (float)Slider.this.getWidth(), -Slider.this.getValuePosition());
            } else if (Slider.this.isShowTickMarks) {
                theApplet.triangle((float)Slider.this.getWidth(), (float)Slider.this.getHeight() - Slider.this.getValuePosition(), (float)Slider.this.getWidth(), (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)Slider.this.getHandleSize(), 0.0f, (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)(Slider.this.getHandleSize() / 2));
            } else {
                theApplet.rect(0.0f, (float)Slider.this.getHeight() - Slider.this.getValuePosition() - (float)Slider.this.getHandleSize(), (float)Slider.this.getWidth(), (float)Slider.this.getHandleSize());
            }
            if (Slider.this.isLabelVisible) {
                Slider.this.getCaptionLabel().draw(theApplet, 0, 0, theController);
                theApplet.pushMatrix();
                theApplet.translate(0.0f, (float)((int)PApplet.map((float)Slider.this._myValue, (float)Slider.this._myMax, (float)Slider.this._myMin, (float)0.0f, (float)(Slider.this.getHeight() - Slider.this._myValueLabel.getHeight()))));
                Slider.this.getValueLabel().draw(theApplet, 0, 0, theController);
                theApplet.popMatrix();
            }
            if (Slider.this.isShowTickMarks) {
                theApplet.pushMatrix();
                theApplet.pushStyle();
                theApplet.translate(-4.0f, Slider.this.getSliderMode() == 1 ? 0.0f : (float)(Slider.this.getHandleSize() / 2));
                theApplet.fill(Slider.this._myColorTickMark);
                float x = (Slider.this.getHeight() - (Slider.this.getSliderMode() == 1 ? 0 : Slider.this.getHandleSize())) / (Slider.this.getTickMarks().size() - 1);
                for (TickMark tm : Slider.this.getTickMarks()) {
                    tm.draw(theApplet, Slider.this.getDirection());
                    theApplet.translate(0.0f, x);
                }
                theApplet.popStyle();
                theApplet.popMatrix();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SliderView
    implements ControllerView<Slider> {
        private SliderView() {
        }

        abstract void updateInternalEvents(PApplet var1);

        abstract void update();

        abstract void updateUnit();

        abstract void setSnapValue();
    }
}

