/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.Slider;
import processing.core.PApplet;
import processing.core.PFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Textarea
extends ControllerGroup<Textarea>
implements ControlListener {
    protected String _myText;
    protected Slider _myScrollbar;
    protected int _myColorBackground = 0;
    protected boolean isColorBackground = false;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    protected int _myBottomOffset = 4;
    private int _myScrollbarWidth = 5;

    public Textarea(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, "", 0, 0, 199, 99);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected Textarea(ControlP5 theControlP5, ControllerGroup<?> theGroup, String theName, String theText, int theX, int theY, int theW, int theH) {
        super(theControlP5, theGroup, theName, theX, theY);
        this._myWidth = theW;
        this._myHeight = theH;
        this._myText = theText;
        this.setup();
    }

    public Textarea(String theText, int theX, int theY) {
        super(theX, theY);
        this._myText = theText;
        this.setup();
    }

    private void setup() {
        this._myValueLabel = new Label(this.cp5, this._myText);
        if (this._myValueLabel.getFont().get() instanceof ControlFont.BitFontLabel) {
            this._myValueLabel.setFont(1);
        }
        this._myValueLabel.setWidth(this._myWidth);
        this._myValueLabel.setHeight(this._myHeight);
        this._myValueLabel.setMultiline(true);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.setColor(this.color.getValueLabel());
        this._myScrollbar = new Slider(this.cp5, this._myParent, this.getName() + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth - 5, 0, 5, this._myHeight);
        this._myScrollbar.init();
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.isMoveable = false;
        this._myScrollbar.isLabelVisible = false;
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this.add(this._myScrollbar);
        this.setWidth(this._myWidth);
        this.setHeight(this._myHeight);
        this._myScrollbar.color.set(this.color);
        this._myScrollbar.setColorBackground(0);
        this._myScrollbar.setHandleSize(40);
    }

    @Override
    public void controlEvent(ControlEvent theEvent) {
        this._myScrollValue = -(1.0f - theEvent.getValue());
        this.scroll();
    }

    public Textarea hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
        return this;
    }

    public Textarea showScrollbar() {
        boolean isScrollbar;
        this.isScrollbarVisible = true;
        boolean bl = isScrollbar = this._myHeight < this._myValueLabel.getTextHeight() + this._myValueLabel.getLineHeight();
        if (isScrollbar) {
            this._myScrollbar.show();
        }
        return this;
    }

    public boolean isScrollable() {
        return this._myScrollbar.isVisible();
    }

    @Override
    public Textarea setColorBackground(int theColor) {
        this._myColorBackground = theColor;
        this.isColorBackground = true;
        return this;
    }

    public Textarea disableColorBackground() {
        this.isColorBackground = false;
        return this;
    }

    public Textarea enableColorBackground() {
        this.isColorBackground = true;
        return this;
    }

    public Textarea scroll(float theValue) {
        this._myScrollbar.setValue(1.0f - theValue);
        return this;
    }

    private void scroll() {
        boolean isScrollbar;
        this._myScrollValue = PApplet.min((float)PApplet.max((float)-1.0f, (float)this._myScrollValue), (float)0.0f);
        float myLen = this._myValueLabel.getTextHeight() + this._myValueLabel.getLineHeight();
        float myOffset = 0.0f;
        boolean bl = isScrollbar = (float)this._myHeight < myLen;
        if (isScrollbar) {
            myOffset = this._myScrollValue * (myLen - (float)this._myHeight + (float)this._myBottomOffset);
        }
        isScrollbar = this.isScrollbarVisible ? isScrollbar : false;
        this._myScrollbar.setVisible(isScrollbar);
        this._myValueLabel.setOffsetYratio(this._myScrollValue);
    }

    @ControlP5.Invisible
    public void scrolled(int theStep) {
        if (this._myScrollbar.isVisible()) {
            int lines = this._myValueLabel.getTextHeight() / this._myValueLabel.getLineHeight();
            float step = 1.0f / (float)lines;
            this.scroll(1.0f - this.getScrollPosition() + (float)theStep * step);
        }
    }

    @ControlP5.Invisible
    public float getScrollPosition() {
        return this._myScrollbar.getValue();
    }

    @Override
    public Textarea setWidth(int theValue) {
        this._myWidth = theValue = theValue < 10 ? 10 : theValue;
        this._myValueLabel.setWidth(this._myWidth - this._myScrollbarWidth - 10);
        return this;
    }

    @Override
    public Textarea setHeight(int theValue) {
        this._myHeight = theValue = theValue < 10 ? 10 : theValue;
        this._myValueLabel.setHeight(this._myHeight - 2);
        this._myScrollbar.setHeight(theValue);
        return this;
    }

    public Textarea setSize(int theWidth, int theHeight) {
        this.setWidth(theWidth);
        this.setHeight(theHeight);
        return this;
    }

    public Textarea setLineHeight(int theLineHeight) {
        this._myValueLabel.setLineHeight(theLineHeight);
        this.scroll();
        return this;
    }

    public Textarea setColor(int theColor) {
        this._myValueLabel.setColor(theColor, true);
        return this;
    }

    @Override
    public Label getValueLabel() {
        return this._myValueLabel;
    }

    public Textarea setText(String theText) {
        this._myValueLabel.set(theText);
        this._myScrollValue = (float)this._myHeight / (float)this._myValueLabel.getTextHeight();
        this._myScrollbar.setHeight(this._myHeight + this._myValueLabel.getStyle().paddingTop + this._myValueLabel.getStyle().paddingBottom);
        return this;
    }

    public String getText() {
        return this.getStringValue();
    }

    @Override
    protected void preDraw(PApplet theApplet) {
        if (this.isScrollbarVisible) {
            this._myScrollbar.setVisible(this._myValueLabel.getOverflow() > 1);
        }
        if (this._myScrollbar.isVisible() || this.isColorBackground) {
            this._myScrollbar.getPosition().x = this._myWidth - this._myScrollbarWidth + this._myValueLabel.getStyle().paddingLeft + this._myValueLabel.getStyle().paddingRight;
            if (!this.isColorBackground) {
                theApplet.noFill();
            } else {
                int a = this._myColorBackground >> 24 & 0xFF;
                theApplet.fill(this._myColorBackground, a > 0 ? (float)a : 255.0f);
            }
            int ww = this._myWidth + this._myValueLabel.getStyle().paddingLeft + this._myValueLabel.getStyle().paddingRight;
            int hh = this._myHeight + this._myValueLabel.getStyle().paddingTop + this._myValueLabel.getStyle().paddingBottom;
            theApplet.rect(0.0f, 0.0f, (float)ww, (float)hh);
        }
    }

    @Override
    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x + this._myParent.absolutePosition.x && (float)this._myControlWindow.mouseX < this.position.x + this._myParent.absolutePosition.x + (float)this._myWidth && (float)this._myControlWindow.mouseY > this.position.y + this._myParent.absolutePosition.y && (float)this._myControlWindow.mouseY < this.position.y + this._myParent.absolutePosition.y + (float)this._myHeight;
    }

    @Override
    public String getStringValue() {
        return this._myValueLabel.getText();
    }

    public Textarea setFont(ControlFont theFont) {
        this.getValueLabel().setFont(theFont);
        return this;
    }

    public Textarea setFont(PFont thePFont) {
        this.getValueLabel().setFont(thePFont);
        return this;
    }

    public Textarea setFont(int theFontIndex) {
        this.getValueLabel().setFont(theFontIndex);
        return this;
    }

    public Textarea setScrollBackground(int theColor) {
        this._myScrollbar.setColorBackground(theColor);
        return this;
    }

    public Textarea setScrollForeground(int theColor) {
        this._myScrollbar.setColorForeground(theColor);
        return this;
    }

    public Textarea setScrollActive(int theColor) {
        this._myScrollbar.setColorActive(theColor);
        return this;
    }

    public Textarea setBorderColor(int theColor) {
        this.color.setBackground(theColor);
        return this;
    }

    @Override
    public float getValue() {
        return 0.0f;
    }

    @Override
    @Deprecated
    public float value() {
        return 0.0f;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.getStringValue();
    }

    @Override
    @Deprecated
    public Label valueLabel() {
        return this.getValueLabel();
    }

    @Deprecated
    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    @Deprecated
    public String text() {
        return this.getText();
    }
}

