/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControlWindowCanvas;
import controlP5.ControllerGroup;
import controlP5.ControllerPlug;
import controlP5.Slider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPicker
extends ControlGroup<ColorPicker> {
    protected Slider sliderRed;
    protected Slider sliderGreen;
    protected Slider sliderBlue;
    protected Slider sliderAlpha;
    protected ControlWindowCanvas currentColor;
    private Object _myPlug;
    private String _myPlugName;
    private boolean broadcast;

    public ColorPicker(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0, 0, 255, 10);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    protected ColorPicker(ControlP5 theControlP5, ControllerGroup<?> theParent, String theName, int theX, int theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myArrayValue = new float[]{255.0f, 255.0f, 255.0f, 255.0f};
        this.currentColor = this.addCanvas(new ColorField());
        this.sliderRed = this.cp5.addSlider(theName + "-red", 0.0f, 255.0f, 0, 0, theWidth, theHeight);
        this.cp5.removeProperty(this.sliderRed);
        this.sliderRed.setId(0);
        this.sliderRed.setBroadcast(false);
        this.sliderRed.addListener(this);
        this.sliderRed.moveTo(this);
        this.sliderRed.setMoveable(false);
        this.sliderRed.setColorBackground(-10092544);
        this.sliderRed.setColorForeground(-5636096);
        this.sliderRed.setColorActive(-65536);
        this.sliderRed.getCaptionLabel().setVisible(false);
        this.sliderRed.setDecimalPrecision(0);
        this.sliderRed.setValue(255.0f);
        this.sliderGreen = this.cp5.addSlider(theName + "-green", 0.0f, 255.0f, 0, theHeight + 1, theWidth, theHeight);
        this.cp5.removeProperty(this.sliderGreen);
        this.sliderGreen.setId(1);
        this.sliderGreen.setBroadcast(false);
        this.sliderGreen.addListener(this);
        this.sliderGreen.moveTo(this);
        this.sliderGreen.setMoveable(false);
        this.sliderGreen.setColorBackground(-16751104);
        this.sliderGreen.setColorForeground(-16733696);
        this.sliderGreen.setColorActive(-16711936);
        this.sliderGreen.getCaptionLabel().setVisible(false);
        this.sliderGreen.setDecimalPrecision(0);
        this.sliderGreen.setValue(255.0f);
        this.sliderBlue = this.cp5.addSlider(theName + "-blue", 0.0f, 255.0f, 0, (theHeight + 1) * 2, theWidth, theHeight);
        this.cp5.removeProperty(this.sliderBlue);
        this.sliderBlue.setId(2);
        this.sliderBlue.setBroadcast(false);
        this.sliderBlue.addListener(this);
        this.sliderBlue.moveTo(this);
        this.sliderBlue.setMoveable(false);
        this.sliderBlue.setColorBackground(-16777114);
        this.sliderBlue.setColorForeground(-16777046);
        this.sliderBlue.setColorActive(-16776961);
        this.sliderBlue.getCaptionLabel().setVisible(false);
        this.sliderBlue.setDecimalPrecision(0);
        this.sliderBlue.setValue(255.0f);
        this.sliderAlpha = this.cp5.addSlider(theName + "-alpha", 0.0f, 255.0f, 0, (theHeight + 1) * 3, theWidth, theHeight);
        this.cp5.removeProperty(this.sliderAlpha);
        this.sliderAlpha.setId(3);
        this.sliderAlpha.setBroadcast(false);
        this.sliderAlpha.addListener(this);
        this.sliderAlpha.moveTo(this);
        this.sliderAlpha.setMoveable(false);
        this.sliderAlpha.setColorBackground(-10066330);
        this.sliderAlpha.setColorForeground(-5592406);
        this.sliderAlpha.setColorActive(-1);
        this.sliderAlpha.getCaptionLabel().setVisible(false);
        this.sliderAlpha.setDecimalPrecision(0);
        this.sliderAlpha.getValueLabel().setColor(-16777216);
        this.sliderAlpha.setValue(255.0f);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        this.broadcast = true;
    }

    public ColorPicker plugTo(Object theObject) {
        this._myPlug = theObject;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    public ColorPicker plugTo(Object theObject, String thePlugName) {
        this._myPlug = theObject;
        this._myPlugName = thePlugName;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent theEvent) {
        if (this.broadcast) {
            this._myArrayValue[theEvent.getId()] = theEvent.getValue();
            this.broadcast();
        }
    }

    private ColorPicker broadcast() {
        ControlEvent ev = new ControlEvent(this);
        this.setValue(this.getColorValue());
        this.cp5.getControlBroadcaster().broadcast(ev, 2);
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE);
                method.invoke(this._myPlug, (int)this._myValue);
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public ColorPicker setArrayValue(float[] theArray) {
        this.broadcast = false;
        this.sliderRed.setValue(theArray[0]);
        this.sliderGreen.setValue(theArray[1]);
        this.sliderBlue.setValue(theArray[2]);
        this.sliderAlpha.setValue(theArray[3]);
        this.broadcast = true;
        this._myArrayValue = theArray;
        return this.broadcast();
    }

    @Override
    public ColorPicker setColorValue(int theColor) {
        this.setArrayValue(new float[]{theColor >> 16 & 0xFF, theColor >> 8 & 0xFF, theColor >> 0 & 0xFF, theColor >> 24 & 0xFF});
        return this;
    }

    public int getColorValue() {
        return 0xFFFFFFFF & (int)this._myArrayValue[3] << 24 | (int)this._myArrayValue[0] << 16 | (int)this._myArrayValue[1] << 8 | (int)this._myArrayValue[2] << 0;
    }

    @Override
    public String getInfo() {
        return "type:\tColorPicker\n" + super.toString();
    }

    private class ColorField
    extends ControlWindowCanvas {
        private ColorField() {
        }

        public void draw(PApplet theApplet) {
            theApplet.fill(ColorPicker.this._myArrayValue[0], ColorPicker.this._myArrayValue[1], ColorPicker.this._myArrayValue[2], ColorPicker.this._myArrayValue[3]);
            theApplet.rect(0.0f, 44.0f, (float)ColorPicker.this.getWidth(), 15.0f);
        }
    }
}

