/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class ControlFont {
    private FontLabel _myFontLabel;
    public static boolean DEBUG = false;
    public static boolean RENDER_2X;

    public ControlFont(PFont theFont) {
        this(theFont, ControlFont.checkFontSize(theFont));
    }

    private static int checkFontSize(PFont theFont) {
        try {
            return theFont.getFont().getSize();
        }
        catch (NullPointerException e) {
            System.out.println("ControlP5: could not find font-size details for font " + theFont.getName() + ", use constructor ControlFont(PFont theFont, int theFontSize) to specify the font size.");
            return 10;
        }
    }

    public ControlFont(PFont theFont, int theFontSize) {
        this(theFont, theFontSize, theFontSize + 2);
    }

    public ControlFont(PFont theFont, int theFontSize, int theLineHeight) {
        this._myFontLabel = new PFontLabel(theFont, theFontSize, theLineHeight);
    }

    protected ControlFont(int theBitFontIndex) {
        this._myFontLabel = new BitFontLabel(theBitFontIndex);
    }

    void init(Label theLabel) {
        this._myFontLabel.init(theLabel);
    }

    void adjust(PApplet theApplet, Label theLabel) {
        this.get().adjust(theApplet, theLabel);
    }

    public void draw(PApplet theApplet, Label theLabel) {
        this.get().draw(theApplet, theLabel);
    }

    public FontLabel get() {
        return this._myFontLabel;
    }

    public int getWidth() {
        return this.get().getWidth();
    }

    public int getHeight() {
        return this.get().getHeight();
    }

    public static int getWidthFor(String theText, Label theLabel, PApplet theApplet) {
        if (theLabel.getFont().get() instanceof BitFontLabel) {
            BitFontLabel bf = (BitFontLabel)theLabel.getFont().get();
            return BitFontRenderer.getWidth(theLabel, bf, theText);
        }
        PFontLabel pf = (PFontLabel)theLabel.getFont().get();
        theApplet.textFont(pf.pfont, (float)pf.size);
        return (int)theApplet.textWidth(theText);
    }

    class PFontLabel
    implements FontLabel {
        PFont pfont;
        List<String> txt;
        String s = "";
        private int top;
        private int bottom;
        private int center;
        private int height;
        private int width;
        private int baseline = 0;
        private int _myTextHeight = 1;
        private int[] offset = new int[2];
        private int size;

        PFontLabel(PFont theFont, int theFontSize, int theLineHeight) {
            this.pfont = theFont;
            this.size = theFontSize;
            this.txt = new ArrayList<String>();
        }

        public void init(Label theLabel) {
        }

        public void setSize(int theSize) {
            this.size = theSize;
        }

        public int getSize() {
            return this.size;
        }

        public int getOffset(int theIndex) {
            return this.offset[theIndex];
        }

        public int getTextHeight() {
            return this._myTextHeight;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getCenter() {
            return this.center;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public PFont getFont() {
            return this.pfont;
        }

        public void adjust(PApplet theApplet, Label theLabel) {
            if (theLabel.isChanged()) {
                theApplet.textFont(this.pfont, (float)this.size);
                this.top = -((int)theApplet.textAscent());
                this.bottom = (int)theApplet.textDescent();
                this.center = -((-this.top - this.bottom) / 2);
                this.height = theLabel.isMultiline() ? theLabel.getHeight() : (int)(theApplet.textAscent() + theApplet.textDescent());
                int n = this.width = theLabel.isMultiline() ? theLabel.getWidth() : (int)theApplet.textWidth(theLabel.getTextFormatted());
                if (theLabel.isMultiline()) {
                    this.calculateHeight(theApplet, theLabel);
                }
                theLabel.setChanged(false);
            }
        }

        private void calculateHeight(PApplet theApplet, Label theLabel) {
            this.txt.clear();
            String myString = theLabel.getTextFormatted();
            List<String> paragraphs = Arrays.asList(myString.split("\n"));
            myString = "";
            for (String p : paragraphs) {
                List<String> words = Arrays.asList(p.split("\\s"));
                for (String w : words) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (theApplet.textWidth(stringBuilder.append(myString).append(w).toString()) < (float)this.width) {
                        myString = myString + w + " ";
                        continue;
                    }
                    this.txt.add(myString.substring(0, PApplet.max((int)0, (int)(myString.length() - 1))));
                    myString = w + " ";
                }
                this.txt.add(myString.substring(0, myString.length() - 1));
                myString = "";
            }
            if (theLabel.getHeight() % theLabel.getLineHeight() != 0) {
                this.txt.add("");
            }
            this._myTextHeight = PApplet.round((float)(this.txt.size() * theLabel.getLineHeight()));
            int maxLineNum = PApplet.round((float)(theLabel.getHeight() / theLabel.getLineHeight()));
            int offset = (int)((float)PApplet.max((int)0, (int)(this.txt.size() - maxLineNum)) * PApplet.abs((float)theLabel.getOffsetYratio()));
            int lim = PApplet.min((int)this.txt.size(), (int)maxLineNum);
            this.s = "";
            for (int i = 0; i < lim; ++i) {
                this.s = this.s + this.txt.get(i + offset) + "\n";
            }
        }

        public int getOverflow() {
            return this._myTextHeight - this.height;
        }

        public void draw(PApplet theApplet, Label theLabel) {
            theApplet.textFont(this.pfont, (float)this.size);
            theApplet.fill(-65536);
            if (theLabel.isMultiline()) {
                theApplet.fill(theLabel.getColor());
                theApplet.textLeading((float)theLabel.getLineHeight());
                theApplet.text(this.s, 0.0f, 0.0f, (float)theLabel.getWidth(), (float)theLabel.getHeight());
            } else {
                theApplet.translate(0.0f, (float)(-this.top + 1));
                this.debug(theApplet, theLabel);
                theApplet.fill(theLabel.getColor());
                theApplet.text(theLabel.getTextFormatted(), 0.0f, 0.0f);
                if (RENDER_2X) {
                    theApplet.text(theLabel.getTextFormatted(), 0.0f, 0.0f);
                }
            }
        }

        private void debug(PApplet theApplet, Label theLabel) {
            if (DEBUG) {
                theApplet.stroke(0.0f, 255.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getBaseline(), theApplet.textWidth(theLabel.getText()), (float)this.getBaseline());
                theApplet.stroke(0.0f, 0.0f, 255.0f);
                theApplet.line(0.0f, (float)this.getTop(), theApplet.textWidth(theLabel.getText()), (float)this.getTop());
                theApplet.stroke(255.0f, 255.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getBottom(), theApplet.textWidth(theLabel.getText()), (float)this.getBottom());
                theApplet.stroke(255.0f, 0.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getCenter(), theApplet.textWidth(theLabel.getText()), (float)this.getCenter());
                theApplet.stroke(255.0f, 128.0f, 0.0f);
                theApplet.line(0.0f, (float)(this.getTop() / 2), theApplet.textWidth(theLabel.getText()), (float)(this.getTop() / 2));
                theApplet.noStroke();
            }
        }
    }

    class BitFontLabel
    implements FontLabel {
        private int _myFontIndex = 0;
        private PImage _myImage;
        private PImage _myImageMask;
        private Label plabel;
        int changeInSizeThreshold = 0;
        private int top;
        private int bottom;
        private int center;
        private int baseline;
        private int height;
        private int width;
        private int _myTextHeight = 1;
        private int[] offset = new int[2];

        BitFontLabel(int theIndex) {
            this._myFontIndex = theIndex;
        }

        public void init(Label theLabel) {
            this.width = BitFontRenderer.getWidth(theLabel, this);
            this.height = BitFontRenderer.getHeight(this.getFontIndex());
            this.bottom = 3;
            this.top = -this.height + this.bottom;
            this.center = -6 + this.bottom;
            this.baseline = 0;
        }

        public int getSize() {
            return 6;
        }

        public void adjust(PApplet theApplet, Label theLabel) {
            if (this._myImage == null) {
                this.adjustTexture(theApplet, theLabel);
            }
            if (this.changed(this.plabel, theLabel)) {
                if (theLabel.isMultiline()) {
                    this.adjustTexture(theApplet, theLabel);
                    return;
                }
                this.adjustTexture(theApplet, theLabel);
                BitFontRenderer.write(this, theLabel);
            }
        }

        private void calculateHeight(Label theLabel) {
            this._myTextHeight = BitFontRenderer.write(this, theLabel);
            if (theLabel.isMultiline()) {
                int n = (int)((float)(this._myTextHeight - this.height + theLabel.getLineHeight()) * theLabel.getOffsetYratio());
                this.offset[1] = n > 0 ? 0 : n;
            }
        }

        public int getOverflow() {
            return this._myTextHeight - this.height;
        }

        public int getOffset(int theIndex) {
            return this.offset[theIndex];
        }

        public void draw(PApplet theApplet, Label theLabel) {
            theApplet.noStroke();
            theApplet.translate(0.0f, (float)(-this.top));
            this.debug(theApplet, theLabel);
            theApplet.image(this._myImage, 0.0f, (float)this.top);
            this.plabel = theLabel.copy();
        }

        public int getTextHeight() {
            return this._myTextHeight;
        }

        private void debug(PApplet theApplet, Label theLabel) {
            if (DEBUG) {
                theApplet.stroke(0.0f, 255.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getBaseline(), theApplet.textWidth(theLabel.getText()), (float)this.getBaseline());
                theApplet.stroke(0.0f, 0.0f, 255.0f);
                theApplet.line(0.0f, (float)this.getTop(), theApplet.textWidth(theLabel.getText()), (float)this.getTop());
                theApplet.stroke(255.0f, 255.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getBottom(), theApplet.textWidth(theLabel.getText()), (float)this.getBottom());
                theApplet.stroke(255.0f, 0.0f, 0.0f);
                theApplet.line(0.0f, (float)this.getCenter(), theApplet.textWidth(theLabel.getText()), (float)this.getCenter());
                theApplet.noStroke();
            }
        }

        private void adjustTexture(PApplet theApplet, Label theLabel) {
            if (theLabel.isMultiline() || theLabel.isFixedSize()) {
                this.width = theLabel.getWidth();
                this.height = theLabel.getHeight();
            } else {
                this.width = BitFontRenderer.getWidth(theLabel, this);
                this.height = BitFontRenderer.getHeight(this.getFontIndex());
                this.width += this.changeInSizeThreshold;
            }
            this._myImage = theApplet.createImage(this.width, this.height, 2);
            this._myImageMask = theApplet.createImage(this.width, this.height, 1);
            this.calculateHeight(theLabel);
            theLabel.setWidth(this.width);
            theLabel.setHeight(this.height);
            theLabel.setChanged(false);
        }

        private boolean changed(Label a, Label b) {
            if (b.isMultiline()) {
                return b.isChanged();
            }
            if (a == null || b == null) {
                return false;
            }
            if (b.isChanged()) {
                b.setChanged(false);
                return true;
            }
            return !a.getText().equals(b.getText());
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getCenter() {
            return this.center;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setFontIndex(int theIndex) {
            this._myFontIndex = theIndex;
            this._myImage = null;
        }

        public int getFontIndex() {
            return this._myFontIndex;
        }

        public PImage getImage() {
            return this._myImage;
        }

        public PImage getImageMask() {
            return this._myImageMask;
        }
    }

    static interface FontLabel {
        public void adjust(PApplet var1, Label var2);

        public void draw(PApplet var1, Label var2);

        public int getWidth();

        public int getHeight();

        public void init(Label var1);

        public int getCenter();

        public int getTop();

        public int getBottom();

        public int getBaseline();

        public int getTextHeight();

        public int getOverflow();

        public int getOffset(int var1);

        public int getSize();
    }
}

