/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControlP5IOHandler {
    ControlP5 cp5;
    String _myFilePath;
    String _myUrlPath;
    boolean isLock;
    private static final String fSTART_CHAR = "[";
    private static final String fEND_CHAR = "]";
    private static final String fSEPARATOR = ", ";
    private static final String fNULL = "null";

    public ControlP5IOHandler(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
    }

    public static String forURL(String aURLFragment) {
        String result = null;
        try {
            result = URLEncoder.encode(aURLFragment, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported", ex);
        }
        return result;
    }

    public static String forHTMLTag(String aTagFragment) {
        StringBuffer result = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"') {
                result.append("&quot;");
            } else if (character == '\'') {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    String URLEncode(String string) {
        String output = new String();
        try {
            byte[] input = string.getBytes("UTF-8");
            for (int i = 0; i < input.length; ++i) {
                if (input[i] < 0) continue;
                output = input[i] == 32 ? output + '+' : output + (char)input[i];
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return output;
    }

    public static String replace(String theSourceString, String theSearchForString, String theReplaceString) {
        if (theSourceString.length() < 1) {
            return "";
        }
        for (int p = 0; p < theSourceString.length() && (p = theSourceString.indexOf(theSearchForString, p)) >= 0; p += theReplaceString.length()) {
            theSourceString = theSourceString.substring(0, p) + theReplaceString + theSourceString.substring(p + theSearchForString.length(), theSourceString.length());
        }
        return theSourceString;
    }

    public static int parseHex(String theHex) {
        int myLen = theHex.length();
        switch (myLen) {
            case 8: {
                break;
            }
            case 6: {
                theHex = "ff" + theHex;
                break;
            }
            default: {
                theHex = "ff000000";
            }
        }
        int a = new Integer(Integer.parseInt(theHex.substring(0, 2), 16));
        int r = new Integer(Integer.parseInt(theHex.substring(2, 4), 16));
        int g = new Integer(Integer.parseInt(theHex.substring(4, 6), 16));
        int b = new Integer(Integer.parseInt(theHex.substring(6, 8), 16));
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String intToString(int theInt) {
        int a = theInt >> 24 & 0xFF;
        int r = theInt >> 16 & 0xFF;
        int g = theInt >> 8 & 0xFF;
        int b = theInt >> 0 & 0xFF;
        String sa = Integer.toHexString(a).length() == 1 ? "0" + Integer.toHexString(a) : Integer.toHexString(a);
        String sr = Integer.toHexString(r).length() == 1 ? "0" + Integer.toHexString(r) : Integer.toHexString(r);
        String sg = Integer.toHexString(g).length() == 1 ? "0" + Integer.toHexString(g) : Integer.toHexString(g);
        String sb = Integer.toHexString(b).length() == 1 ? "0" + Integer.toHexString(b) : Integer.toHexString(b);
        return sa + sr + sg + sb;
    }

    @Deprecated
    protected boolean save(ControlP5 theControlP5, String theFilePath) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    public static String arrayToString(Object aArray) {
        if (aArray == null) {
            return fNULL;
        }
        ControlP5IOHandler.checkObjectIsArray(aArray);
        StringBuilder result = new StringBuilder(fSTART_CHAR);
        int length = Array.getLength(aArray);
        for (int idx = 0; idx < length; ++idx) {
            Object item = Array.get(aArray, idx);
            if (ControlP5IOHandler.isNonNullArray(item)) {
                result.append(ControlP5IOHandler.arrayToString(item));
            } else {
                result.append(item);
            }
            if (ControlP5IOHandler.isLastItem(idx, length)) continue;
            result.append(fSEPARATOR);
        }
        result.append(fEND_CHAR);
        return result.toString();
    }

    private static void checkObjectIsArray(Object aArray) {
        if (!aArray.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    private static boolean isNonNullArray(Object aItem) {
        return aItem != null && aItem.getClass().isArray();
    }

    private static boolean isLastItem(int aIdx, int aLength) {
        return aIdx == aLength - 1;
    }

    protected static String formatGetClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        String pattern = "class ";
        return c.toString().startsWith("class ") ? c.toString().substring("class ".length()) : c.toString();
    }

    @Deprecated
    public Image loadImage2(URL theURL) {
        return this.loadImage((Component)this.cp5.papplet, theURL);
    }

    @Deprecated
    public Image loadImage(Component theComponent, URL theURL) {
        if (theComponent == null) {
            theComponent = this.cp5.papplet;
        }
        Image img = null;
        img = Toolkit.getDefaultToolkit().createImage(theURL);
        MediaTracker mt = new MediaTracker(theComponent);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            ControlP5.logger().severe("loading image failed." + e.toString());
        }
        catch (Exception e) {
            ControlP5.logger().severe("loading image failed." + e.toString());
        }
        return img;
    }
}

