/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControlWindowCanvas;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.DropdownList;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textarea;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlWindow
implements MouseWheelListener,
WindowFocusListener {
    protected ControlP5 controlP5;
    protected int mouseX;
    protected int mouseY;
    protected int pmouseX;
    protected int pmouseY;
    protected boolean mousePressed;
    protected boolean mouselock;
    protected Controller<?> isControllerActive;
    public int background = 0;
    protected CColor color = new CColor();
    private String _myName = "main";
    protected PApplet _myApplet;
    private boolean isPAppletWindow;
    protected ControllerList _myTabs;
    protected boolean isVisible = true;
    protected boolean isInit = false;
    protected boolean isRemove = false;
    protected CDrawable _myDrawable;
    protected boolean isAutoDraw;
    protected boolean isUpdate;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected List<ControlWindowCanvas> _myControlWindowCanvas;
    private List<ControllerInterface<?>> mouseoverlist;
    private boolean isMouseOver;
    protected boolean isDrawBackground = true;
    protected boolean isUndecorated = false;
    protected boolean is3D;
    protected PVector autoPosition = new PVector(10.0f, 30.0f, 0.0f);
    protected float tempAutoPositionHeight = 0.0f;
    protected boolean rendererNotification = false;
    protected PVector positionOfTabs = new PVector(0.0f, 0.0f, 0.0f);
    private boolean isMouse = true;
    private Pointer _myPointer;
    private boolean mousewheel = true;
    private int _myFrameCount = 0;
    private int mouseWheelMoved = 0;
    private boolean isReset = false;

    public ControlWindow(ControlP5 theControlP5, PApplet theApplet) {
        this.mouseoverlist = new ArrayList();
        this.controlP5 = theControlP5;
        this._myApplet = theApplet;
        this._myApplet.registerMouseEvent((Object)this);
        this._myApplet.addMouseWheelListener((MouseWheelListener)this);
        if (!this._myApplet.online) {
            this._myApplet.frame.addWindowFocusListener(this);
        }
        this.isAutoDraw = true;
        this.init();
    }

    protected void init() {
        this._myPointer = new Pointer();
        String myRenderer = this._myApplet.g.getClass().toString().toLowerCase();
        this.is3D = myRenderer.contains("gl") || myRenderer.contains("3d");
        this._myTabs = new ControllerList();
        this._myControlWindowCanvas = new ArrayList<ControlWindowCanvas>();
        if (this._myApplet instanceof PAppletWindow) {
            this._myName = ((PAppletWindow)this._myApplet).name();
            this.isPAppletWindow = true;
            ((PAppletWindow)this._myApplet).setControlWindow(this);
        }
        if (this._myApplet instanceof PAppletWindow) {
            this.background = -16777216;
        }
        if (!this.isInit) {
            if (this._myApplet instanceof PAppletWindow) {
                this._myApplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
            } else {
                this.controlP5.keyHandler.update(this);
            }
        }
        this._myTabs.add(new Tab(this.controlP5, this, "global"));
        this._myTabs.add(new Tab(this.controlP5, this, "default"));
        this.activateTab((Tab)this._myTabs.get(1));
        if (this._myApplet.g.getClass().getName().indexOf("PGraphics2D") > -1 || this._myApplet.g.getClass().getName().indexOf("PGraphics3D") > -1) {
            if (!this.rendererNotification) {
                ControlP5.logger().info("You are using renderer " + this._myApplet.g.getClass().getName() + ".\n" + "In order to render controlP5 elements you need to call the ControlP5's draw() manually.\n" + "Suggestion is to put controlP5.draw(); at the bottom of the draw function of your sketch.");
                this.rendererNotification = true;
            }
        } else if (!this.isInit) {
            this._myApplet.registerPre((Object)this);
            this._myApplet.registerDraw((Object)this);
        }
        this.isInit = true;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.controlP5.keyHandler.clear();
    }

    public Tab getCurrentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    public ControlWindow activateTab(String theTab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).getName().equals(theTab)) continue;
            if (!((Tab)this._myTabs.get((int)i)).isActive) {
                this.resetMouseOver();
            }
            this.activateTab((Tab)this._myTabs.get(i));
        }
        return this;
    }

    public ControlWindow removeTab(Tab theTab) {
        this._myTabs.remove(theTab);
        return this;
    }

    public Tab add(Tab theTab) {
        this._myTabs.add(theTab);
        return theTab;
    }

    public Tab addTab(String theTab) {
        return this.getTab(theTab);
    }

    protected ControlWindow activateTab(Tab theTab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (this._myTabs.get(i) == theTab) {
                if (!((Tab)this._myTabs.get((int)i)).isActive) {
                    this.resetMouseOver();
                }
                ((Tab)this._myTabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this._myTabs.get(i)).setActive(false);
        }
        return this;
    }

    public ControllerList getTabs() {
        return this._myTabs;
    }

    public Tab getTab(String theTabName) {
        return this.controlP5.getTab(this, theTabName);
    }

    public ControlWindow setPositionOfTabs(PVector thePVector) {
        this.positionOfTabs.set(thePVector);
        return this;
    }

    public ControlWindow setPositionOfTabs(int theX, int theY) {
        this.positionOfTabs.set((float)theX, (float)theY, this.positionOfTabs.z);
        return this;
    }

    public PVector getPositionOfTabs() {
        return this.positionOfTabs;
    }

    void setAllignmentOfTabs(int theValue, int theWidth) {
    }

    void setAllignmentOfTabs(int theValue, int theWidth, int theHeight) {
    }

    void setAllignmentOfTabs(int theValue) {
    }

    public void remove() {
        for (int i = this._myTabs.size() - 1; i >= 0; --i) {
            ((Tab)this._myTabs.get(i)).remove();
        }
        this._myTabs.clear();
        this._myTabs.clearDrawable();
        this.controlP5.controlWindowList.remove(this);
    }

    public ControlWindow clear() {
        this.remove();
        if (this._myApplet instanceof PAppletWindow) {
            this._myApplet.unregisterMouseEvent((Object)this);
            this._myApplet.removeMouseWheelListener((MouseWheelListener)this);
            this._myApplet.stop();
            ((PAppletWindow)this._myApplet).dispose();
            this._myApplet = null;
            System.gc();
        }
        return this;
    }

    protected void updateFont(ControlFont theControlFont) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).updateFont(theControlFont);
        }
    }

    @ControlP5.Invisible
    public void updateEvents() {
        this.handleMouseOver();
        this.handleMouseWheelMoved();
        if (this._myTabs.size() <= 0) {
            return;
        }
        this._myTabs.get(0).updateEvents();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this._myTabs.get(i)).isActive() || !((Tab)this._myTabs.get(i)).isVisible()) continue;
            this._myTabs.get(i).updateEvents();
        }
    }

    public boolean isMouseOver() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            this.resetMouseOver();
        }
        return this.isVisible ? this.isMouseOver : false;
    }

    public boolean isMouseOver(ControllerInterface<?> theController) {
        return this.mouseoverlist.contains(theController);
    }

    public void resetMouseOver() {
        this.isMouseOver = false;
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            this.mouseoverlist.get(i).setMouseOver(false);
        }
        this.mouseoverlist.clear();
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.mouseoverlist;
    }

    private ControlWindow handleMouseOver() {
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            if (this.mouseoverlist.get(i).isMouseOver() && this.isVisible) continue;
            this.mouseoverlist.remove(i);
        }
        this.isMouseOver = this.mouseoverlist.size() > 0;
        return this;
    }

    public ControlWindow removeMouseOverFor(ControllerInterface<?> theController) {
        this.mouseoverlist.remove(theController);
        return this;
    }

    protected ControlWindow setMouseOverController(ControllerInterface<?> theController) {
        if (!this.mouseoverlist.contains(theController) && this.isVisible && theController.isVisible()) {
            this.mouseoverlist.add(theController);
        }
        this.isMouseOver = true;
        return this;
    }

    public void update() {
        this._myTabs.get(0).update();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).update();
        }
    }

    public void setUpdate(boolean theFlag) {
        this.isUpdate = theFlag;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).setUpdate(theFlag);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public ControlWindow addCanvas(ControlWindowCanvas theCanvas) {
        this._myControlWindowCanvas.add(theCanvas);
        theCanvas.setControlWindow(this);
        theCanvas.setup(this._myApplet);
        return this;
    }

    public ControlWindow removeCanvas(ControlWindowCanvas theCanvas) {
        this._myControlWindowCanvas.remove(theCanvas);
        return this;
    }

    public ControlWindow pre() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            if (this.isReset) {
                this.resetMouseOver();
                this.isReset = false;
            }
        } else {
            this.isReset = true;
        }
        if (this.isVisible && this.isPAppletWindow && this.isDrawBackground) {
            this._myApplet.background(this.background);
        }
        return this;
    }

    public ControlWindow smooth() {
        if (this.isPAppletWindow) {
            this._myApplet.smooth();
        }
        return this;
    }

    public ControlWindow noSmooth() {
        if (this.isPAppletWindow) {
            this._myApplet.noSmooth();
        }
        return this;
    }

    public void draw() {
        this._myFrameCount = this._myApplet.frameCount;
        if (!this.controlP5.blockDraw) {
            this.updateEvents();
            if (this.isVisible) {
                int i;
                int myRectMode = this._myApplet.g.rectMode;
                int myEllipseMode = this._myApplet.g.ellipseMode;
                int myImageMode = this._myApplet.g.imageMode;
                this._myApplet.pushStyle();
                this._myApplet.rectMode(0);
                this._myApplet.ellipseMode(0);
                this._myApplet.imageMode(0);
                if (this._myApplet instanceof PAppletWindow) {
                    this._myApplet.background(this.background);
                }
                if (this._myDrawable != null) {
                    this._myDrawable.draw(this._myApplet);
                }
                for (int i2 = 0; i2 < this._myControlWindowCanvas.size(); ++i2) {
                    if (this._myControlWindowCanvas.get(i2).mode() != 0) continue;
                    this._myControlWindowCanvas.get(i2).draw(this._myApplet);
                }
                this._myApplet.noStroke();
                this._myApplet.noFill();
                int myOffsetX = (int)this.getPositionOfTabs().x;
                int myOffsetY = (int)this.getPositionOfTabs().y;
                int myHeight = 0;
                if (this._myTabs.size() > 0) {
                    for (i = 1; i < this._myTabs.size(); ++i) {
                        if (!((Tab)this._myTabs.get(i)).isVisible()) continue;
                        if (myHeight < ((Tab)this._myTabs.get(i)).height()) {
                            myHeight = ((Tab)this._myTabs.get(i)).height();
                        }
                        if (myOffsetX > this.component().getWidth() - ((Tab)this._myTabs.get(i)).width()) {
                            myOffsetY += myHeight + 1;
                            myOffsetX = (int)this.getPositionOfTabs().x;
                            myHeight = 0;
                        }
                        ((Tab)this._myTabs.get(i)).setOffset(myOffsetX, myOffsetY);
                        if (((Tab)this._myTabs.get(i)).isActive()) {
                            ((Tab)this._myTabs.get(i)).draw(this._myApplet);
                        }
                        if (((Tab)this._myTabs.get(i)).updateLabel()) {
                            ((Tab)this._myTabs.get(i)).drawLabel(this._myApplet);
                        }
                        myOffsetX += ((Tab)this._myTabs.get(i)).width();
                    }
                    this._myTabs.get(0).draw(this._myApplet);
                }
                for (i = 0; i < this._myControlWindowCanvas.size(); ++i) {
                    if (this._myControlWindowCanvas.get(i).mode() != 1) continue;
                    this._myControlWindowCanvas.get(i).draw(this._myApplet);
                }
                this.pmouseX = this.mouseX;
                this.pmouseY = this.mouseY;
                this.controlP5.getTooltip().draw(this);
                this._myApplet.rectMode(myRectMode);
                this._myApplet.ellipseMode(myEllipseMode);
                this._myApplet.imageMode(myImageMode);
                this._myApplet.popStyle();
            }
        }
    }

    public ControlWindow setContext(CDrawable theDrawable) {
        this._myDrawable = theDrawable;
        return this;
    }

    public String name() {
        return this._myName;
    }

    public void mouseEvent(MouseEvent theMouseEvent) {
        if (this.isMouse) {
            this.mouseX = theMouseEvent.getX();
            this.mouseY = theMouseEvent.getY();
            if (theMouseEvent.getID() == 501) {
                this.mousePressedEvent();
            }
            if (theMouseEvent.getID() == 502) {
                this.mouseReleasedEvent();
            }
        }
    }

    private void mousePressedEvent() {
        if (this.isVisible) {
            this.mousePressed = true;
            for (int i = 0; i < this._myTabs.size(); ++i) {
                if (!this._myTabs.get(i).setMousePressed(true)) continue;
                this.mouselock = true;
                return;
            }
        }
    }

    private void mouseReleasedEvent() {
        if (this.isVisible) {
            this.mousePressed = false;
            this.mouselock = false;
            for (int i = 0; i < this._myTabs.size(); ++i) {
                this._myTabs.get(i).setMousePressed(false);
            }
        }
    }

    public ControlWindow disableMouseWheel() {
        this.mousewheel = false;
        return this;
    }

    public ControlWindow enableMouseWheel() {
        this.mousewheel = true;
        return this;
    }

    public boolean isMouseWheel() {
        return this.mousewheel;
    }

    @Override
    @ControlP5.Invisible
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.mousewheel && this.isMouseOver()) {
            this.mouseWheelMoved = e.getWheelRotation();
        }
    }

    private void handleMouseWheelMoved() {
        if (this.mouseWheelMoved != 0) {
            CopyOnWriteArrayList mouselist = new CopyOnWriteArrayList(this.mouseoverlist);
            for (ControllerInterface<?> c : mouselist) {
                if (!c.isVisible()) continue;
                if (c instanceof Controller) {
                    ((Controller)c).onScroll(this.mouseWheelMoved);
                }
                if (c instanceof ControllerGroup) {
                    ((ControllerGroup)c).onScroll(this.mouseWheelMoved);
                }
                if (c instanceof Slider) {
                    ((Slider)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof Knob) {
                    ((Knob)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof Numberbox) {
                    ((Numberbox)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof ListBox) {
                    ((ListBox)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (c instanceof DropdownList) {
                    ((DropdownList)c).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (!(c instanceof Textarea)) break;
                ((Textarea)c).scrolled(this.mouseWheelMoved);
                break;
            }
        }
        this.mouseWheelMoved = 0;
    }

    @ControlP5.Invisible
    public void multitouch(int[][] theCoordinates) {
        for (int n = 0; n < theCoordinates.length; ++n) {
            int i;
            this.mouseX = theCoordinates[n][0];
            this.mouseY = theCoordinates[n][1];
            if (!this.isVisible) continue;
            if (theCoordinates[n][2] == 501) {
                this.mousePressed = true;
                for (i = 0; i < this._myTabs.size(); ++i) {
                    if (!this._myTabs.get(i).setMousePressed(true)) continue;
                    this.mouselock = true;
                    ControlP5.logger().finer(" mouselock = " + this.mouselock);
                    return;
                }
            }
            if (theCoordinates[n][2] != 502) continue;
            this.mousePressed = false;
            this.mouselock = false;
            for (i = 0; i < this._myTabs.size(); ++i) {
                this._myTabs.get(i).setMousePressed(false);
            }
        }
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void keyEvent(KeyEvent theKeyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).keyEvent(theKeyEvent);
        }
    }

    public ControlWindow setColorActive(int theColor) {
        this.color.setActive(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorActive(theColor);
        }
        return this;
    }

    public ControlWindow setColorForeground(int theColor) {
        this.color.setForeground(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorForeground(theColor);
        }
        return this;
    }

    public ControlWindow setColorBackground(int theColor) {
        this.color.setBackground(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorBackground(theColor);
        }
        return this;
    }

    public ControlWindow setColorLabel(int theColor) {
        this.color.setCaptionLabel(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorLabel(theColor);
        }
        return this;
    }

    public ControlWindow setColorValue(int theColor) {
        this.color.setValueLabel(theColor);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorValue(theColor);
        }
        return this;
    }

    public ControlWindow setBackground(int theValue) {
        this.background = theValue;
        return this;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public Component component() {
        return this.papplet();
    }

    public ControlWindow setTitle(String theTitle) {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).setTitle(theTitle);
        }
        return this;
    }

    public ControlWindow showCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).showCoordinates();
        }
        return this;
    }

    public ControlWindow hideCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).hideCoordinates();
        }
        return this;
    }

    public ControlWindow hide() {
        this.isVisible = false;
        this.isMouseOver = false;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(false);
        }
        return this;
    }

    public ControlWindow setUpdateMode(int theMode) {
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).setMode(theMode);
        }
        return this;
    }

    public ControlWindow frameRate(int theFrameRate) {
        this._myApplet.frameRate((float)theFrameRate);
        return this;
    }

    public ControlWindow show() {
        this.isVisible = true;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(true);
        }
        return this;
    }

    public ControlWindow setDrawBackground(boolean theFlag) {
        this.isDrawBackground = theFlag;
        return this;
    }

    public boolean isDrawBackground() {
        return this.isDrawBackground;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isControllerActive(Controller<?> theController) {
        if (this.isControllerActive == null) {
            return false;
        }
        return this.isControllerActive.equals(theController);
    }

    protected ControlWindow setControllerActive(Controller<?> theController) {
        this.isControllerActive = theController;
        return this;
    }

    public ControlWindow toggleUndecorated() {
        this.setUndecorated(!this.isUndecorated());
        return this;
    }

    public ControlWindow setUndecorated(boolean theFlag) {
        if (theFlag != this.isUndecorated()) {
            this.isUndecorated = theFlag;
            this._myApplet.frame.removeNotify();
            this._myApplet.frame.setUndecorated(this.isUndecorated);
            this._myApplet.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.setBounds(0, 0, this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.addNotify();
        }
        return this;
    }

    public Frame getFrame() {
        return this._myApplet.frame;
    }

    public boolean isUndecorated() {
        return this.isUndecorated;
    }

    public ControlWindow setPosition(int theX, int theY) {
        return this.setLocation(theX, theY);
    }

    public ControlWindow setLocation(int theX, int theY) {
        this._myApplet.frame.setLocation(theX, theY);
        return this;
    }

    public Pointer getPointer() {
        return this._myPointer;
    }

    public ControlWindow disablePointer() {
        this._myPointer.disable();
        return this;
    }

    public ControlWindow enablePointer() {
        this._myPointer.enable();
        return this;
    }

    @Deprecated
    public ControllerList tabs() {
        return this._myTabs;
    }

    @Deprecated
    public Tab tab(String theTabName) {
        return this.controlP5.getTab(this, theTabName);
    }

    @Deprecated
    public Tab currentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    @Deprecated
    public void setMode(int theMode) {
        this.setUpdateMode(theMode);
    }

    public class Pointer {
        public Pointer setX(int theX) {
            ControlWindow.this.mouseX = theX;
            return this;
        }

        public Pointer setY(int theY) {
            ControlWindow.this.mouseY = theY;
            return this;
        }

        public int getY() {
            return ControlWindow.this.mouseY;
        }

        public int getX() {
            return ControlWindow.this.mouseX;
        }

        public int getPreviousX() {
            return ControlWindow.this.pmouseX;
        }

        public int getPreviousY() {
            return ControlWindow.this.pmouseY;
        }

        public Pointer set(int theX, int theY) {
            this.setX(theX);
            this.setY(theY);
            return this;
        }

        public Pointer pressed() {
            ControlWindow.this.mousePressedEvent();
            return this;
        }

        public Pointer released() {
            ControlWindow.this.mouseReleasedEvent();
            return this;
        }

        public void enable() {
            ControlWindow.this.isMouse = false;
        }

        public void disable() {
            ControlWindow.this.isMouse = true;
        }

        public boolean isEnabled() {
            return !ControlWindow.this.isMouse;
        }
    }
}

