/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.ColorPicker;
import controlP5.ControlP5;
import controlP5.ControllerInterface;
import controlP5.ControllerLayoutElement;
import controlP5.DropdownList;
import controlP5.ListBox;
import controlP5.RadioButton;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControllerLayout {
    private ControlP5 cp5;
    public static final Logger logger = Logger.getLogger(ControllerLayout.class.getName());

    ControllerLayout(ControlP5 theControlP5) {
        this.cp5 = theControlP5;
    }

    public void save(String theLayoutPath) {
        theLayoutPath = this.cp5.checkPropertiesPath(theLayoutPath);
        Class[] classes = new Class[]{RadioButton.class, ListBox.class, ColorPicker.class, DropdownList.class};
        HashSet<ControllerLayoutElement> layoutelements = new HashSet<ControllerLayoutElement>();
        for (ControllerInterface<?> c : this.cp5.getList()) {
            if (Arrays.asList(classes).contains(c.getParent().getClass())) continue;
            layoutelements.add(new ControllerLayoutElement(c));
            System.out.print(c.getAddress());
            System.out.print(" (" + c.getName() + ") ");
            System.out.print("\tpos:" + c.getPosition().x + "," + c.getPosition().y);
            System.out.print("\tdim:" + c.getWidth() + "," + c.getHeight());
            System.out.print("\tparent:" + c.getParent());
            System.out.println("\tclass:" + c.getClass().getSimpleName());
        }
        try {
            FileOutputStream fos = new FileOutputStream(theLayoutPath);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            logger.info("Saving layout-items to " + theLayoutPath);
            oos.writeInt(layoutelements.size());
            for (ControllerLayoutElement ce : layoutelements) {
                oos.writeObject(ce);
            }
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            logger.warning("Exception during serialization: " + e);
        }
    }

    protected boolean isClassAssignableFromSuperclass(Class<?> theClass, Class<?> theSuper) {
        Class<?> _mySuper = theClass.getSuperclass();
        while (_mySuper.getSuperclass() != null) {
            if (_mySuper.isAssignableFrom(theSuper)) {
                return true;
            }
            _mySuper = _mySuper.getSuperclass();
        }
        return false;
    }

    public void load(String theLayoutPath) {
        theLayoutPath = this.cp5.checkPropertiesPath(theLayoutPath);
        ArrayList<ControllerLayoutElement> list = new ArrayList<ControllerLayoutElement>();
        try {
            FileInputStream fis = new FileInputStream(theLayoutPath);
            ObjectInputStream ois = new ObjectInputStream(fis);
            int size = ois.readInt();
            logger.info("loading " + size + " layout-items." + fis.getFD());
            for (int i = 0; i < size; ++i) {
                try {
                    ControllerLayoutElement ce = (ControllerLayoutElement)ois.readObject();
                    list.add(ce);
                    continue;
                }
                catch (Exception e) {
                    logger.warning("skipping a property, " + e);
                }
            }
            ois.close();
        }
        catch (Exception e) {
            logger.warning("Exception during deserialization: " + e);
        }
        for (ControllerLayoutElement ce : list) {
        }
        for (ControllerLayoutElement ce : list) {
        }
    }

    static {
        HashMap<Class<CColor>, Class<Serializable>> datatypes = new HashMap<Class<CColor>, Class<Serializable>>();
        datatypes.put(Integer.class, Integer.TYPE);
        datatypes.put(Float.class, Float.TYPE);
        datatypes.put(Boolean.class, Boolean.TYPE);
        datatypes.put(Character.class, Character.TYPE);
        datatypes.put(Long.class, Long.TYPE);
        datatypes.put(Double.class, Double.TYPE);
        datatypes.put(Byte.class, Byte.TYPE);
        datatypes.put(PVector.class, PVector.class);
        datatypes.put(CColor.class, CColor.class);
    }
}

