/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toggle
extends Controller<Toggle> {
    protected int cnt;
    protected boolean isOn = false;
    protected float internalValue = -1.0f;
    public static int autoWidth = 39;
    public static int autoHeight = 19;
    protected PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);

    public Toggle(ControlP5 theControlP5, String theName) {
        this(theControlP5, theControlP5.getDefaultTab(), theName, 0.0f, 0.0f, 0.0f, autoWidth, autoHeight);
        theControlP5.register(theControlP5.papplet, theName, this);
    }

    public Toggle(ControlP5 theControlP5, Tab theParent, String theName, float theValue, float theX, float theY, int theWidth, int theHeight) {
        super(theControlP5, theParent, theName, theX, theY, theWidth, theHeight);
        this._myValue = theValue;
        this._myCaptionLabel.align(37, 13).setPadding(0, Label.paddingY);
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet theApplet) {
        theApplet.pushMatrix();
        theApplet.translate(this.position.x, this.position.y);
        this._myControllerView.display(theApplet, this);
        theApplet.popMatrix();
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.setState(!this.isOn);
        this.isActive = false;
    }

    @Override
    public Toggle setValue(float theValue) {
        if (theValue == 0.0f) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setValue(boolean theValue) {
        this.setValue(theValue ? 1.0f : 0.0f);
        return this;
    }

    @Override
    public Toggle update() {
        return this.setValue(this._myValue);
    }

    public Toggle setState(boolean theFlag) {
        this.isOn = theFlag;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
        this.broadcast(2);
        return this;
    }

    public boolean getState() {
        return this.isOn;
    }

    protected void deactivate() {
        this.isOn = false;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    protected void activate() {
        this.isOn = true;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public Toggle toggle() {
        if (this.isOn) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setMode(int theMode) {
        this.updateDisplayMode(theMode);
        return this;
    }

    @ControlP5.Invisible
    public void setInternalValue(float theInternalValue) {
        this.internalValue = theInternalValue;
    }

    @ControlP5.Invisible
    public float internalValue() {
        return this.internalValue;
    }

    @Override
    public Toggle linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Toggle updateDisplayMode(int theState) {
        this._myDisplayMode = theState;
        switch (theState) {
            case 0: {
                this._myControllerView = new ToggleView();
                break;
            }
            case 2: {
                this._myControllerView = new ToggleSpriteView();
                break;
            }
            case 1: {
                this._myControllerView = new ToggleImageView();
                break;
            }
            case 100: {
                this._myControllerView = new ToggleSwitchView();
                break;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleSwitchView
    implements ControllerView<Toggle> {
        ToggleSwitchView() {
        }

        @Override
        public void display(PApplet theApplet, Toggle theController) {
            theApplet.fill(Toggle.this.color.getBackground());
            theApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            theApplet.fill(Toggle.this.color.getActive());
            if (Toggle.this.isOn) {
                theApplet.rect(0.0f, 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            } else {
                theApplet.rect((float)((Toggle.this.width % 2 == 0 ? 0 : 1) + Toggle.this.width / 2), 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            }
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleImageView
    implements ControllerView<Toggle> {
        ToggleImageView() {
        }

        @Override
        public void display(PApplet theApplet, Toggle theController) {
            if (Toggle.this.isActive) {
                theApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else if (Toggle.this.isOn) {
                theApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else {
                theApplet.image(Toggle.this.images[0], 0.0f, 0.0f);
            }
            theApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    class ToggleSpriteView
    implements ControllerView<Toggle> {
        ToggleSpriteView() {
        }

        @Override
        public void display(PApplet theApplet, Toggle theController) {
            if (Toggle.this.isActive) {
                Toggle.this.sprite.setState(1);
            } else if (Toggle.this.isOn) {
                Toggle.this.sprite.setState(1);
            } else {
                Toggle.this.sprite.setState(0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleView
    implements ControllerView<Toggle> {
        ToggleView() {
        }

        @Override
        public void display(PApplet theApplet, Toggle theController) {
            if (Toggle.this.isActive) {
                theApplet.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getForeground());
            } else {
                theApplet.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getBackground());
            }
            theApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(theApplet, 0, 0, theController);
            }
        }
    }
}

