package com.neilmoomey.jpegbrowser2;



import java.io.*;

import java.awt.event.*;

import javax.swing.*;

import javax.swing.event.*;

import javax.swing.tree.*;

import java.awt.*;

import java.util.*;

import javax.swing.table.*;

import javax.swing.filechooser.*;



/** DrivesComboBox.java

 * @author Neil Moomey, www.neilmoomey.com

 * @version 1.0

 **/



public class DrivesComboBox extends JComboBox {

   protected String curDir = ".";

   protected String topNode= ".";

   protected File currentDir;

   private Vector listSelListeners = new Vector();

   protected int selectionMode = ListSelectionModel.SINGLE_SELECTION;

   protected File[] drives;

   protected int driveNumber;

   protected JComboBox drivesComboBox;

   protected String[] drivesName = new String[100];



   public DrivesComboBox(){

      try{

        currentDir = new File(".");

        drives = File.listRoots();

        System.out.println("drives.length = " + drives.length);

		driveNumber = 0;

        curDir = drives[driveNumber].getAbsolutePath();

        System.out.println("curDir = " + curDir);



        // Find Description of each drive



        FileSystemView fsv = FileSystemView.getFileSystemView();



        for (int i=0; i < drives.length; i++) {



			drivesName[i] = drives[i].toString();

			String driveDescription = fsv.getSystemTypeDescription(drives[i]);

			System.out.println("driveDescripton = " + driveDescription );

			//driveDescription = "Root Directory";

			if (driveDescription == null) driveDescription = "Root Directory";

			System.out.println("driveDescripton = " + driveDescription );



			drivesName[i]+= " (" + driveDescription + ")";



			System.out.println("drivesName[" + i + "] = " + drivesName[i]);

			addItem(drivesName[i]);

		}



        if (curDir.equals("A:\\")) {

			driveNumber = 1;

			curDir = drives[driveNumber].getAbsolutePath();

		}

        //System.out.println("curDir = " + curDir);





      }catch (Exception e){}



	  // Create Combo Box

	  //addItem.(drivesName);

	  System.out.println("driveNumber = "+driveNumber);

	  setSelectedIndex(driveNumber);

	  revalidate();



  }



   public void setPath(File path){currentDir = path;}

   public File getPath(){ return currentDir;}



   public String getRoot() {

	   return curDir;

   }



   public static void main(String args[]){

      DrivesComboBox fc = new DrivesComboBox();

	  JFrame f = new JFrame("File Tree Main");

	  f.getContentPane().add(fc);

	  f.setVisible(true);

	  f.setSize(300, 50);

	  f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);



  }

}



