package com.neilmoomey.jpegbrowser2;



import javax.swing.*;

import java.awt.*;

import java.awt.event.*;

import java.awt.image.*;

import java.io.*;

import java.util.*;

import java.net.*;

import javax.imageio.*;

import com.neilmoomey.util.Type;



/** ImagePane.java

 * @author Neil Moomey, www.neilmoomey.com

 * @version 1.1

 **/



public class ImagePane extends JLabel {

	private ImageIcon imageIcon;

	private Image image, imageResized;

	//MediaTracker imageTracker;

	private int imageWidth, imageHeight;



	private static BufferedImage bi;



	public ImagePane(String name) {

		Image imageResized;



		//name=name.replace('\\','/');





		File f1 = new File(name);

		try {

			bi = ImageIO.read(f1);

        } catch (IOException e) {

            System.err.println("IOException has occurred:" + e.getMessage());



            return;

        }



		  	int width=bi.getWidth();

		  	int height=bi.getHeight();



	        //Image imageResized = bi.getScaledInstance(width, height,0);

	        //BufferedImage biImageResized = bi.getSubimage(150, 150, width, height);

		  	//ImageIO.write(imageResized, "jpg", f2);



		setImageWidth(width);

		setImageHeight(height);

		System.out.println("Original width = "+width+" height = "+height);

		float tempWidth = Type.toFloat(width);

		float tempHeight = Type.toFloat(height);

		int w =java.awt.Toolkit.getDefaultToolkit().getScreenSize().width;

		int h =java.awt.Toolkit.getDefaultToolkit().getScreenSize().height;

		float maxWidth=w-225-22; //780;

		float maxHeight=h-52; //710;

		//imageIcon = new ImageIcon(imageResized);

		if (width*height != 0) {

			if (tempWidth > maxWidth) {

				tempHeight = (maxWidth/tempWidth)*tempHeight;

				tempWidth=maxWidth;

			}



			if (tempHeight > maxHeight) {

				tempWidth = (maxHeight/tempHeight)*tempWidth;

				tempHeight=maxHeight;

			}

			width = Type.toInt(tempWidth);

			height = Type.toInt(tempHeight);

			imageResized = bi.getScaledInstance(width, height,0);

			imageIcon = new ImageIcon(imageResized);

		}



		System.out.println("Final width = "+width+" height = "+height);



		setIcon(imageIcon);

	}



	public int getImageWidth() {

		return this.imageWidth;

	}



	public void setImageWidth(int width) {

		this.imageWidth = width;

	}



	public int getImageHeight() {

		return this.imageHeight;

	}

	public void setImageHeight(int height) {

		this.imageHeight = height;

	}

/*

	public int getFileSize() {

		return this.fileSize;

	}



	public void setFileSize(int filesize) {

		this.fileSize = filesize;

	}

*/

	public static void main(String[] args) {

		ImagePane imagePane = new ImagePane("icon.png");

		JFrame f = new JFrame("Image Pane Test");

		f.getContentPane().add(imagePane);

		f.setSize(900, 700);

		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		f.setVisible(true);



	}

}

