package com.neilmoomey.jpegbrowser2;



import javax.swing.*;

import javax.swing.tree.*;

import javax.swing.event.*;

import java.awt.*;

import java.awt.event.*;

import java.io.*;

import java.util.*;

import java.net.*;

import com.neilmoomey.util.Type;

import com.drew.imaging.jpeg.JpegMetadataReader;

import com.drew.metadata.*;

import com.drew.metadata.exif.ExifReader;

import com.drew.metadata.iptc.IptcReader;

//import com.sun.image.codec.jpeg.JPEGDecodeParam;



/** JpegBrowser2.java

 * @author Neil Moomey, www.neilmoomey.com

 * @version 1.1

 **/



public class JpegBrowser2 extends JSplitPane {

	private FileTree fileTree;

	private DrivesComboBox drivesComboBox;

	private JPanel leftPanel;

	private String metaDataString;

	private StringBuffer metaDataStringBuffer;

	private Metadata metadata;

	private JTextArea metaTextArea;

	private int lastLength;



	public JpegBrowser2() {



		// Create DrivesComboBox for drive dropdown menu

		drivesComboBox = new DrivesComboBox();

		drivesComboBox.addActionListener(

        new ActionListener(){

			public void actionPerformed(ActionEvent e){

				JComboBox jcb = (JComboBox)e.getSource();

				int currentDirNum = jcb.getSelectedIndex();

				String curDir;

			    File[] drives = File.listRoots();

				File currentDir = new File(".");

				if(currentDir != null){

                  try {

					  currentDir = drives[currentDirNum]; 	//File

					  curDir = currentDir.toString();		//String

					  System.out.println("curDir in ActionListener = " + curDir);

					  fileTree.createTree(curDir);

                  } catch(Exception e1) {}

               }

            }

       });





		// Create FileTree

		try {

			fileTree = new FileTree();

			// Start with the root directory / or C:\ using curDir from drivesComboBox.

			fileTree.createTree(drivesComboBox.getRoot());



			// Listener for FileTree which does all the work

			fileTree.addTreeSelectionListener(new TreeSelectionListener() {

				public void valueChanged(TreeSelectionEvent evt) {

					TreePath path = evt.getPath();

					String name = fileTree.getPathName(path);

					File file = fileTree.getFile(path);

					System.out.println("File " + name + " has been "

						+ (evt.isAddedPath() ? "selected" : "deselected"));

					System.out.println("File object is " + file);

					System.out.println("Path to image = " + name);







					if (name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg")) {

						ImagePane imagePane = new ImagePane(name);

						JScrollPane rightScrollPane = new JScrollPane(imagePane);

						setRightComponent(rightScrollPane);



						float fileSize = Type.toFloat(file.length()/1000);

						String fileUnits;

						if (fileSize >= 1000) {

							fileSize = fileSize/1000;

							fileUnits = " MB\n";

						} else {

							fileUnits = " KB\n";

						}



						//metaDataString = name;  //temp

						metaDataString = imagePane.getImageWidth() + " x " + imagePane.getImageHeight() + " pixels @ " +  fileSize + fileUnits;

						metaDataString += readMetaData(file);

					}

					//metaTextArea = new JTextArea(metaDataString); // Doesn't work

					if (lastLength > 0) metaTextArea.replaceRange(metaDataString,0,lastLength);

					else metaTextArea.append(metaDataString);

					lastLength=metaDataString.length();

					metaTextArea.setCaretPosition(0);

					System.out.println(metaDataString);

				}

			});





		} catch (FileNotFoundException e) {

			System.out.println("File not found");

		}



		// Create RightClickMenu which extends JPopupMenu

		//RightClickMenu rightClickMenu = new RightClickMenu();

		//MouseListener popupListener = new PopupListener(rightClickMenu);

		//fileTree.addMouseListener(popupListener);



		setDividerLocation(220);



		leftPanel = new JPanel();

		leftPanel.setMinimumSize(new Dimension(220,220));

		leftPanel.setPreferredSize(new Dimension(220,220));



		leftPanel.setLayout(new BorderLayout());

		leftPanel.add(drivesComboBox, BorderLayout.NORTH);

		leftPanel.add(new JScrollPane(fileTree), BorderLayout.CENTER);

		//metaTextArea = new JTextArea("EXIF Metadata\nline2\nline3\nline4\nline5\nline6\nline7\nline9\nline10\nline11\nline12\n",10,1);

		metaTextArea = new JTextArea(14,0);

		metaDataString="EXIF Digital Camera Metadata";

		lastLength=metaDataString.length();

		metaTextArea.append(metaDataString);

		JScrollPane js = new JScrollPane(metaTextArea);

		leftPanel.add(js, BorderLayout.SOUTH);

		setLeftComponent(leftPanel);

	}



	public String readMetaData(File file) {

		metaDataStringBuffer = new StringBuffer();

        try {

            metadata = JpegMetadataReader.readMetadata(file);

        } catch (Exception e) {

            e.printStackTrace(System.err);

        }



		// iterate through metadata directories

		Iterator directories = metadata.getDirectoryIterator();

		while (directories.hasNext()) {

			Directory directory = (Directory)directories.next();

			// iterate through tags and print to System.out

			Iterator tags = directory.getTagIterator();

			while (tags.hasNext()) {

				Tag tag = (Tag)tags.next();

		        try {

					String description=tag.getDescription().trim();

                    if (description.length() > 0) metaDataStringBuffer.append(tag.getTagName()+ ": " + description + "\n");

                } catch (MetadataException e) {

                }

			}

		}



		return metaDataStringBuffer.toString();

	}



	public static void main(String[] args) {

		JpegBrowser2 jpegBrowser2 = new JpegBrowser2();

		JFrame f = new JFrame("Neil's JPEG Browser II");

		f.getContentPane().add(jpegBrowser2);

		f.setSize(600, 500);

		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		f.setVisible(true);



	}



    class PopupListener extends MouseAdapter {

        JPopupMenu popup;



        PopupListener(JPopupMenu popupMenu) {

            popup = popupMenu;

        }



        public void mousePressed(MouseEvent e) {

            maybeShowPopup(e);

        }



        public void mouseReleased(MouseEvent e) {

            maybeShowPopup(e);

        }



        private void maybeShowPopup(MouseEvent e) {

            if (e.isPopupTrigger()) {

                popup.show(e.getComponent(),

                           e.getX(), e.getY());

            }

        }

    }



}

