package com.neilmoomey.jpegbrowser3;

import java.awt.*;
import java.awt.event.*;
import javax.swing.JPopupMenu;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ButtonGroup;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.ImageIcon;

import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JFrame;

/*
 * Like MenuDemo, but with popup menus added.
 */
public class RightClickMenu extends JPopupMenu implements ActionListener, ItemListener {
    StringBuffer output;
    JScrollPane scrollPane;
    String newline = "\n";


    public void createPopupMenu() {
        JMenuItem menuItem;
        JMenu menu, submenu;

        menu = new JMenu("A submenu");
        //menu.setMnemonic(KeyEvent.VK_A);
        //menu.getAccessibleContext().setAccessibleDescription(

        //a submenu
        submenu = new JMenu("Open With");
        submenu.setMnemonic(KeyEvent.VK_S);

        menuItem = new JMenuItem("PhotoShop");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_1, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("PaintShopPro");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_2, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

		add(submenu);

        menuItem = new JMenuItem("Delete");
        menuItem.addActionListener(this);
        add(menuItem);

        //Rotate submenu
        submenu = new JMenu("Rotate");
        submenu.setMnemonic(KeyEvent.VK_S);

        menuItem = new JMenuItem("Right and Save");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_2, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("Left and Save");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_3, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("Right and Save As");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_4, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("Left and Save As");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_5, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        add(submenu);

        menuItem = new JMenuItem("Rename");
        menuItem.addActionListener(this);
        add(menuItem);

        menuItem = new JMenuItem("Copy to");
		menuItem.setMnemonic(KeyEvent.VK_C);
        menuItem.addActionListener(this);
        add(menuItem);

        menuItem = new JMenuItem("Move to");
        menuItem.addActionListener(this);
        add(menuItem);

        //a submenu
        submenu = new JMenu("Send");

        menuItem = new JMenuItem("to Email");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_1, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("to FTP");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_2, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("to Zip");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_3, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);

        menuItem = new JMenuItem("to Folder");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_4, ActionEvent.ALT_MASK));
        menuItem.addActionListener(this);
        submenu.add(menuItem);
        add(submenu);
		
        menuItem = new JMenuItem("Options");
        menuItem.addActionListener(this);
        add(menuItem);

        menuItem = new JMenuItem("Be my Bitch!");
        menuItem.addActionListener(this);
        add(menuItem);		

        //Add listener to the text area so the popup menu can come up.
        //MouseListener popupListener = new PopupListener(this);
        //addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)(e.getSource());
        String s = "Action event detected."
                   + newline
                   + "    Event source1: " + source.getText()
                   + " (an instance of " + getClassName(source) + ")";
		if (source.getText().equals("Be my Bitch!")) s = s+ newline + newline + "Thanks Arnie!";				   
        output.append(s + newline);
		System.out.println("output = " + output.toString());
    }

	
    public void itemStateChanged(ItemEvent e) {
        JMenuItem source = (JMenuItem)(e.getSource());
        String s = "Item event detected."
                   + newline
                   + "    Event source2: " + source.getText()
                   + " (an instance of " + getClassName(source) + ")"
                   + newline
                   + "    New state: "
                   + ((e.getStateChange() == ItemEvent.SELECTED) ?
                     "selected":"unselected");
        output.append(s + newline);
    }
	

    // Returns just the class name -- no package info.
    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex+1);
    }
/*
	class PopupListener extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
				// show is a method of JPopupMenu
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }	
*/	
	
}
