<%@ Page Language="c#" debug="true" %>
<%@ Import Namespace = "System.Runtime.InteropServices" %>
<script language="c#" runat="server">
  //1.1 SDK interface definitions.
  //==============================================================================================================
  [DllImport("pdf2tiff",  CallingConvention=CallingConvention.StdCall)] 
  public static extern int oakBegin(string lpFileName,string lpOwnerPw,string lpUserPw);
  
  [DllImport("pdf2tiff",  CallingConvention=CallingConvention.StdCall)] 
  public static extern int oakEnd(int nHandle);
   
  [DllImport("pdf2tiff",  CallingConvention=CallingConvention.StdCall)] 
  public static extern int oakExport(int nHandle,int nPageNo);
  
  [DllImport("pdf2tiff",  CallingConvention=CallingConvention.StdCall)] 
  public static extern int oakSetup( int    nHandle,  //Conversion object's handle.
                                          int    nIndex,   //Property tag,refer to the following property definitions.
                                          string lpValue,  //A String value of the property,(or)
                                          int    nValue,   //An integer value of the property.
                                          int    nOther);  //Only valid for progress call-back.
  
  [DllImport("pdf2tiff",  CallingConvention=CallingConvention.StdCall)] 
  public static extern int oakGetPageTotal( int  nHandle, //Conversion object's handle.
                                          ref int nValue);    //An integer value of the property.
  //==============================================================================================================
  
  //1.2 Definitions of converter's properties 
  //==============================================================================================================
  //read/write properties
  const int oak_PROP_OUTDIR       = 1;  //Destination directory.
  const int oak_PROP_PREFIX       = 2;  //The prefix of the name of result image file.
  const int oak_PROP_PAGEZOOM     = 3;  //Zoom scale of the source pdf page.
  const int oak_PROP_BGCOLOR      = 4;  //Image background color.
  const int oak_PROP_IMAGETYPE    = 5;  //Result image format.
  const int oak_PROP_BITCOUNT     = 6;  //Color bits per pixel.
  const int oak_PROP_XDPI         = 7;  //Horizontal resolution.
  const int oak_PROP_YDPI         = 8;  //Vertical resolution.
  const int oak_PROP_QUALITY      = 9;  //JPEG compression quality.
  const int oak_PROP_COMPRESSION  = 10; //TIFF compression mode.
  const int oak_PROP_MULTIPAGES   = 11; //Multipages TIFF file.
  const int oak_PROP_GRAYSCALE    = 12; //Grayscale image.
  const int oak_PROP_XDIMENSIONS  = 13; //The width of the result image in pixel
  const int oak_PROP_YDIMENSIONS  = 14; //The height of the result image in pixel
  
  //read only properties
  const int oak_PROP_PAGECOUNT  = 20; //The total pages of source pdf file.
  const int oak_PROP_PAGEHEIGHT = 21; //Height of the current page of source pdf file.
  const int oak_PROP_PAGEWIDTH  = 22; //Width of the current page of source pdf file.
  //==============================================================================================================
  
  //1.3 TIFF tag's definitions.
  //==============================================================================================================
  const int oak_TIFF_COMPRESSION_NONE     = 0;  //No compression.
  const int oak_TIFF_COMPRESSION_LZW      = 1;  //1,4,8,24bits(default 4,8,24bits)
  const int oak_TIFF_COMPRESSION_JPEG     = 2;  //Grayscale 8bits,24bits
  const int oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
  const int oak_TIFF_COMPRESSION_CCITTG4  = 4;  //1bit(default 1bit)
  const int oak_TIFF_COMPRESSION_CCITTG3  = 5;  //1bit
  const int oak_TIFF_COMPRESSION_RLE      = 6;  //1bit
  //==============================================================================================================
  
  //1.4 Image type's definitions
  //==============================================================================================================
  const int oak_IMAGE_BMP  = 1;   //BMP
  const int oak_IMAGE_EMF  = 2;   //EMF
  const int oak_IMAGE_WMF  = 3;   //WMF
  const int oak_IMAGE_JPG  = 4;   //JPG
  const int oak_IMAGE_PNG  = 5;   //PNG
  const int oak_IMAGE_GIF  = 6;   //GIF
  const int oak_IMAGE_TIF  = 7;   //TIF
  const int oak_IMAGE_PCX  = 8;   //PCX
  
  const int oak_IMAGE_JPEG = 4;   //JPEG
  const int oak_IMAGE_TIFF = 7;   //TIFF
  //==============================================================================================================
  
  //1.5 Return code's definitions.
  //==============================================================================================================
  const int RTN_OK = 1;           //Successful operation.
  const int ERR_UNKNOWN = -99;    //Unknown system error.
  
  const int ERR_OVER_MAXTHREADS    = -1;  //Over the limit amount of threads.
  const int ERR_FILE_UNEXIST       = -2;  //Source PDF file unexist.
  const int ERR_FILE_DAMAGED       = -3;  //Source PDF file is damaged.
  const int ERR_FILE_RESTRICTED    = -4;  //Source PDF file is restricted.
  //==============================================================================================================
  

  //==============================================================================================================
  
  protected void Page_Load(Object Src, EventArgs E) 
  {
      string sPdfFile = "d:\\oak.pdf";
      string sOutDir = "d:\\example";
      
	  //Open pdf document and creating a converter.
	  //After openned successfully, it creates a converter and return a handle of the converter.
      int nHandle = oakBegin(sPdfFile, "", "");
      switch( nHandle ) {
      	case ERR_OVER_MAXTHREADS: { return; } //Over the limit amount of threads,please waiting!
      	case ERR_FILE_UNEXIST:    { return; } //Source pdf file unexist!
      	case ERR_FILE_DAMAGED:    { return; } //Source pdf file damaged!
      	case ERR_FILE_RESTRICTED: { return; } //Source pdf file restricted!
      }
      
      //Setting the converter's propertys.
      //For more, please refer to above definitions.
      oakSetup(nHandle,oak_PROP_OUTDIR,sOutDir,0,0);//output directory

      oakSetup(nHandle,oak_PROP_XDPI,"",130,0);//horizontal dpi
      oakSetup(nHandle,oak_PROP_YDPI,"",130,0);//vertical dpi
      
      //Get the amount of the source pdf pages
      int pValue = 0,iPageCount = 0;
      oakGetPageTotal(nHandle,  ref iPageCount);
      
      //To convert the pdf document.
      for(int iPageNo = 1; iPageNo <= iPageCount; iPageNo++)
      {
          oakExport(nHandle, iPageNo);
      }
      
      //Close pdf file and destory the converter.
      oakEnd(nHandle);
  }
</script>
