<% 
  '1.1 Image type definitions
  '==========================================================================================
  Const oak_IMAGE_BMP  = 1   'BMP
  Const oak_IMAGE_EMF  = 2   'EMF
  Const oak_IMAGE_WMF  = 3   'WMF
  Const oak_IMAGE_JPG  = 4   'JPG
  Const oak_IMAGE_PNG  = 5   'PNG
  Const oak_IMAGE_GIF  = 6   'GIF
  Const oak_IMAGE_TIF  = 7   'TIF
  Const oak_IMAGE_PCX  = 8   'PCX
  
  Const oak_IMAGE_JPEG = 4   'JPEG
  Const oak_IMAGE_TIFF = 7   'TIFF
  '==========================================================================================
 
  '1.2 TIFF tag definitions.
  '==========================================================================================
  Const oak_TIFF_COMPRESSION_NONE     = 0   'No compression.
  Const oak_TIFF_COMPRESSION_LZW      = 1   '1,4,8,24bits(default 4,8,24bits)
  Const oak_TIFF_COMPRESSION_JPEG     = 2   'Grayscale 8bits,24bits
  Const oak_TIFF_COMPRESSION_PACKBITS = 3   '4,8,24bits
  Const oak_TIFF_COMPRESSION_CCITTG4  = 4   '1bit(default 1bit)
  Const oak_TIFF_COMPRESSION_CCITTG3  = 5   '1bit
  Const oak_TIFF_COMPRESSION_RLE      = 6   '1bit
  '==========================================================================================
    
  '1.3 Return code definitions.
  '==========================================================================================
  Const RTN_OK = 1             'Successful operation.
  Const ERR_UNKNOWN = -99      'Unknown system error.

  Const ERR_OVER_MAXTHREADS = -1   'Over the limit amount of threads.
  Const ERR_FILE_UNEXIST    = -2   'Source PDF file unexist.
  Const ERR_FILE_DAMAGED    = -3   'Source PDF file is damaged.
  Const ERR_FILE_RESTRICTED = -4   'Source PDF file is restricted.
  '==========================================================================================
%>

<html>
<head><title>Pdf2Tiff ASP example2!</title></head>
<body>
<%
    'To convert appointed pdf pages of the pdf document.
    Call doMain()
    
'--------------------------------------------------------------------------------------------    
    sub doMain()
        Dim m_Pages
        m_Pages = Array(1, 3, 6, 8, 9, 11)
	    sPdfFile = "d:\\oak.pdf"   'Source PDF document
	    sOutDir = "d:\\example2"         'Output directory
	    
        'Create com object.
	    Set oakPdf2Tiff = Server.CreateObject("oakdoc.pdf2tiff")
	    
	    'Open pdf file and creating a converter.
	    'After openned successfully, it creates a converter and return a handle of the converter.
	    nHandle = oakPdf2Tiff.oakBegin(sPdfFile,"","")
        Select Case nHandle
         Case ERR_OVER_MAXTHREADS
             Response.write "Open '"+sPdfFile+"' failure - Over the limit amount of threads,please waiting!<br>"
             exit sub
         Case ERR_FILE_UNEXIST
             Response.write "Open '"+sPdfFile+"' failure - Source pdf file unexist!<br>"
             exit sub
         Case ERR_FILE_DAMAGED
             Response.write "Open '"+sPdfFile+"' failure - Source pdf file damaged!<br>"
             exit sub
         Case ERR_FILE_RESTRICTED
             Response.write "Open '"+sPdfFile+"' failure - Source pdf file restricted!<br>"
             exit sub
        End Select
	    Response.write "Source PDF File: ["+sPdfFile+"] <br>"
	    Response.write "Output Directory: ["+sOutDir+"] <br>"
	    
        'Setting properties.
        'For more,please refer to user manual.
        oakPdf2Tiff.sOutDirectory = sOutDir  'output directory
        oakPdf2Tiff.iXDPI = 110              'horizontal dpi
        oakPdf2Tiff.iYDPI = 110              'vertical dpi

        oakPdf2Tiff.iMultiPages = 1              'generate multipages tiff
        oakPdf2Tiff.iCompression = oak_TIFF_COMPRESSION_LZW  'lzw compression mode
        
        iPageCount = UBound(m_Pages)
        Response.write "Page Count: ["+cstr(iPageCount+1)+"] <br>"
        
        'To convert the appointed pages of the pdf document.
        For iPos = 0 To iPageCount
		    Response.write "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Converting the page "+cstr(m_Pages(iPos))+"......<br>"
		    oakPdf2Tiff.oakExport nHandle,m_Pages(iPos)
		Next
        
	    'Close pdf file and destory the converter.
	    oakPdf2Tiff.oakEnd nHandle
	    Response.write "Conversion successful!<br>"
    end sub
'--------------------------------------------------------------------------------------------
%>
</body>
</html>