using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices; //requirement class

namespace CShare.Net2005
{
    public partial class MainForm : Form
    {
        //1.1 TIFF compression tag definitions.
        //==========================================================================================
        const int oak_TIFF_COMPRESSION_NONE = 0;  //No compression.
        const int oak_TIFF_COMPRESSION_LZW = 1;  //1,4,8,24bits(default 4,8,24bits)
        const int oak_TIFF_COMPRESSION_JPEG = 2;  //Grayscale 8bits,24bits
        const int oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
        const int oak_TIFF_COMPRESSION_CCITTG4 = 4;  //1bit(default 1bit)
        const int oak_TIFF_COMPRESSION_CCITTG3 = 5;  //1bit
        const int oak_TIFF_COMPRESSION_RLE = 6;  //1bit
        //==========================================================================================

        //1.2 Image type definitions
        //=======================================================================================
        const int oak_IMAGE_BMP = 1;   //BMP
        const int oak_IMAGE_EMF = 2;   //EMF
        const int oak_IMAGE_WMF = 3;   //WMF
        const int oak_IMAGE_JPG = 4;   //JPG
        const int oak_IMAGE_PNG = 5;   //PNG
        const int oak_IMAGE_GIF = 6;   //GIF
        const int oak_IMAGE_TIF = 7;   //TIF
        const int oak_IMAGE_PCX = 8;   //PCX

        const int oak_IMAGE_JPEG = 4;   //JPEG
        const int oak_IMAGE_TIFF = 7;   //TIFF
        //=======================================================================================

        //1.3 Return code definitions.
        //==========================================================================================
        const int RTN_OK = 1;           //Successful operation.
        const int ERR_UNKNOWN = -99;    //Unknown system error.

        const int ERR_OVER_MAXTHREADS = -1;  //Over the limit amount of threads
        const int ERR_FILE_UNEXIST = -2;  //Source PDF file unexist.
        const int ERR_FILE_DAMAGED = -3;  //Source PDF file is damaged.
        const int ERR_FILE_RESTRICTED = -4;  //Source PDF file is restricted.
        //==========================================================================================


        //==============================================================================================================

        //Defining an Pdf2Image ActiveX Control ojbect.
        oak_PDF2TIFF.oakPdf2Tiff m_oakPdf2Tiff;

        public MainForm()
        {
            InitializeComponent();

            //Initialzing  Pdf2Image ActiveX Control object.
            m_oakPdf2Tiff = new oak_PDF2TIFF.oakPdf2TiffClass();
        }

        //example - To convert all pages of the pdf document.
        private void btnDemo1_Click(object sender, EventArgs e)
        {
            String sFileName = "oak.pdf";

            //Open pdf document and creating a converter.
            int nHandle = m_oakPdf2Tiff.oakBegin(sFileName, "", "");
            switch (nHandle)
            {
                case ERR_OVER_MAXTHREADS: { MessageBox.Show("Over the limit amount of threads,please waiting!"); return; };
                case ERR_FILE_UNEXIST: { MessageBox.Show("Source pdf file unexist!"); return; };
                case ERR_FILE_DAMAGED: { MessageBox.Show("Source pdf file damaged!"); return; };
                case ERR_FILE_RESTRICTED: { MessageBox.Show("Source pdf file restricted!"); return; };
            }

            //Setting proerties.
            m_oakPdf2Tiff.sOutDirectory = "output";

            m_oakPdf2Tiff.iXDPI = 130;
            m_oakPdf2Tiff.iYDPI = 130;

            //To convert all pages of the pdf document.
            long iPageCount = m_oakPdf2Tiff.oakGetPageTotal(nHandle);
            for (int iPageNo = 1; iPageNo <= iPageCount; iPageNo++)
            {
                m_oakPdf2Tiff.oakExport(nHandle, iPageNo);

                //Setting conversion's progress.
                m_ProgressBar.Value = (int)((iPageNo * 1.0) / iPageCount * 100);
            }

            //Close pdf document and destory the converter.
            m_oakPdf2Tiff.oakEnd(nHandle);

            MessageBox.Show("Conversion successful");
        }


    }
}