//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "direct.h"
#include "stdio.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "oak_PDF2TIFF_OCX"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    //To create the com object.
    m_poakPdf2Tiff = new ToakPdf2Tiff(this);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
    //To free the com object.
    if( m_poakPdf2Tiff != NULL ){
        delete m_poakPdf2Tiff;
    }
}
//---------------------------------------------------------------------------
//example - To convert all pages of the pdf document.
void __fastcall TMainForm::btnDemo1Click(TObject *Sender)
{

    AnsiString sFileName = "oak.pdf";


    //Open pdf document and creating a converter.
    long nHandle = m_poakPdf2Tiff->oakBegin((WideString)sFileName, NULL, NULL);
    switch( nHandle ){
     case ERR_OVER_MAXTHREADS:{ ShowMessage("Over the limit amount of threads,please waiting!"); return; };
     case ERR_FILE_UNEXIST:{ ShowMessage("Source pdf file unexist!"); return; };
     case ERR_FILE_DAMAGED:{ ShowMessage("Source pdf file damaged!"); return; };
     case ERR_FILE_RESTRICTED:{ ShowMessage("Source pdf file restricted!"); return; };
    }

    //Setting proerties.
    m_poakPdf2Tiff->sOutDirectory = "./output";

    m_poakPdf2Tiff->iXDPI = 130;
    m_poakPdf2Tiff->iYDPI = 130;

    //To convert all pages of the pdf document.
    long iPageCount = m_poakPdf2Tiff->oakGetPageTotal(nHandle);
    for(int iPageNo = 1; iPageNo <= iPageCount; iPageNo++){
       m_poakPdf2Tiff->oakExport(nHandle,iPageNo);

       //Setting conversion's progress.
       m_ProgressBar->Position = (long)((iPageNo)*1.0/iPageCount*100);
    }

    //Close pdf document and destory the converter.
    m_poakPdf2Tiff->oakEnd(nHandle);

    ShowMessage("Conversion successful");
}
//---------------------------------------------------------------------------

