//1.1 TIFF compression tag definitions.
//==========================================================================================
const long oak_TIFF_COMPRESSION_NONE     = 0;  //No compression.
const long oak_TIFF_COMPRESSION_LZW      = 1;  //1,4,8,24bits(default 4,8,24bits)
const long oak_TIFF_COMPRESSION_JPEG     = 2;  //Grayscale 8bits,24bits
const long oak_TIFF_COMPRESSION_PACKBITS = 3;  //4,8,24bits
const long oak_TIFF_COMPRESSION_CCITTG4  = 4;  //1bit(default 1bit)
const long oak_TIFF_COMPRESSION_CCITTG3  = 5;  //1bit
const long oak_TIFF_COMPRESSION_RLE      = 6;  //1bit
//==========================================================================================

//1.2 Image type definitions
//=======================================================================================
const long oak_IMAGE_BMP  = 1;   //BMP
const long oak_IMAGE_EMF  = 2;   //EMF
const long oak_IMAGE_WMF  = 3;   //WMF
const long oak_IMAGE_JPG  = 4;   //JPG
const long oak_IMAGE_PNG  = 5;   //PNG
const long oak_IMAGE_GIF  = 6;   //GIF
const long oak_IMAGE_TIF  = 7;   //TIF
const long oak_IMAGE_PCX  = 8;   //PCX

const long oak_IMAGE_JPEG = 4;   //JPEG
const long oak_IMAGE_TIFF = 7;   //TIFF
//=======================================================================================

//1.3 Return code definitions.
//==========================================================================================
const long RTN_OK = 1;           //Successful operation.
const long ERR_UNKNOWN = -99;    //Unknown system error.

const long ERR_OVER_MAXTHREADS    = -1;  //Over the limit amount of threads
const long ERR_FILE_UNEXIST       = -2;  //Source PDF file unexist.
const long ERR_FILE_DAMAGED       = -3;  //Source PDF file is damaged.
const long ERR_FILE_RESTRICTED    = -4;  //Source PDF file is restricted.

const long ERR_INVALID_PAGE    = -5;   //The PDF page is invalid.
const long ERR_CONVERT_FAILURE = -8;   //Conversion failure.
const long ERR_INVALID_STREAM  = -9;   //Invalid memory stream address.
const long ERR_INVALID_HANDLE  = -10;  //The handle of conversion object is invalid.
//==========================================================================================
