unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, oak_PDF2TIFF_TLB, oak_define2, Gauges,
  ComCtrls;

type
  TMainForm = class(TForm)
    btnDemo1: TButton;
    m_ProgressBar: TProgressBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnDemo1Click(Sender: TObject);

  private
    { Private declarations }
    m_oakPdf2Tiff: ToakPdf2Tiff;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
begin
   //To create the com object.
   m_oakPdf2Tiff := ToakPdf2Tiff.Create(nil);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
   //To free the com object.
   if( m_oakPdf2Tiff <> nil) then
       m_oakPdf2Tiff.Free;
end;

//Demo1 - To convert all pages of the pdf document.
procedure TMainForm.btnDemo1Click(Sender: TObject);
var
   sFileName: String;
   nHandle,iPageNo,iPageCount: Integer;
begin
   sFileName := 'oak.pdf';

   //Open pdf document and creating a converter.
   nHandle := m_oakPdf2Tiff.oakBegin(WideString(sFileName),'','');
   case nHandle of
     ERR_OVER_MAXTHREADS:
       begin ShowMessage('Over the limit amount of threads,please waiting!'); exit; end;
     ERR_FILE_UNEXIST:
       begin ShowMessage('Source pdf file unexist!'); exit; end;
     ERR_FILE_DAMAGED:
       begin ShowMessage('Source pdf file damaged!'); exit; end;
     ERR_FILE_RESTRICTED:
       begin ShowMessage('Source pdf file restricted!'); exit; end;
   end;

   //Setting proerties.
   m_oakPdf2Tiff.sOutDirectory := './output';

   m_oakPdf2Tiff.iXDPI := 130;
   m_oakPdf2Tiff.iYDPI := 130;

   //To convert all pages of the pdf document.
   iPageCount := m_oakPdf2Tiff.oakGetPageTotal(nHandle);
   for iPageNo := 1 to iPageCount do
   begin
       m_oakPdf2Tiff.oakExport(nHandle,iPageNo);

       //Setting conversion's progress.
       m_ProgressBar.Position := Round((iPageNo)*1.0/iPageCount*100);
   end;

   //Close pdf document and destory the converter.
   m_oakPdf2Tiff.oakEnd(nHandle);

   ShowMessage('Conversion successful');
end;



end.
