Public Class MainForm
    '1.1 TIFF compression tag's definitions.
    '==========================================================================================
    Const oak_TIFF_COMPRESSION_NONE = 0      'No compression.
    Const oak_TIFF_COMPRESSION_LZW = 1       '1,4,8,24bits(default 4,8,24bits)
    Const oak_TIFF_COMPRESSION_JPEG = 2      'Grayscale 8bits,24bits
    Const oak_TIFF_COMPRESSION_PACKBITS = 3  '4,8,24bits
    Const oak_TIFF_COMPRESSION_CCITTG4 = 4   '1bit(default 1bit)
    Const oak_TIFF_COMPRESSION_CCITTG3 = 5   '1bit
    Const oak_TIFF_COMPRESSION_RLE = 6       '1bit
    '==========================================================================================

    '1.2 Image type's definitions
    '=======================================================================================
    Const oak_IMAGE_BMP = 1    'BMP
    Const oak_IMAGE_EMF = 2    'EMF
    Const oak_IMAGE_WMF = 3    'WMF
    Const oak_IMAGE_JPG = 4    'JPG
    Const oak_IMAGE_PNG = 5    'PNG
    Const oak_IMAGE_GIF = 6    'GIF
    Const oak_IMAGE_TIF = 7    'TIF
    Const oak_IMAGE_PCX = 8    'PCX

    Const oak_IMAGE_JPEG = 4   'JPEG
    Const oak_IMAGE_TIFF = 7   'TIFF
    '=======================================================================================

    '1.3 Return code's definitions.
    '==========================================================================================
    Const RTN_OK = 1           'Successful operation.
    Const ERR_UNKNOWN = -99    'Unknown system error.

    Const ERR_OVER_MAXTHREADS = -1     'Over the limit amount of threads
    Const ERR_FILE_UNEXIST = -2        'Source PDF file unexist.
    Const ERR_FILE_DAMAGED = -3        'Source PDF file is damaged.
    Const ERR_FILE_RESTRICTED = -4     'Source PDF file is restricted.

    Const ERR_INVALID_PAGE = -5      'The PDF page is invalid.
    Const ERR_CONVERT_FAILURE = -8   'Conversion failure.
    Const ERR_INVALID_STREAM = -9    'Invalid memory stream address.
    Const ERR_INVALID_HANDLE = -10   'Invalid converter's handle.
    '==========================================================================================


    '1.4 Windows API definitions.
    '==========================================================================================
    Private Declare Function GetCurrentProcess Lib "kernel32" () As Integer
    Private Declare Function ReadProcessMemory Lib "kernel32" (ByVal hProcess As Integer, ByVal lpBaseAddress As Integer, ByVal lpBuffer() As Byte, ByVal nSize As Integer, ByRef lpNumberOfBytesWritten As Integer) As Integer
    '==========================================================================================

    'Example - To convert all pages of the pdf document.
    Private Sub btnDemo1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDemo1.Click
        Dim m_oakPdf2Tiff As New oak_PDF2TIFF.oakPdf2Tiff
        Dim nHandle As Integer
        Dim sFileName As String
        Dim iPageNo, iPageCount As Integer

        sFileName = "oak.pdf"

        'Open pdf document and creating a converter.
        nHandle = m_oakPdf2Tiff.oakBegin(sFileName, "", "")
        Select Case nHandle
            Case ERR_OVER_MAXTHREADS
                MsgBox("Over the limit amount of threads,please waiting!")
                Exit Sub
            Case ERR_FILE_UNEXIST
                MsgBox("Source pdf file unexist!")
                Exit Sub
            Case ERR_FILE_DAMAGED
                MsgBox("Source pdf file damaged!")
                Exit Sub
            Case ERR_FILE_RESTRICTED
                MsgBox("Source pdf file restricted!")
                Exit Sub
        End Select

        'Setting proerties.
        m_oakPdf2Tiff.sOutDirectory = "./output"

        m_oakPdf2Tiff.iXDPI = 130
        m_oakPdf2Tiff.iYDPI = 130

        'To convert all pages of the pdf document.
        iPageCount = m_oakPdf2Tiff.oakGetPageTotal(nHandle)
        For iPageNo = 1 To iPageCount
            m_oakPdf2Tiff.oakExport(nHandle, iPageNo)

            'Setting conversion's progress.
            m_ProgressBar.Value = Math.Round((iPageNo * 1.0#) / iPageCount * 100)
        Next

        'Close pdf document and destory the converter.
        m_oakPdf2Tiff.oakEnd(nHandle)


        MsgBox("Conversion successful")
    End Sub


End Class
