// demo_vcDlg.cpp : implementation file
//

#include "stdafx.h"
#include "demo_vc.h"
#include "demo_vcDlg.h"

#include "oakpdf2tiff.h"
#include "oak_define2.h"
#include "direct.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_vcDlg dialog

CDemo_vcDlg::CDemo_vcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemo_vcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemo_vcDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemo_vcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemo_vcDlg)
	DDX_Control(pDX, IDC_PROGRESS_BAR, m_Progress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemo_vcDlg, CDialog)
	//{{AFX_MSG_MAP(CDemo_vcDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_DEMO1, OnButtonDemo1)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_vcDlg message handlers

BOOL CDemo_vcDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDemo_vcDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemo_vcDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemo_vcDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

//Demo1 - To convert all pages of the pdf document.
void CDemo_vcDlg::OnButtonDemo1() 
{
	// TODO: Add your control notification handler code here
	long nHandle;
	char sFileName[] = "oak.pdf";


	//Creating and Loading Pdf2Image ActiveX Control object.
	CoakPdf2Tiff m_oakPdf2Tiff;
	m_oakPdf2Tiff.Create("OakPdf2tiff",WS_CHILD,CRect(0,0,0,0),this,12345);
	
	//Open pdf document and creating a converter.
	nHandle = m_oakPdf2Tiff.oakBegin(sFileName,NULL,NULL);
	switch( nHandle ){
		case ERR_OVER_MAXTHREADS:{ 
			MessageBox("Over the limit amount of threads,please waiting!","demo",MB_OK); 
			return; 
		}
		case ERR_FILE_UNEXIST:{
			MessageBox("Source pdf file unexist!","demo",MB_OK);
			return;
		}
		case ERR_FILE_DAMAGED:{
			MessageBox("Source pdf file damaged!","demo",MB_OK);
			return;
		}
		case ERR_FILE_RESTRICTED:{
			MessageBox("Source pdf file restricted!","demo",MB_OK);
			return;
		}
	}
    
	//Setting proerties.
	//For more information about properties,please refer to 'axpdf2image.h'.
	m_oakPdf2Tiff.SetSOutDirectory("output");

    m_oakPdf2Tiff.SetIXDPI(130);
	m_oakPdf2Tiff.SetIYDPI(130);

    //To convert all pages of the pdf document.
    long iPageCount = m_oakPdf2Tiff.oakGetPageTotal(nHandle);
    for(int iPageNo = 1; iPageNo <= iPageCount; iPageNo++){
       m_oakPdf2Tiff.oakExport(nHandle,iPageNo);

       //Setting conversion's progress.
       m_Progress.SetPos((long)(iPageNo*1.0/iPageCount*100));
    }

	//Close pdf document and destory the converter.
	m_oakPdf2Tiff.oakEnd(nHandle);
	m_oakPdf2Tiff.DestroyWindow();


	char sMessage[256];
	sprintf(sMessage,"Conversion successful");
	MessageBox(sMessage,"demo",MB_OK);
}

