//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "direct.h"
#include "stdio.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//The progress's call-back function.
//To set conversion progress.
void GGetProgress(long nOther,long iProgress)
{
    TMainForm *pThis = (TMainForm *)nOther;
    pThis->m_ProgressBar->Position = iProgress;
}

//Demo1 - Convert all pdf pages.
void __fastcall TMainForm::btnDemo1Click(TObject *Sender)
{
    char sPdfFile[] = "oak.pdf";
    long nHandle;

    //Loading dynamic link library---pdf2tiff.dll.
    if( LoadDLL() == FALSE ){
        ShowMessage("Loading dynamic link library---pdf2tiff.dll failure!");
        return;
    }
                        
    //Open pdf file and creating a converter.
    nHandle = oakBegin(sPdfFile,NULL,NULL);
    switch( nHandle ){
    case ERR_OVER_MAXTHREADS: {
        ShowMessage("Over the limit amount of threads,please waiting!");
        FreeDLL(); return;
    }
    case ERR_FILE_UNEXIST: {
        ShowMessage("Source pdf file unexist!");
        FreeDLL(); return;
    }
    case ERR_FILE_DAMAGED: {
        ShowMessage("Source pdf file damaged!");
        FreeDLL(); return;
    }
    case ERR_FILE_RESTRICTED: {
        ShowMessage("Source pdf file restricted!");
        FreeDLL(); return;
    }}

    //Setting the converter's proerties.

    oakSetup(nHandle,oak_PROP_OUTDIR,"./output1",0,0);//output directory
    oakSetup(nHandle,oak_PROP_PREFIX,"myimg",0,0);//prefix of image file name

    oakSetup(nHandle,oak_PROP_XDPI,NULL,120,0);//horizontal dpi
    oakSetup(nHandle,oak_PROP_YDPI,NULL,120,0);//vertical dpi
    
    //Setting the progress's call-back function.
    //The last parameter will be used to call-back function as a parameter value.
    oakSetup(nHandle,oak_PROP_PROGRESSFUNC,NULL,(long)GGetProgress,(long)this);

    //To convert the pdf file.
    oakExport(nHandle,0);

    //Close pdf file and destory the converter.
    oakEnd(nHandle);

    ShowMessage("Conversion successful");

    FreeDLL();
}

//---------------------------------------------------------------------------
//Demo2 - Convert appointed pdf pages.
void __fastcall TMainForm::btnDemo2Click(TObject *Sender)
{
    char sPdfFile[] = "oak.pdf";
    long m_Pages[] = {7,7,19,15,2};
    long nHandle;

    //Loading dynamic link library---pdf2tiff.dll.
    if( LoadDLL() == FALSE ){
        ShowMessage("Loading dynamic link library---pdf2tiff.dll failure!");
        return;
    }

    //Open pdf file and creating a converter.
    nHandle = oakBegin(sPdfFile,NULL,NULL);
    switch( nHandle ){
    case ERR_OVER_MAXTHREADS: {
        ShowMessage("Over the limit amount of threads,please waiting!");
        FreeDLL(); return;
    }
    case ERR_FILE_UNEXIST: {
        ShowMessage("Source pdf file unexist!");
        FreeDLL(); return;
    }
    case ERR_FILE_DAMAGED: {
        ShowMessage("Source pdf file damaged!");
        FreeDLL(); return;
    }
    case ERR_FILE_RESTRICTED: {
        ShowMessage("Source pdf file restricted!");
        FreeDLL(); return;
    }}

    //Setting the converter's propertys.
    oakSetup(nHandle,oak_PROP_OUTDIR,"./output2",0,0);//output directory

    oakSetup(nHandle,oak_PROP_BITCOUNT,NULL,24,0);//color bits
    oakSetup(nHandle,oak_PROP_XDPI,NULL,150,0);//horizontal dpi
    oakSetup(nHandle,oak_PROP_YDPI,NULL,150,0);//vertical dpi
    oakSetup(nHandle,oak_PROP_COMPRESSION,NULL,oak_TIFF_COMPRESSION_LZW,0);//tiff compression mode
    oakSetup(nHandle,oak_PROP_MULTIPAGES,NULL,TRUE,0);//multipages tiff.

    //To convert the appointed pages of the pdf file.
    int iPageCount = sizeof(m_Pages)/sizeof(long);
    for(int iPos = 0; iPos < iPageCount; iPos++){
        oakExport(nHandle,m_Pages[iPos]);

        //Setting conversion's progress.
        m_ProgressBar->Position = (long)((iPos+1)*1.0/iPageCount*100);
    }

    //Close pdf file and destory the converter.
    oakEnd(nHandle);

    ShowMessage("Conversion successful");

    FreeDLL();
}
//---------------------------------------------------------------------------


//Load dynamic link library---pdf2tiff.dll!
BOOL TMainForm::LoadDLL(){
	char sDllFile[]="pdf2tiff.dll";

	m_hDll = LoadLibrary(sDllFile);
	if( m_hDll == NULL ) return FALSE;

	oakBegin = (_oakBegin *)GetProcAddress(m_hDll, "oakBegin");
	if( oakBegin == NULL ) goto ERR_FLAG;

	oakEnd = (_oakEnd *)GetProcAddress(m_hDll, "oakEnd");
	if( oakEnd == NULL ) goto ERR_FLAG;

	oakExport = (_oakExport *)GetProcAddress(m_hDll, "oakExport");
	if( oakExport == NULL ) goto ERR_FLAG;

	oakSetup = (_oakSetup *)GetProcAddress(m_hDll, "oakSetup");
	if( oakSetup == NULL ) goto ERR_FLAG;

	oakGetPageTotal = (_oakGetPageTotal *)GetProcAddress(m_hDll, "oakGetPageTotal");
	if( oakGetPageTotal == NULL ) goto ERR_FLAG;

	return TRUE;
ERR_FLAG:
	FreeDLL();
	return FALSE;
}

//Free dynamic link library---pdf2tiff.dll!
BOOL TMainForm::FreeDLL(){
	if( m_hDll ){
        FreeLibrary(m_hDll);
        m_hDll = NULL;
		oakBegin = NULL;
		oakEnd = NULL;
		oakExport = NULL;
		oakSetup = NULL;
		oakGetPageTotal = NULL;
	}
	return TRUE;
}

